/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminClear
extends KCommandBase {
    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.clear");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        sender.sendMessage("[Kingdoms] Only players can execute this command!");
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Land land = GameManagement.getLandManager().getOrLoadLand(kp.getLoc());
        String owner = land.getOwner();
        if (owner == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Clear_Land_Empty));
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(owner);
        if (kingdom != null) {
            GameManagement.getLandManager().unclaimLand(kp.getLoc(), kingdom);
        } else {
            GameManagement.getLandManager().unclaimLand(kp.getLoc(), null);
        }
        GameManagement.getVisualManager().visualizeLand(kp, land.getLoc());
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Clear_Success));
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_Unclaim);
    }
}

