/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi.updater;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import ru.beykerykt.lightapi.updater.Response;
import ru.beykerykt.lightapi.updater.UpdaterRunnable;
import ru.beykerykt.lightapi.updater.Version;

public class Updater {
    protected static Pattern regex = Pattern.compile("(?:[v]?)([0-9]+)\\.([0-9]+)\\.([0-9]+)(?:-([0-9A-Za-z-]+(?:\\.[0-9A-Za-z-]+)*))?(?:\\+[0-9A-Za-z-]+)?", 2);
    protected static String api = "https://api.github.com/repos/{{ REPOSITORY }}/releases";
    private Response result = Response.NO_UPDATE;
    private String agent = "Albioncode";
    private String repository = null;
    private boolean verbose = false;
    private Version version;
    private Version current;
    private Thread thread;
    private URL url;
    private String body;

    public Updater(int major, int minor, int patch, String repository) throws Exception {
        this(Version.parse(String.valueOf(major) + "." + minor + "." + patch), repository, false);
    }

    public Updater(int major, int minor, int patch, String repository, boolean verbose) throws Exception {
        this(Version.parse(String.valueOf(major) + "." + minor + "." + patch), repository, verbose);
    }

    public Updater(String version, String repository) throws Exception {
        this(Version.parse(version), repository, false);
    }

    public Updater(String version, String repository, boolean verbose) throws Exception {
        this(Version.parse(version), repository, verbose);
    }

    public Updater(Version version, String repository) throws Exception {
        this(version, repository, false);
    }

    public Updater(Version version, String repository, boolean verbose) throws Exception {
        if (version == null) {
            throw new Exception("Provided version is not semver compliant!");
        }
        this.repository = repository;
        this.current = version;
        this.verbose = verbose;
        try {
            this.url = new URL(api.replace("{{ REPOSITORY }}", this.repository));
            this.log(Level.INFO, "Set the URL to get");
        }
        catch (NumberFormatException ex) {
            this.log(Level.SEVERE, "Unable to parse semver string!");
            throw new Exception("Unable to parse semver string!");
        }
        catch (MalformedURLException ex) {
            this.log(Level.SEVERE, "Invalid URL, return failed response.");
            this.result = Response.FAILED;
            throw new Exception(ex.getMessage());
        }
        if (this.result != Response.FAILED) {
            this.thread = new Thread(new UpdaterRunnable(this));
            this.thread.start();
        }
    }

    private void run() {
        try {
            String line;
            URLConnection connection = this.url.openConnection();
            connection.setConnectTimeout(6000);
            connection.addRequestProperty("Accept", "application/vnd.github.v3+json");
            this.log(Level.INFO, "Opening connection to API");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            JSONArray releases = (JSONArray)JSONValue.parse((String)buffer.toString());
            this.log(Level.INFO, "Parsing the returned JSON");
            if (releases.isEmpty()) {
                this.log(Level.WARNING, "Appears there were no releases, setting result");
                this.result = Response.REPO_NO_RELEASES;
                return;
            }
            JSONObject release = (JSONObject)releases.get(0);
            String tag = release.get((Object)"tag_name").toString();
            String body = release.get((Object)"body").toString();
            if (Updater.isSemver(tag)) {
                this.version = Version.parse(tag);
                this.body = body;
                if (this.current.compare(this.version)) {
                    this.log(Level.INFO, "Hooray, we found a semver compliant update!");
                    this.result = Response.SUCCESS;
                } else {
                    this.log(Level.INFO, "The version you specified is the latest version available!");
                    this.result = Response.NO_UPDATE;
                }
            } else {
                this.log(Level.WARNING, "Version string is not semver compliant!");
                this.result = Response.REPO_NOT_SEMVER;
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.log(Level.WARNING, "GitHub denied our HTTP request!");
                this.result = Response.GITHUB_DENY;
            }
            if (e.getMessage().contains("HTTP response code: 404")) {
                this.log(Level.WARNING, "The specified repository could not be found!");
                this.result = Response.REPO_NOT_FOUND;
            }
            if (e.getMessage().contains("HTTP response code: 500")) {
                this.log(Level.WARNING, "Internal server error");
                this.result = Response.GITHUB_ERROR;
            }
            this.log(Level.SEVERE, "Failed to check for updates!");
            this.result = Response.FAILED;
            this.version = null;
        }
    }

    private void exit(Response response) {
        if (response != Response.SUCCESS) {
            this.result = response;
            this.version = null;
        }
    }

    public String getLatestVersion() {
        this.waitForThread();
        if (this.version == null) {
            this.log(Level.INFO, "Latest version is undefined, return message.");
            return "Please check #getResult()";
        }
        this.log(Level.INFO, "Somebody queried the latest version");
        return this.version.toString();
    }

    public Response getResult() {
        this.log(Level.INFO, "Somebody queried the update result");
        this.waitForThread();
        return this.result;
    }

    public String getRepository() {
        this.log(Level.INFO, "Somebody queried the repository");
        return this.repository;
    }

    private void waitForThread() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.join();
                this.log(Level.INFO, "Trying to join thread");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSemver(String version) {
        return regex.matcher(version).matches();
    }

    private void log(Level level, String message) {
        if (this.verbose) {
            String msg = String.format("[%s] %s", level.toString().toUpperCase(), message);
            if (level != Level.SEVERE) {
                System.out.println(msg);
            } else {
                System.err.println(msg);
            }
        }
    }

    public String getChanges() {
        return this.body;
    }

    public Version getVersion() {
        this.waitForThread();
        if (this.version == null) {
            this.log(Level.INFO, "Latest version is undefined, return message.");
            return null;
        }
        this.log(Level.INFO, "Somebody queried the latest version");
        return this.version;
    }
}

