/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import ru.beykerykt.lightapi.LightAPI;
import ru.beykerykt.lightapi.server.ServerModInfo;
import ru.beykerykt.lightapi.server.nms.INMSHandler;

public class ServerModManager {
    private static Map<String, ServerModInfo> supportImpl = new ConcurrentHashMap<String, ServerModInfo>();
    private static INMSHandler handler;

    public static void init() {
        ServerModInfo impl;
        String modName;
        if (handler != null) {
            handler = null;
        }
        if (!supportImpl.containsKey(modName = Bukkit.getVersion().split("-")[1])) {
            modName = Bukkit.getName();
        }
        if ((impl = supportImpl.get(modName)) != null) {
            block7: {
                try {
                    String folder_version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
                    if (impl.getVersions().containsKey(folder_version)) {
                        Class<? extends INMSHandler> clazz = impl.getVersions().get(folder_version);
                        if (INMSHandler.class.isAssignableFrom(clazz)) {
                            handler = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        break block7;
                    }
                    throw new Exception("Unknown version.");
                }
                catch (Exception e) {
                    LightAPI.getInstance().log((CommandSender)Bukkit.getConsoleSender(), "Could not find handler for this " + Bukkit.getVersion() + " version.");
                    return;
                }
            }
            LightAPI.getInstance().log((CommandSender)Bukkit.getConsoleSender(), "Loading handler for " + impl.getModName() + " " + Bukkit.getVersion());
            return;
        }
        LightAPI.getInstance().log((CommandSender)Bukkit.getConsoleSender(), "Could not find handler for this Bukkit implementation.");
    }

    public static boolean registerServerMod(ServerModInfo info) {
        if (supportImpl.containsKey(info.getModName())) {
            return false;
        }
        supportImpl.put(info.getModName(), info);
        return true;
    }

    public static boolean unregisterServerMod(String modName) {
        if (supportImpl.containsKey(modName)) {
            return false;
        }
        supportImpl.remove(modName);
        return true;
    }

    public static INMSHandler getNMSHandler() {
        return handler;
    }
}

