/*
 * Decompiled with CFR 0.152.
 */
package ru.beykerykt.lightapi;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.beykerykt.lightapi.chunks.ChunkCache;
import ru.beykerykt.lightapi.chunks.ChunkInfo;
import ru.beykerykt.lightapi.events.DeleteLightEvent;
import ru.beykerykt.lightapi.events.SetLightEvent;
import ru.beykerykt.lightapi.events.UpdateChunkEvent;
import ru.beykerykt.lightapi.request.DataRequest;
import ru.beykerykt.lightapi.request.RequestSteamMachine;
import ru.beykerykt.lightapi.server.ServerModInfo;
import ru.beykerykt.lightapi.server.ServerModManager;
import ru.beykerykt.lightapi.server.nms.craftbukkit.CraftBukkit_v1_10_R1;
import ru.beykerykt.lightapi.server.nms.craftbukkit.CraftBukkit_v1_11_R1;
import ru.beykerykt.lightapi.server.nms.craftbukkit.CraftBukkit_v1_8_R3;
import ru.beykerykt.lightapi.server.nms.craftbukkit.CraftBukkit_v1_9_R1;
import ru.beykerykt.lightapi.server.nms.craftbukkit.CraftBukkit_v1_9_R2;
import ru.beykerykt.lightapi.server.nms.paperspigot.PaperSpigot_v1_8_R3;
import ru.beykerykt.lightapi.updater.Response;
import ru.beykerykt.lightapi.updater.UpdateType;
import ru.beykerykt.lightapi.updater.Updater;
import ru.beykerykt.lightapi.updater.Version;
import ru.beykerykt.lightapi.utils.BungeeChatHelperClass;
import ru.beykerykt.lightapi.utils.Metrics;

public class LightAPI
extends JavaPlugin
implements Listener {
    private static LightAPI plugin;
    private static RequestSteamMachine machine;
    private int configVer = 3;
    private int update_delay_ticks;
    private int max_iterations_per_tick;
    private boolean enableUpdater;
    private String repo = "BeYkeRYkt/LightAPI";
    private int delayUpdate = 40;
    private boolean viewChangelog;
    private static BlockFace[] SIDES;

    static {
        SIDES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    }

    public void onLoad() {
        plugin = this;
        machine = new RequestSteamMachine();
        ServerModInfo craftbukkit = new ServerModInfo("CraftBukkit");
        craftbukkit.getVersions().put("v1_8_R3", CraftBukkit_v1_8_R3.class);
        craftbukkit.getVersions().put("v1_9_R1", CraftBukkit_v1_9_R1.class);
        craftbukkit.getVersions().put("v1_9_R2", CraftBukkit_v1_9_R2.class);
        craftbukkit.getVersions().put("v1_10_R1", CraftBukkit_v1_10_R1.class);
        craftbukkit.getVersions().put("v1_11_R1", CraftBukkit_v1_11_R1.class);
        ServerModManager.registerServerMod(craftbukkit);
        ServerModInfo spigot = new ServerModInfo("Spigot");
        spigot.getVersions().put("v1_8_R3", CraftBukkit_v1_8_R3.class);
        spigot.getVersions().put("v1_9_R1", CraftBukkit_v1_9_R1.class);
        spigot.getVersions().put("v1_9_R2", CraftBukkit_v1_9_R2.class);
        spigot.getVersions().put("v1_10_R1", CraftBukkit_v1_10_R1.class);
        spigot.getVersions().put("v1_11_R1", CraftBukkit_v1_11_R1.class);
        ServerModManager.registerServerMod(spigot);
        ServerModInfo paperspigot = new ServerModInfo("PaperSpigot");
        paperspigot.getVersions().put("v1_8_R3", PaperSpigot_v1_8_R3.class);
        ServerModManager.registerServerMod(paperspigot);
        ServerModInfo paper = new ServerModInfo("Paper");
        paper.getVersions().put("v1_9_R1", CraftBukkit_v1_9_R1.class);
        paper.getVersions().put("v1_9_R2", CraftBukkit_v1_9_R2.class);
        paper.getVersions().put("v1_10_R1", CraftBukkit_v1_10_R1.class);
        paper.getVersions().put("v1_11_R1", CraftBukkit_v1_11_R1.class);
        ServerModManager.registerServerMod(paper);
        ServerModInfo tacospigot = new ServerModInfo("TacoSpigot");
        tacospigot.getVersions().put("v1_9_R1", CraftBukkit_v1_9_R1.class);
        tacospigot.getVersions().put("v1_9_R2", CraftBukkit_v1_9_R2.class);
        tacospigot.getVersions().put("v1_10_R1", CraftBukkit_v1_10_R1.class);
        tacospigot.getVersions().put("v1_11_R1", CraftBukkit_v1_11_R1.class);
        ServerModManager.registerServerMod(tacospigot);
    }

    public void onEnable() {
        try {
            FileConfiguration fc = this.getConfig();
            File file = new File(this.getDataFolder(), "config.yml");
            if (file.exists()) {
                if (fc.getInt("version") < this.configVer) {
                    file.delete();
                    this.generateConfig(file);
                }
            } else {
                this.generateConfig(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.update_delay_ticks = this.getConfig().getInt("update-delay-ticks");
        this.max_iterations_per_tick = this.getConfig().getInt("max-iterations-per-tick");
        this.enableUpdater = this.getConfig().getBoolean("updater.enable");
        this.repo = this.getConfig().getString("updater.repo");
        this.delayUpdate = this.getConfig().getInt("updater.update-delay-ticks");
        this.viewChangelog = this.getConfig().getBoolean("updater.view-changelog");
        ServerModManager.init();
        machine.start(LightAPI.getInstance().getUpdateDelayTicks(), LightAPI.getInstance().getMaxIterationsPerTick());
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.enableUpdater) {
            this.runUpdater((CommandSender)this.getServer().getConsoleSender(), this.delayUpdate);
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onDisable() {
        machine.shutdown();
        ChunkCache.CHUNK_INFO_QUEUE.clear();
    }

    public void log(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.AQUA + "<LightAPI>: " + ChatColor.WHITE + message);
    }

    public static LightAPI getInstance() {
        return plugin;
    }

    public static boolean createLight(Location location, int lightlevel, boolean async) {
        return LightAPI.createLight(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lightlevel, async);
    }

    public static boolean createLight(World world, int x, int y, int z, int lightlevel, boolean async) {
        if (LightAPI.getInstance().isEnabled()) {
            final SetLightEvent event = new SetLightEvent(world, x, y, z, lightlevel, async);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Block adjacent = LightAPI.getAdjacentAirBlock(world.getBlockAt(event.getX(), event.getY(), event.getZ()));
                final int lx = adjacent.getX();
                final int ly = adjacent.getY();
                final int lz = adjacent.getZ();
                if (event.isAsync()) {
                    machine.addToQueue(new DataRequest(){

                        @Override
                        public void process() {
                            ServerModManager.getNMSHandler().createLight(event.getWorld(), event.getX(), event.getY(), event.getZ(), event.getLightLevel());
                            ServerModManager.getNMSHandler().recalculateLight(event.getWorld(), lx, ly, lz);
                        }
                    });
                    return true;
                }
                ServerModManager.getNMSHandler().createLight(event.getWorld(), event.getX(), event.getY(), event.getZ(), event.getLightLevel());
                ServerModManager.getNMSHandler().recalculateLight(event.getWorld(), lx, ly, lz);
                return true;
            }
        }
        return false;
    }

    public static boolean deleteLight(Location location, boolean async) {
        return LightAPI.deleteLight(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), async);
    }

    public static boolean deleteLight(World world, int x, int y, int z, boolean async) {
        if (LightAPI.getInstance().isEnabled()) {
            final DeleteLightEvent event = new DeleteLightEvent(world, x, y, z, async);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (event.isAsync()) {
                    machine.addToQueue(new DataRequest(){

                        @Override
                        public void process() {
                            ServerModManager.getNMSHandler().deleteLight(event.getWorld(), event.getX(), event.getY(), event.getZ());
                        }
                    });
                    return true;
                }
                ServerModManager.getNMSHandler().deleteLight(event.getWorld(), event.getX(), event.getY(), event.getZ());
                return true;
            }
        }
        return false;
    }

    public static List<ChunkInfo> collectChunks(Location location) {
        return LightAPI.collectChunks(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static List<ChunkInfo> collectChunks(World world, int x, int y, int z) {
        if (LightAPI.getInstance().isEnabled()) {
            return ServerModManager.getNMSHandler().collectChunks(world, x, y, z);
        }
        return null;
    }

    @Deprecated
    public static boolean updateChunks(ChunkInfo info) {
        return LightAPI.updateChunk(info);
    }

    public static boolean updateChunk(ChunkInfo info) {
        if (LightAPI.getInstance().isEnabled()) {
            UpdateChunkEvent event = new UpdateChunkEvent(info);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (ChunkCache.CHUNK_INFO_QUEUE.contains(event.getChunkInfo())) {
                    int index = ChunkCache.CHUNK_INFO_QUEUE.indexOf(event.getChunkInfo());
                    ChunkInfo previous = ChunkCache.CHUNK_INFO_QUEUE.get(index);
                    if (previous.getChunkYHeight() > event.getChunkInfo().getChunkYHeight()) {
                        event.getChunkInfo().setChunkYHeight(previous.getChunkYHeight());
                    }
                    ChunkCache.CHUNK_INFO_QUEUE.remove(index);
                }
                ChunkCache.CHUNK_INFO_QUEUE.add(event.getChunkInfo());
                return true;
            }
        }
        return false;
    }

    public static boolean updateChunks(Location location, Collection<? extends Player> players) {
        return LightAPI.updateChunks(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), players);
    }

    public static boolean updateChunks(World world, int x, int y, int z, Collection<? extends Player> players) {
        if (LightAPI.getInstance().isEnabled()) {
            for (ChunkInfo info : LightAPI.collectChunks(world, x, y, z)) {
                info.setReceivers(players);
                LightAPI.updateChunk(info);
            }
            return true;
        }
        return false;
    }

    public static boolean updateChunk(Location location, Collection<? extends Player> players) {
        return LightAPI.updateChunk(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), players);
    }

    public static boolean updateChunk(World world, int x, int y, int z, Collection<? extends Player> players) {
        if (LightAPI.getInstance().isEnabled()) {
            ServerModManager.getNMSHandler().sendChunkUpdate(world, x >> 4, y, z >> 4, players);
            return true;
        }
        return false;
    }

    public static Block getAdjacentAirBlock(Block block) {
        BlockFace[] blockFaceArray = SIDES;
        int n = SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            Block candidate;
            BlockFace face = blockFaceArray[n2];
            if (!(block.getY() == 0 && face == BlockFace.DOWN || block.getY() == 255 && face == BlockFace.UP || !(candidate = block.getRelative(face)).getType().isTransparent())) {
                return candidate;
            }
            ++n2;
        }
        return block;
    }

    private void generateConfig(File file) {
        FileConfiguration fc = this.getConfig();
        if (!file.exists()) {
            fc.options().header("LightAPI v" + this.getDescription().getVersion() + " Configuration" + "\nby BeYkeRYkt");
            fc.set("version", (Object)this.configVer);
            fc.set("update-delay-ticks", (Object)2);
            fc.set("max-iterations-per-tick", (Object)400);
            fc.set("updater.enable", (Object)true);
            fc.set("updater.repo", (Object)"BeYkeRYkt/LightAPI");
            fc.set("updater.update-delay-ticks", (Object)40);
            fc.set("updater.view-changelog", (Object)false);
            this.saveConfig();
        }
    }

    public int getUpdateDelayTicks() {
        return this.update_delay_ticks;
    }

    public void setUpdateDelayTicks(int update_delay_ticks) {
        this.update_delay_ticks = update_delay_ticks;
    }

    public int getMaxIterationsPerTick() {
        return this.max_iterations_per_tick;
    }

    public void setMaxIterationsPerTick(int max_iterations_per_tick) {
        this.max_iterations_per_tick = max_iterations_per_tick;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.enableUpdater && player.hasPermission("lightapi.updater")) {
            this.runUpdater((CommandSender)player, this.delayUpdate);
        }
    }

    private void runUpdater(final CommandSender sender, int delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Version version = Version.parse(LightAPI.this.getDescription().getVersion());
                try {
                    Updater updater = new Updater(version, LightAPI.this.repo);
                    Response response = updater.getResult();
                    if (response == Response.SUCCESS) {
                        LightAPI.this.log(sender, ChatColor.WHITE + "New update is available: " + ChatColor.YELLOW + updater.getLatestVersion() + ChatColor.WHITE + "!");
                        UpdateType update = UpdateType.compareVersion(updater.getVersion().toString());
                        LightAPI.this.log(sender, ChatColor.WHITE + "Repository: " + LightAPI.this.repo);
                        LightAPI.this.log(sender, ChatColor.WHITE + "Update type: " + update.getName());
                        if (update == UpdateType.MAJOR) {
                            LightAPI.this.log(sender, ChatColor.RED + "WARNING ! A MAJOR UPDATE! Not updating plugins may produce errors after starting the server! Notify developers about update.");
                        }
                        if (LightAPI.this.viewChangelog) {
                            LightAPI.this.log(sender, ChatColor.WHITE + "Changes: ");
                            sender.sendMessage(updater.getChanges());
                        }
                    } else if (response == Response.REPO_NOT_FOUND) {
                        LightAPI.this.log(sender, ChatColor.RED + "Repo not found! Check that your repo exists!");
                    } else if (response == Response.REPO_NO_RELEASES) {
                        LightAPI.this.log(sender, ChatColor.RED + "Releases not found! Check your repo!");
                    } else if (response == Response.NO_UPDATE) {
                        LightAPI.this.log(sender, ChatColor.GREEN + "You are running the latest version!");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)delay);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("lightapi")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 0) {
                    if (BungeeChatHelperClass.hasBungeeChatAPI()) {
                        BungeeChatHelperClass.sendMessageAboutPlugin(player, this);
                    } else {
                        player.sendMessage(ChatColor.AQUA + " ------- <LightAPI " + ChatColor.WHITE + this.getDescription().getVersion() + "> ------- ");
                        player.sendMessage(ChatColor.AQUA + " Current version: " + ChatColor.WHITE + this.getDescription().getVersion());
                        player.sendMessage(ChatColor.AQUA + " Server name: " + ChatColor.WHITE + this.getServer().getName());
                        player.sendMessage(ChatColor.AQUA + " Server version: " + ChatColor.WHITE + this.getServer().getVersion());
                        player.sendMessage(ChatColor.AQUA + " Source code: " + ChatColor.WHITE + "http://github.com/BeYkeRYkt/LightAPI/");
                        player.sendMessage(ChatColor.AQUA + " Developer: " + ChatColor.WHITE + "BeYkeRYkt");
                        player.sendMessage("");
                        player.sendMessage(ChatColor.WHITE + " Licensed under: " + ChatColor.AQUA + "MIT License");
                    }
                } else if (args[0].equalsIgnoreCase("update")) {
                    if (player.hasPermission("lightapi.updater") || player.isOp()) {
                        this.runUpdater((CommandSender)player, 2);
                    } else {
                        this.log((CommandSender)player, ChatColor.RED + "You don't have permission!");
                    }
                } else {
                    this.log((CommandSender)player, ChatColor.RED + "Hmm... This command does not exist. Are you sure write correctly?");
                }
            } else if (sender instanceof ConsoleCommandSender) {
                ConsoleCommandSender console = (ConsoleCommandSender)sender;
                if (args.length == 0) {
                    console.sendMessage(ChatColor.AQUA + " ------- <LightAPI " + ChatColor.WHITE + this.getDescription().getVersion() + "> ------- ");
                    console.sendMessage(ChatColor.AQUA + " Current version: " + ChatColor.WHITE + this.getDescription().getVersion());
                    console.sendMessage(ChatColor.AQUA + " Server name: " + ChatColor.WHITE + this.getServer().getName());
                    console.sendMessage(ChatColor.AQUA + " Server version: " + ChatColor.WHITE + this.getServer().getVersion());
                    console.sendMessage(ChatColor.AQUA + " Source code: " + ChatColor.WHITE + "http://github.com/BeYkeRYkt/LightAPI/");
                    console.sendMessage(ChatColor.AQUA + " Developer: " + ChatColor.WHITE + "BeYkeRYkt");
                    console.sendMessage("");
                    console.sendMessage(ChatColor.WHITE + " Licensed under: " + ChatColor.AQUA + "MIT License");
                } else if (args[0].equalsIgnoreCase("update")) {
                    this.runUpdater((CommandSender)console, 2);
                } else {
                    this.log((CommandSender)console, ChatColor.RED + "Hmm... This command does not exist. Are you sure write correctly?");
                }
            }
        }
        return true;
    }
}

