/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta.conversion;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.ChunkletStore;
import com.gmail.nossr50.util.blockmeta.HashChunkletManager;
import com.gmail.nossr50.util.blockmeta.PrimitiveChunkletStore;
import com.gmail.nossr50.util.blockmeta.PrimitiveExChunkletStore;
import com.gmail.nossr50.util.blockmeta.chunkmeta.HashChunkManager;
import com.gmail.nossr50.util.blockmeta.chunkmeta.PrimitiveChunkStore;
import java.io.File;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BlockStoreConversionZDirectory
implements Runnable {
    public int taskID = -1;
    public int cx;
    public int cz;
    public int x;
    public int y;
    public int z;
    public int y2;
    public int xPos;
    public int zPos;
    public int cxPos;
    public int czPos;
    private String cxs;
    private String czs;
    private String chunkletName;
    private String chunkName;
    private World world;
    private BukkitScheduler scheduler;
    private File xDir;
    private File dataDir;
    private HashChunkletManager manager;
    private HashChunkManager newManager;
    private ChunkletStore tempChunklet;
    private PrimitiveChunkletStore primitiveChunklet = null;
    private PrimitiveExChunkletStore primitiveExChunklet = null;
    private PrimitiveChunkStore currentChunk;
    private boolean[] oldArray;
    private boolean[] newArray;

    public void start(World world, File xDir, File dataDir) {
        this.world = world;
        this.scheduler = mcMMO.p.getServer().getScheduler();
        this.manager = new HashChunkletManager();
        this.newManager = (HashChunkManager)mcMMO.getPlaceStore();
        this.dataDir = dataDir;
        this.xDir = xDir;
        if (this.taskID >= 0) {
            return;
        }
        this.taskID = this.scheduler.runTaskLater((Plugin)mcMMO.p, (Runnable)this, 1L).getTaskId();
    }

    @Override
    public void run() {
        if (!this.dataDir.exists()) {
            this.stop();
            return;
        }
        if (!this.dataDir.isDirectory()) {
            this.dataDir.delete();
            this.stop();
            return;
        }
        if (this.dataDir.listFiles().length <= 0) {
            this.dataDir.delete();
            this.stop();
            return;
        }
        this.cxs = this.xDir.getName();
        this.czs = this.dataDir.getName();
        this.cx = 0;
        this.cz = 0;
        try {
            this.cx = Integer.parseInt(this.cxs);
            this.cz = Integer.parseInt(this.czs);
        }
        catch (Exception e) {
            this.dataDir.delete();
            this.stop();
            return;
        }
        this.manager.loadChunk(this.cx, this.cz, this.world);
        this.y = 0;
        while (this.y < this.world.getMaxHeight() / 64) {
            this.chunkletName = this.world.getName() + "," + this.cx + "," + this.cz + "," + this.y;
            this.tempChunklet = this.manager.store.get(this.chunkletName);
            if (this.tempChunklet instanceof PrimitiveChunkletStore) {
                this.primitiveChunklet = (PrimitiveChunkletStore)this.tempChunklet;
            } else if (this.tempChunklet instanceof PrimitiveExChunkletStore) {
                this.primitiveExChunklet = (PrimitiveExChunkletStore)this.tempChunklet;
            }
            if (this.tempChunklet != null) {
                this.chunkName = this.world.getName() + "," + this.cx + "," + this.cz;
                this.currentChunk = (PrimitiveChunkStore)this.newManager.store.get(this.chunkName);
                if (this.currentChunk != null) {
                    this.xPos = this.cx * 16;
                    this.zPos = this.cz * 16;
                    this.x = 0;
                    while (this.x < 16) {
                        this.z = 0;
                        while (this.z < 16) {
                            this.cxPos = this.xPos + this.x;
                            this.czPos = this.zPos + this.z;
                            this.y2 = 64 * this.y;
                            while (this.y2 < 64 * this.y + 64) {
                                try {
                                    if (this.manager.isTrue(this.cxPos, this.y2, this.czPos, this.world)) {
                                        this.newManager.setTrue(this.cxPos, this.y2, this.czPos, this.world);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++this.y2;
                            }
                            ++this.z;
                        }
                        ++this.x;
                    }
                } else {
                    this.newManager.setTrue(this.cx * 16, 0, this.cz * 16, this.world);
                    this.newManager.setFalse(this.cx * 16, 0, this.cz * 16, this.world);
                    this.currentChunk = (PrimitiveChunkStore)this.newManager.store.get(this.chunkName);
                    this.x = 0;
                    while (this.x < 16) {
                        this.z = 0;
                        while (this.z < 16) {
                            if (this.primitiveChunklet != null) {
                                this.oldArray = this.primitiveChunklet.store[this.x][this.z];
                            }
                            if (this.primitiveExChunklet == null) {
                                return;
                            }
                            this.oldArray = this.primitiveExChunklet.store[this.x][this.z];
                            this.newArray = this.currentChunk.store[this.x][this.z];
                            if (this.oldArray.length < 64) {
                                return;
                            }
                            if (this.newArray.length < this.y * 64 + 64) {
                                return;
                            }
                            System.arraycopy(this.oldArray, 0, this.newArray, this.y * 64, 64);
                            ++this.z;
                        }
                        ++this.x;
                    }
                }
            }
            ++this.y;
        }
        this.manager.unloadChunk(this.cx, this.cz, this.world);
        this.newManager.unloadChunk(this.cx, this.cz, this.world);
        for (File yFile : this.dataDir.listFiles()) {
            if (!yFile.exists()) continue;
            yFile.delete();
        }
        this.stop();
    }

    public void stop() {
        if (this.taskID < 0) {
            return;
        }
        this.scheduler.cancelTask(this.taskID);
        this.taskID = -1;
        this.cxs = null;
        this.czs = null;
        this.chunkletName = null;
        this.chunkName = null;
        this.manager = null;
        this.xDir = null;
        this.dataDir = null;
        this.tempChunklet = null;
        this.primitiveChunklet = null;
        this.primitiveExChunklet = null;
        this.currentChunk = null;
    }
}

