/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta.chunkmeta;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkManager;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkStore;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkStoreFactory;
import com.gmail.nossr50.util.blockmeta.chunkmeta.McMMOSimpleRegionFile;
import com.gmail.nossr50.util.blockmeta.conversion.BlockStoreConversionZDirectory;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;

public class HashChunkManager
implements ChunkManager {
    private HashMap<UUID, HashMap<Long, McMMOSimpleRegionFile>> regionFiles = new HashMap();
    public HashMap<String, ChunkStore> store = new HashMap();
    public ArrayList<BlockStoreConversionZDirectory> converters = new ArrayList();
    private HashMap<UUID, Boolean> oldData = new HashMap();

    @Override
    public synchronized void closeAll() {
        for (UUID uid : this.regionFiles.keySet()) {
            HashMap<Long, McMMOSimpleRegionFile> worldRegions = this.regionFiles.get(uid);
            Iterator<McMMOSimpleRegionFile> worldRegionIterator = worldRegions.values().iterator();
            while (worldRegionIterator.hasNext()) {
                McMMOSimpleRegionFile rf = worldRegionIterator.next();
                if (rf == null) continue;
                rf.close();
                worldRegionIterator.remove();
            }
        }
        this.regionFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ChunkStore readChunkStore(World world, int x, int z) throws IOException {
        McMMOSimpleRegionFile rf = this.getSimpleRegionFile(world, x, z);
        DataInputStream in = rf.getInputStream(x, z);
        if (in == null) {
            return null;
        }
        ObjectInputStream objectStream = new ObjectInputStream(in);
        try {
            Object o = objectStream.readObject();
            if (o instanceof ChunkStore) {
                ChunkStore chunkStore = (ChunkStore)o;
                return chunkStore;
            }
            try {
                throw new RuntimeException("Wrong class type read for chunk meta data for " + x + ", " + z);
            }
            catch (IOException e) {
                ChunkStore chunkStore = null;
                return chunkStore;
            }
            catch (ClassNotFoundException e) {
                ChunkStore chunkStore = null;
                return chunkStore;
            }
        }
        finally {
            objectStream.close();
        }
    }

    @Override
    public synchronized void writeChunkStore(World world, int x, int z, ChunkStore data) {
        if (!data.isDirty()) {
            return;
        }
        try {
            McMMOSimpleRegionFile rf = this.getSimpleRegionFile(world, x, z);
            ObjectOutputStream objectStream = new ObjectOutputStream(rf.getOutputStream(x, z));
            objectStream.writeObject(data);
            objectStream.flush();
            objectStream.close();
            data.setDirty(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write chunk meta data for " + x + ", " + z, e);
        }
    }

    @Override
    public synchronized void closeChunkStore(World world, int x, int z) {
        McMMOSimpleRegionFile rf = this.getSimpleRegionFile(world, x, z);
        if (rf != null) {
            rf.close();
        }
    }

    private synchronized McMMOSimpleRegionFile getSimpleRegionFile(World world, int x, int z) {
        int rz;
        int rx;
        long key2;
        McMMOSimpleRegionFile regionFile;
        File directory = new File(world.getWorldFolder(), "mcmmo_regions");
        directory.mkdirs();
        UUID key = world.getUID();
        HashMap<Long, McMMOSimpleRegionFile> worldRegions = this.regionFiles.get(key);
        if (worldRegions == null) {
            worldRegions = new HashMap();
            this.regionFiles.put(key, worldRegions);
        }
        if ((regionFile = worldRegions.get(key2 = (long)(rx = x >> 5) << 32 | (long)(rz = z >> 5) & 0xFFFFFFFFL)) == null) {
            File file = new File(directory, "mcmmo_" + rx + "_" + rz + "_.mcm");
            regionFile = new McMMOSimpleRegionFile(file, rx, rz);
            worldRegions.put(key2, regionFile);
        }
        return regionFile;
    }

    @Override
    public synchronized void loadChunklet(int cx, int cy, int cz, World world) {
        this.loadChunk(cx, cz, world, null);
    }

    @Override
    public synchronized void unloadChunklet(int cx, int cy, int cz, World world) {
        this.unloadChunk(cx, cz, world);
    }

    @Override
    public synchronized void loadChunk(int cx, int cz, World world, Entity[] entities) {
        if (world == null || this.store.containsKey(world.getName() + "," + cx + "," + cz)) {
            return;
        }
        UUID key = world.getUID();
        if (!this.oldData.containsKey(key)) {
            this.oldData.put(key, new File(world.getWorldFolder(), "mcmmo_data").exists());
        } else if (this.oldData.get(key).booleanValue() && this.convertChunk(new File(world.getWorldFolder(), "mcmmo_data"), cx, cz, world, true)) {
            return;
        }
        ChunkStore chunkStore = null;
        try {
            chunkStore = this.readChunkStore(world, cx, cz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chunkStore == null) {
            return;
        }
        this.store.put(world.getName() + "," + cx + "," + cz, chunkStore);
    }

    @Override
    public synchronized void unloadChunk(int cx, int cz, World world) {
        this.saveChunk(cx, cz, world);
        if (this.store.containsKey(world.getName() + "," + cx + "," + cz)) {
            this.store.remove(world.getName() + "," + cx + "," + cz);
        }
    }

    @Override
    public synchronized void saveChunk(int cx, int cz, World world) {
        if (world == null) {
            return;
        }
        String key = world.getName() + "," + cx + "," + cz;
        if (this.store.containsKey(key)) {
            ChunkStore out = this.store.get(world.getName() + "," + cx + "," + cz);
            if (!out.isDirty()) {
                return;
            }
            this.writeChunkStore(world, cx, cz, out);
        }
    }

    @Override
    public synchronized boolean isChunkLoaded(int cx, int cz, World world) {
        if (world == null) {
            return false;
        }
        return this.store.containsKey(world.getName() + "," + cx + "," + cz);
    }

    @Override
    public synchronized void chunkLoaded(int cx, int cz, World world) {
    }

    @Override
    public synchronized void chunkUnloaded(int cx, int cz, World world) {
        if (world == null) {
            return;
        }
        this.unloadChunk(cx, cz, world);
    }

    @Override
    public synchronized void saveWorld(World world) {
        if (world == null) {
            return;
        }
        this.closeAll();
        String worldName = world.getName();
        ArrayList<String> keys = new ArrayList<String>(this.store.keySet());
        for (String key : keys) {
            String[] info = key.split(",");
            if (!worldName.equals(info[0])) continue;
            try {
                this.saveChunk(Integer.parseInt(info[1]), Integer.parseInt(info[2]), world);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void unloadWorld(World world) {
        if (world == null) {
            return;
        }
        this.closeAll();
        String worldName = world.getName();
        ArrayList<String> keys = new ArrayList<String>(this.store.keySet());
        for (String key : keys) {
            String[] info = key.split(",");
            if (!worldName.equals(info[0])) continue;
            try {
                this.unloadChunk(Integer.parseInt(info[1]), Integer.parseInt(info[2]), world);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void loadWorld(World world) {
    }

    @Override
    public synchronized void saveAll() {
        this.closeAll();
        for (World world : mcMMO.p.getServer().getWorlds()) {
            this.saveWorld(world);
        }
    }

    @Override
    public synchronized void unloadAll() {
        this.closeAll();
        for (World world : mcMMO.p.getServer().getWorlds()) {
            this.unloadWorld(world);
        }
    }

    @Override
    public synchronized boolean isTrue(int x, int y, int z, World world) {
        if (world == null) {
            return false;
        }
        int cx = x / 16;
        int cz = z / 16;
        String key = world.getName() + "," + cx + "," + cz;
        if (!this.store.containsKey(key)) {
            this.loadChunk(cx, cz, world, null);
        }
        if (!this.store.containsKey(key)) {
            return false;
        }
        ChunkStore check = this.store.get(key);
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        return check.isTrue(ix, y, iz);
    }

    @Override
    public synchronized boolean isTrue(Block block) {
        if (block == null) {
            return false;
        }
        return this.isTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public synchronized boolean isTrue(BlockState blockState) {
        if (blockState == null) {
            return false;
        }
        return this.isTrue(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void setTrue(int x, int y, int z, World world) {
        ChunkStore cStore;
        if (world == null) {
            return;
        }
        int cx = x / 16;
        int cz = z / 16;
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        String key = world.getName() + "," + cx + "," + cz;
        if (!this.store.containsKey(key)) {
            this.loadChunk(cx, cz, world, null);
        }
        if ((cStore = this.store.get(key)) == null) {
            cStore = ChunkStoreFactory.getChunkStore(world, cx, cz);
            this.store.put(key, cStore);
        }
        cStore.setTrue(ix, y, iz);
    }

    @Override
    public synchronized void setTrue(Block block) {
        if (block == null) {
            return;
        }
        this.setTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setTrue(BlockState blockState) {
        if (blockState == null) {
            return;
        }
        this.setTrue(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void setFalse(int x, int y, int z, World world) {
        ChunkStore cStore;
        if (world == null) {
            return;
        }
        int cx = x / 16;
        int cz = z / 16;
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        String key = world.getName() + "," + cx + "," + cz;
        if (!this.store.containsKey(key)) {
            this.loadChunk(cx, cz, world, null);
        }
        if ((cStore = this.store.get(key)) == null) {
            return;
        }
        cStore.setFalse(ix, y, iz);
    }

    @Override
    public synchronized void setFalse(Block block) {
        if (block == null) {
            return;
        }
        this.setFalse(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public synchronized void setFalse(BlockState blockState) {
        if (blockState == null) {
            return;
        }
        this.setFalse(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void cleanUp() {
    }

    public synchronized void convertChunk(File dataDir, int cx, int cz, World world) {
        this.convertChunk(dataDir, cx, cz, world, false);
    }

    public synchronized boolean convertChunk(File dataDir, int cx, int cz, World world, boolean actually) {
        if (!actually || !dataDir.exists()) {
            return false;
        }
        File cxDir = new File(dataDir, "" + cx);
        if (!cxDir.exists()) {
            return false;
        }
        File czDir = new File(cxDir, "" + cz);
        if (!czDir.exists()) {
            return false;
        }
        boolean conversionSet = false;
        for (BlockStoreConversionZDirectory converter : this.converters) {
            if (converter == null || converter.taskID >= 0) continue;
            converter.start(world, cxDir, czDir);
            conversionSet = true;
            break;
        }
        if (!conversionSet) {
            BlockStoreConversionZDirectory converter = new BlockStoreConversionZDirectory();
            converter.start(world, cxDir, czDir);
            this.converters.add(converter);
        }
        return true;
    }
}

