/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.EntityType;

public class StringUtils {
    public static String getCapitalized(String target) {
        return target.substring(0, 1).toUpperCase() + target.substring(1).toLowerCase();
    }

    public static String getPrettyItemString(Material material) {
        return StringUtils.createPrettyEnumString(material.toString());
    }

    public static String getPrettyEntityTypeString(EntityType entity) {
        return StringUtils.createPrettyEnumString(entity.toString());
    }

    public static String getPrettyAbilityString(AbilityType ability) {
        return StringUtils.createPrettyEnumString(ability.toString());
    }

    public static String getPrettyTreeSpeciesString(TreeSpecies species) {
        return StringUtils.createPrettyEnumString(species.toString());
    }

    public static String getPrettySecondaryAbilityString(SecondaryAbility secondaryAbility) {
        switch (secondaryAbility) {
            case HERBALISM_DOUBLE_DROPS: 
            case MINING_DOUBLE_DROPS: 
            case WOODCUTTING_DOUBLE_DROPS: {
                return "Double Drops";
            }
            case FISHING_TREASURE_HUNTER: 
            case EXCAVATION_TREASURE_HUNTER: {
                return "Treasure Hunter";
            }
            case GREEN_THUMB_BLOCK: 
            case GREEN_THUMB_PLANT: {
                return "Green Thumb";
            }
        }
        return StringUtils.createPrettyEnumString(secondaryAbility.toString());
    }

    public static String getPrettyPartyFeatureString(PartyFeature partyFeature) {
        return StringUtils.createPrettyEnumString(partyFeature.toString());
    }

    private static String createPrettyEnumString(String baseString) {
        String[] substrings = baseString.split("_");
        String prettyString = "";
        int size = 1;
        for (String string : substrings) {
            prettyString = prettyString.concat(StringUtils.getCapitalized(string));
            if (size < substrings.length) {
                prettyString = prettyString.concat(" ");
            }
            ++size;
        }
        return prettyString;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException nFE) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException nFE) {
            return false;
        }
    }
}

