/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.commands.skills.AprilCommand;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public final class HolidayManager {
    private ArrayList<String> hasCelebrated;
    private int currentYear;
    private static final int START_YEAR = 2011;
    private static final List<Color> ALL_COLORS;
    private static final List<ChatColor> ALL_CHAT_COLORS;
    private static final List<ChatColor> CHAT_FORMATS;
    public final Set<Statistic> movementStatistics = EnumSet.of(Statistic.WALK_ONE_CM, new Statistic[]{Statistic.SWIM_ONE_CM, Statistic.FALL_ONE_CM, Statistic.CLIMB_ONE_CM, Statistic.FLY_ONE_CM, Statistic.DIVE_ONE_CM, Statistic.PIG_ONE_CM});

    public HolidayManager() {
        this.currentYear = Calendar.getInstance().get(1);
        File anniversaryFile = new File(mcMMO.getFlatFileDirectory(), "anniversary." + this.currentYear + ".yml");
        if (!anniversaryFile.exists()) {
            try {
                anniversaryFile.createNewFile();
            }
            catch (IOException ex) {
                mcMMO.p.getLogger().severe(ex.toString());
            }
        }
        this.hasCelebrated = new ArrayList();
        try {
            this.hasCelebrated.clear();
            BufferedReader reader = new BufferedReader(new FileReader(anniversaryFile.getPath()));
            String line = reader.readLine();
            while (line != null) {
                this.hasCelebrated.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception ex) {
            mcMMO.p.getLogger().severe(ex.toString());
        }
        this.cleanupFiles();
    }

    private void cleanupFiles() {
        File FlatFileDir = new File(mcMMO.getFlatFileDirectory());
        File legacy = new File(FlatFileDir, "anniversary.yml");
        ArrayList<File> toDelete = new ArrayList<File>();
        if (legacy.exists()) {
            toDelete.add(legacy);
        }
        Pattern pattern = Pattern.compile("anniversary\\.(?:.+)\\.yml");
        for (String fileName : FlatFileDir.list()) {
            File file;
            if (!pattern.matcher(fileName).matches() || fileName.equals("anniversary." + this.currentYear + ".yml") || (file = new File(FlatFileDir, fileName)).isDirectory()) continue;
            toDelete.add(file);
        }
        for (File file : toDelete) {
            if (!file.delete()) continue;
            mcMMO.p.debug("Deleted: " + file.getName());
        }
    }

    public void saveAnniversaryFiles() {
        mcMMO.p.debug("Saving anniversary files...");
        String anniversaryFilePath = mcMMO.getFlatFileDirectory() + "anniversary." + this.currentYear + ".yml";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(anniversaryFilePath));
            for (String player : this.hasCelebrated) {
                writer.write(player);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            mcMMO.p.getLogger().severe(ex.toString());
        }
    }

    public void anniversaryCheck(final CommandSender sender) {
        GregorianCalendar anniversaryStart = new GregorianCalendar(this.currentYear, 1, 3);
        GregorianCalendar anniversaryEnd = new GregorianCalendar(this.currentYear, 1, 6);
        GregorianCalendar day = new GregorianCalendar();
        if (this.hasCelebrated.contains(sender.getName())) {
            return;
        }
        if (!this.getDateRange(day.getTime(), anniversaryStart.getTime(), anniversaryEnd.getTime())) {
            return;
        }
        sender.sendMessage(ChatColor.BLUE + "Happy " + (this.currentYear - 2011) + " Year Anniversary!  In honor of all of");
        sender.sendMessage(ChatColor.BLUE + "nossr50's work and all the devs, here's a firework show!");
        if (sender instanceof Player) {
            int firework_amount = 10;
            for (int i = 0; i < 10; ++i) {
                int delay = (int)(Misc.getRandom().nextDouble() * 3.0 * 20.0) + 4;
                mcMMO.p.getServer().getScheduler().runTaskLater((Plugin)mcMMO.p, new Runnable(){

                    @Override
                    public void run() {
                        HolidayManager.this.spawnFireworks((Player)sender);
                    }
                }, (long)delay);
            }
        } else {
            Object[] colorParams = new Object[]{HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose()};
            sender.sendMessage(String.format("      %1$s.''.      %4$s.        %7$s*''*    %10$s:_\\/_:     %11$s.", colorParams));
            sender.sendMessage(String.format("     %1$s:_\\/_:   %4$s_\\(/_  %5$s.:.%7$s*_\\/_*   %10$s: /\\ :  %11$s.'.:.'.", colorParams));
            sender.sendMessage(String.format(" %2$s.''.%1$s: /\\ :    %4$s/)\\   %5$s':'%7$s* /\\ *  %9$s: %10$s'..'.  %11$s-=:o:=-", colorParams));
            sender.sendMessage(String.format("%2$s:_\\/_:%1$s'%3$s.:::.    %4$s' %6$s*''*    %7$s* %9$s'.\\'/.'%8$s_\\(/_ %11$s'.':'.'", colorParams));
            sender.sendMessage(String.format("%2$s: /\\ : %3$s:::::     %6$s*_\\/_*     %9$s-= o =-%8$s /)\\     %11$s'", colorParams));
            sender.sendMessage(String.format(" %2$s'..'  %3$s':::'     %6$s* /\\ *     %9$s.'/.\\'.  %8$s'      %11$s*", colorParams));
            sender.sendMessage(String.format("     %2$s*            %6$s*..*         %9$s:           %11$s*", colorParams));
            sender.sendMessage(String.format("      %2$s*                        %9$s*          %11$s*", colorParams));
            sender.sendMessage(String.format("      %2$s*                        %9$s*          %11$s*", colorParams));
        }
        this.hasCelebrated.add(sender.getName());
    }

    public boolean getDateRange(Date date, Date start, Date end) {
        return !date.before(start) && !date.after(end);
    }

    public void spawnFireworks(Player player) {
        int power = Misc.getRandom().nextInt(3) + 1;
        FireworkEffect.Type fireworkType = FireworkEffect.Type.values()[Misc.getRandom().nextInt(FireworkEffect.Type.values().length)];
        double varX = Misc.getRandom().nextGaussian() * 3.0;
        double varZ = Misc.getRandom().nextGaussian() * 3.0;
        Firework fireworks = (Firework)player.getWorld().spawnEntity(player.getLocation().add(varX, 0.0, varZ), EntityType.FIREWORK);
        FireworkMeta fireworkmeta = fireworks.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().flicker(Misc.getRandom().nextBoolean()).withColor(HolidayManager.colorChoose()).withFade(HolidayManager.colorChoose()).with(fireworkType).trail(Misc.getRandom().nextBoolean()).build();
        fireworkmeta.addEffect(effect);
        fireworkmeta.setPower(power);
        fireworks.setFireworkMeta(fireworkmeta);
    }

    private static List<Color> colorChoose() {
        return ALL_COLORS.subList(0, Math.max(Misc.getRandom().nextInt(ALL_COLORS.size() + 1), 1));
    }

    private static String chatColorChoose() {
        StringBuilder ret = new StringBuilder(ALL_CHAT_COLORS.get(Misc.getRandom().nextInt(ALL_CHAT_COLORS.size())).toString());
        for (ChatColor chatFormat : CHAT_FORMATS) {
            if (Misc.getRandom().nextInt(CHAT_FORMATS.size()) != 0) continue;
            ret.append(chatFormat);
        }
        return ret.toString();
    }

    public boolean isAprilFirst() {
        GregorianCalendar aprilFirst = new GregorianCalendar(this.currentYear, 3, 1);
        GregorianCalendar aprilSecond = new GregorianCalendar(this.currentYear, 3, 2);
        GregorianCalendar day = new GregorianCalendar();
        return this.getDateRange(day.getTime(), aprilFirst.getTime(), aprilSecond.getTime());
    }

    public boolean nearingAprilFirst() {
        GregorianCalendar start = new GregorianCalendar(Calendar.getInstance().get(1), 2, 28);
        GregorianCalendar end = new GregorianCalendar(Calendar.getInstance().get(1), 3, 2);
        GregorianCalendar day = new GregorianCalendar();
        return mcMMO.getHolidayManager().getDateRange(day.getTime(), start.getTime(), end.getTime());
    }

    public void handleStatisticEvent(PlayerStatisticIncrementEvent event) {
        int modifier;
        Player player = event.getPlayer();
        Statistic statistic = event.getStatistic();
        int newValue = event.getNewValue();
        switch (statistic) {
            case DAMAGE_TAKEN: {
                modifier = 500;
                break;
            }
            case JUMP: {
                modifier = 500;
                break;
            }
            case DROP: {
                modifier = 200;
                break;
            }
            case MINE_BLOCK: 
            case BREAK_ITEM: {
                modifier = 500;
                break;
            }
            case CRAFT_ITEM: {
                modifier = 100;
                break;
            }
            default: {
                return;
            }
        }
        if (newValue % modifier == 0) {
            mcMMO.getHolidayManager().levelUpApril(player, FakeSkillType.getByStatistic(statistic));
        }
    }

    public void levelUpApril(Player player, FakeSkillType fakeSkillType) {
        int levelTotal = Misc.getRandom().nextInt(1 + UserManager.getPlayer(player).getSkillLevel(SkillType.MINING)) + 1;
        player.playSound(player.getLocation(), Sound.LEVEL_UP, 0.75f, 0.5f);
        player.sendMessage(ChatColor.YELLOW + StringUtils.getCapitalized(fakeSkillType.toString()) + " skill increased by 1. Total (" + levelTotal + ")");
        ParticleEffectUtils.fireworkParticleShower(player, ALL_COLORS.get(Misc.getRandom().nextInt(ALL_COLORS.size())));
    }

    public void registerAprilCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcfools");
        command.setExecutor((CommandExecutor)new AprilCommand());
    }

    static {
        ArrayList<Color> colors = new ArrayList<Color>();
        ArrayList<ChatColor> chatColors = new ArrayList<ChatColor>();
        ArrayList<ChatColor> chatFormats = new ArrayList<ChatColor>();
        for (ChatColor chatColor : ChatColor.values()) {
            if (chatColor.isColor()) {
                chatColors.add(chatColor);
                continue;
            }
            chatFormats.add(chatColor);
        }
        for (ChatColor chatColor : DyeColor.values()) {
            colors.add(chatColor.getFireworkColor());
        }
        Collections.shuffle(chatColors, Misc.getRandom());
        Collections.shuffle(colors, Misc.getRandom());
        Collections.shuffle(chatFormats, Misc.getRandom());
        ALL_CHAT_COLORS = ImmutableList.copyOf(chatColors);
        ALL_COLORS = ImmutableList.copyOf(colors);
        CHAT_FORMATS = ImmutableList.copyOf(chatFormats);
    }

    public static enum FakeSkillType {
        MACHO,
        JUMPING,
        THROWING,
        WRECKING,
        CRAFTING,
        WALKING,
        SWIMMING,
        FALLING,
        CLIMBING,
        FLYING,
        DIVING,
        PIGGY,
        UNKNOWN;


        public static FakeSkillType getByName(String skillName) {
            for (FakeSkillType type : FakeSkillType.values()) {
                if (!type.name().equalsIgnoreCase(skillName)) continue;
                return type;
            }
            return null;
        }

        public static FakeSkillType getByStatistic(Statistic statistic) {
            switch (statistic) {
                case DAMAGE_TAKEN: {
                    return MACHO;
                }
                case JUMP: {
                    return JUMPING;
                }
                case DROP: {
                    return THROWING;
                }
                case MINE_BLOCK: 
                case BREAK_ITEM: {
                    return WRECKING;
                }
                case CRAFT_ITEM: {
                    return CRAFTING;
                }
                case WALK_ONE_CM: {
                    return WALKING;
                }
                case SWIM_ONE_CM: {
                    return SWIMMING;
                }
                case FALL_ONE_CM: {
                    return FALLING;
                }
                case CLIMB_ONE_CM: {
                    return CLIMBING;
                }
                case FLY_ONE_CM: {
                    return FLYING;
                }
                case DIVE_ONE_CM: {
                    return DIVING;
                }
                case PIG_ONE_CM: {
                    return PIGGY;
                }
            }
            return UNKNOWN;
        }
    }
}

