/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TrackedTamingEntity
extends BukkitRunnable {
    private LivingEntity livingEntity;
    private UUID id;
    private int length;

    protected TrackedTamingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.id = livingEntity.getUniqueId();
        int tamingCOTWLength = Config.getInstance().getTamingCOTWLength(livingEntity.getType());
        if (tamingCOTWLength > 0) {
            this.length = tamingCOTWLength * 20;
            this.runTaskLater((Plugin)mcMMO.p, this.length);
        }
    }

    public void run() {
        if (this.livingEntity.isValid()) {
            Location location = this.livingEntity.getLocation();
            location.getWorld().playSound(location, Sound.FIZZ, 0.8f, 0.8f);
            ParticleEffectUtils.playCallOfTheWildEffect(this.livingEntity);
            CombatUtils.dealDamage(this.livingEntity, this.livingEntity.getMaxHealth(), EntityDamageEvent.DamageCause.SUICIDE, (Entity)this.livingEntity);
        }
        TamingManager.removeFromTracker(this);
        this.cancel();
    }

    protected LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    protected UUID getID() {
        return this.id;
    }
}

