/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.salvage;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.permissions.Permissible;

public class SalvageManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public SalvageManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.SALVAGE);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (Config.getInstance().getSalvageAnvilMessagesEnabled()) {
            player.sendMessage(LocaleLoader.getString("Salvage.Listener.Anvil"));
        }
        if (Config.getInstance().getSalvageAnvilPlaceSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.ANVIL_LAND, 1.0f, 0.3f);
        }
        this.togglePlacedAnvil();
    }

    public void handleSalvage(Location location, ItemStack item) {
        ItemStack enchantBook;
        int minimumSalvageableLevel;
        Salvageable salvageable;
        Player player = this.getPlayer();
        if (!Permissions.salvageItemType((Permissible)player, (salvageable = mcMMO.getSalvageableManager().getSalvageable(item.getType())).getSalvageItemType())) {
            player.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        if (!Permissions.salvageMaterialType((Permissible)player, salvageable.getSalvageMaterialType())) {
            player.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        int skillLevel = this.getSkillLevel();
        if (skillLevel < (minimumSalvageableLevel = salvageable.getMinimumLevel())) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.Adept.Level", minimumSalvageableLevel, StringUtils.getPrettyItemString(item.getType())));
            return;
        }
        if (!(item.getDurability() == 0 || this.getSkillLevel() >= Salvage.advancedSalvageUnlockLevel && Permissions.advancedSalvage((Permissible)player))) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.Adept.Damaged"));
            return;
        }
        int salvageableAmount = Salvage.calculateSalvageableAmount(item.getDurability(), salvageable.getMaximumDurability(), salvageable.getMaximumQuantity());
        if (salvageableAmount == 0) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.TooDamaged"));
            return;
        }
        salvageableAmount = Math.max((int)((double)salvageableAmount * this.getMaxSalvagePercentage()), 1);
        player.setItemInHand(new ItemStack(Material.AIR));
        location.add(0.0, 1.0, 0.0);
        Map enchants = item.getEnchantments();
        if (!enchants.isEmpty() && (enchantBook = this.arcaneSalvageCheck(enchants)) != null) {
            Misc.dropItem(location, enchantBook);
        }
        byte salvageMaterialMetadata = salvageable.getSalvageMaterialMetadata() != -1 ? salvageable.getSalvageMaterialMetadata() : (byte)0;
        Misc.dropItems(location, new MaterialData(salvageable.getSalvageMaterial(), salvageMaterialMetadata).toItemStack(salvageableAmount), 1);
        if (Config.getInstance().getSalvageAnvilUseSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.ANVIL_USE, 1.0f, 0.3f);
            player.playSound(player.getLocation(), Sound.ITEM_BREAK, 1.0f, 1.0f);
        }
        player.sendMessage(LocaleLoader.getString("Salvage.Skills.Success"));
    }

    public double getMaxSalvagePercentage() {
        return Math.min(Salvage.salvageMaxPercentage / (double)Salvage.salvageMaxPercentageLevel * (double)this.getSkillLevel() / 100.0, Salvage.salvageMaxPercentage / 100.0);
    }

    public int getArcaneSalvageRank() {
        int skillLevel = this.getSkillLevel();
        for (Salvage.Tier tier : Salvage.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.toNumerical();
        }
        return 0;
    }

    public double getExtractFullEnchantChance() {
        int skillLevel = this.getSkillLevel();
        for (Salvage.Tier tier : Salvage.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getExtractFullEnchantChance();
        }
        return 0.0;
    }

    public double getExtractPartialEnchantChance() {
        int skillLevel = this.getSkillLevel();
        for (Salvage.Tier tier : Salvage.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getExtractPartialEnchantChance();
        }
        return 0.0;
    }

    private ItemStack arcaneSalvageCheck(Map<Enchantment, Integer> enchants) {
        Player player = this.getPlayer();
        if (this.getArcaneSalvageRank() == 0 || !Permissions.arcaneSalvage((Permissible)player)) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.ArcaneFailed"));
            return null;
        }
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta enchantMeta = (EnchantmentStorageMeta)book.getItemMeta();
        boolean downgraded = false;
        for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
            int successChance = Misc.getRandom().nextInt(this.activationChance);
            if (!Salvage.arcaneSalvageEnchantLoss || this.getExtractFullEnchantChance() > (double)successChance) {
                enchantMeta.addStoredEnchant(enchant.getKey(), enchant.getValue().intValue(), true);
                continue;
            }
            if (enchant.getValue() > 1 && Salvage.arcaneSalvageDowngrades && this.getExtractPartialEnchantChance() > (double)successChance) {
                enchantMeta.addStoredEnchant(enchant.getKey(), enchant.getValue() - 1, true);
                downgraded = true;
                continue;
            }
            downgraded = true;
        }
        Map newEnchants = enchantMeta.getStoredEnchants();
        if (newEnchants.isEmpty()) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.ArcaneFailed"));
            return null;
        }
        if (downgraded || newEnchants.size() < enchants.size()) {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.ArcanePartial"));
        } else {
            player.sendMessage(LocaleLoader.getString("Salvage.Skills.ArcaneSuccess"));
        }
        book.setItemMeta((ItemMeta)enchantMeta);
        return book;
    }

    public boolean checkConfirmation(boolean actualize) {
        Player player = this.getPlayer();
        long lastUse = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(lastUse, 3) || !Config.getInstance().getSalvageConfirmRequired()) {
            return true;
        }
        if (!actualize) {
            return false;
        }
        this.actualizeLastAnvilUse();
        player.sendMessage(LocaleLoader.getString("Skills.ConfirmOrCancel", LocaleLoader.getString("Salvage.Pretty.Name")));
        return false;
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int value) {
        this.lastClick = value;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

