/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.excavation;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;

public class Excavation {
    protected static List<ExcavationTreasure> getTreasures(BlockState blockState) {
        switch (blockState.getType()) {
            case DIRT: {
                return blockState.getRawData() == 2 ? TreasureConfig.getInstance().excavationFromPodzol : TreasureConfig.getInstance().excavationFromDirt;
            }
            case GRASS: {
                return TreasureConfig.getInstance().excavationFromGrass;
            }
            case SAND: {
                return blockState.getRawData() == 1 ? TreasureConfig.getInstance().excavationFromRedSand : TreasureConfig.getInstance().excavationFromSand;
            }
            case GRAVEL: {
                return TreasureConfig.getInstance().excavationFromGravel;
            }
            case CLAY: {
                return TreasureConfig.getInstance().excavationFromClay;
            }
            case MYCEL: {
                return TreasureConfig.getInstance().excavationFromMycel;
            }
            case SOUL_SAND: {
                return TreasureConfig.getInstance().excavationFromSoulSand;
            }
            case SNOW: {
                return TreasureConfig.getInstance().excavationFromSnow;
            }
        }
        return new ArrayList<ExcavationTreasure>();
    }

    protected static int getBlockXP(BlockState blockState) {
        Material material = blockState.getType();
        int xp = material == Material.DIRT || material == Material.SAND ? ExperienceConfig.getInstance().getDirtAndSandXp(blockState.getData()) : ExperienceConfig.getInstance().getXp(SkillType.EXCAVATION, material);
        if (xp == 0 && mcMMO.getModManager().isCustomExcavationBlock(blockState)) {
            xp = mcMMO.getModManager().getBlock(blockState).getXpGain();
        }
        return xp;
    }
}

