/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.acrobatics;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.Acrobatics;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class AcrobaticsManager
extends SkillManager {
    private int fallTries = 0;
    Location lastFallLocation;

    public AcrobaticsManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.ACROBATICS);
    }

    public boolean canRoll() {
        return !this.exploitPrevention() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.ROLL);
    }

    public boolean canDodge(Entity damager) {
        if (Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.DODGE)) {
            if (damager instanceof LightningStrike && Acrobatics.dodgeLightningDisabled) {
                return false;
            }
            return this.skill.shouldProcess(damager);
        }
        return false;
    }

    public double dodgeCheck(double damage) {
        double modifiedDamage = Acrobatics.calculateModifiedDodgeDamage(damage, Acrobatics.dodgeDamageModifier);
        Player player = this.getPlayer();
        if (!this.isFatal(modifiedDamage) && SkillUtils.activationSuccessful(SecondaryAbility.DODGE, player, this.getSkillLevel(), this.activationChance)) {
            ParticleEffectUtils.playDodgeEffect(player);
            if (this.mcMMOPlayer.useChatNotifications()) {
                player.sendMessage(LocaleLoader.getString("Acrobatics.Combat.Proc"));
            }
            if (SkillUtils.cooldownExpired(this.mcMMOPlayer.getRespawnATS(), 5)) {
                this.applyXpGain((float)(damage * (double)Acrobatics.dodgeXpModifier), XPGainReason.PVP);
            }
            return modifiedDamage;
        }
        return damage;
    }

    public double rollCheck(double damage) {
        Player player = this.getPlayer();
        if (player.isSneaking() && Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.GRACEFUL_ROLL)) {
            return this.gracefulRollCheck(damage);
        }
        double modifiedDamage = Acrobatics.calculateModifiedRollDamage(damage, Acrobatics.rollThreshold);
        if (!this.isFatal(modifiedDamage) && SkillUtils.activationSuccessful(SecondaryAbility.ROLL, player, this.getSkillLevel(), this.activationChance)) {
            player.sendMessage(LocaleLoader.getString("Acrobatics.Roll.Text"));
            this.applyXpGain(this.calculateRollXP(damage, true), XPGainReason.PVE);
            return modifiedDamage;
        }
        if (!this.isFatal(damage)) {
            this.applyXpGain(this.calculateRollXP(damage, false), XPGainReason.PVE);
        }
        this.lastFallLocation = player.getLocation();
        return damage;
    }

    private double gracefulRollCheck(double damage) {
        double modifiedDamage = Acrobatics.calculateModifiedRollDamage(damage, Acrobatics.gracefulRollThreshold);
        if (!this.isFatal(modifiedDamage) && SkillUtils.activationSuccessful(SecondaryAbility.GRACEFUL_ROLL, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Acrobatics.Ability.Proc"));
            this.applyXpGain(this.calculateRollXP(damage, true), XPGainReason.PVE);
            return modifiedDamage;
        }
        if (!this.isFatal(damage)) {
            this.applyXpGain(this.calculateRollXP(damage, false), XPGainReason.PVE);
        }
        return damage;
    }

    public boolean exploitPrevention() {
        if (!Config.getInstance().getAcrobaticsPreventAFK()) {
            return false;
        }
        Player player = this.getPlayer();
        if (player.getItemInHand().getType() == Material.ENDER_PEARL || player.isInsideVehicle()) {
            return true;
        }
        Location fallLocation = player.getLocation();
        int maxTries = Config.getInstance().getAcrobaticsAFKMaxTries();
        boolean sameLocation = this.lastFallLocation != null && Misc.isNear(this.lastFallLocation, fallLocation, 2.0);
        this.fallTries = sameLocation ? Math.min(this.fallTries + 1, maxTries) : Math.max(this.fallTries - 1, 0);
        this.lastFallLocation = fallLocation;
        return this.fallTries + 1 > maxTries;
    }

    private boolean isFatal(double damage) {
        return this.getPlayer().getHealth() - damage <= 0.0;
    }

    private float calculateRollXP(double damage, boolean isRoll) {
        ItemStack boots = this.getPlayer().getInventory().getBoots();
        float xp = (float)(damage * (double)(isRoll ? Acrobatics.rollXpModifier : Acrobatics.fallXpModifier));
        if (boots != null && boots.containsEnchantment(Enchantment.PROTECTION_FALL)) {
            xp = (float)((double)xp * Acrobatics.featherFallXPModifier);
        }
        return xp;
    }
}

