/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.scheduler.BukkitRunnable;

public class PartyAutoKickTask
extends BukkitRunnable {
    private static final long KICK_TIME = 86400000L * (long)Config.getInstance().getAutoPartyKickTime();

    public void run() {
        HashMap<OfflinePlayer, Party> toRemove = new HashMap<OfflinePlayer, Party>();
        ArrayList<UUID> processedPlayers = new ArrayList<UUID>();
        long currentTime = System.currentTimeMillis();
        for (Party party : PartyManager.getParties()) {
            for (UUID memberUniqueId : party.getMembers().keySet()) {
                OfflinePlayer member = mcMMO.p.getServer().getOfflinePlayer(memberUniqueId);
                boolean isProcessed = processedPlayers.contains(memberUniqueId);
                if (!member.isOnline() && currentTime - member.getLastPlayed() > KICK_TIME || isProcessed) {
                    toRemove.put(member, party);
                }
                if (isProcessed) continue;
                processedPlayers.add(memberUniqueId);
            }
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            PartyManager.removeFromParty((OfflinePlayer)entry.getKey(), (Party)entry.getValue());
        }
    }
}

