/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.items;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class ChimaeraWingWarmup
extends BukkitRunnable {
    private McMMOPlayer mcMMOPlayer;

    public ChimaeraWingWarmup(McMMOPlayer mcMMOPlayer) {
        this.mcMMOPlayer = mcMMOPlayer;
    }

    public void run() {
        this.checkChimaeraWingTeleport();
    }

    private void checkChimaeraWingTeleport() {
        int timeRemaining;
        Player player = this.mcMMOPlayer.getPlayer();
        Location previousLocation = this.mcMMOPlayer.getTeleportCommenceLocation();
        if (player.getLocation().distanceSquared(previousLocation) > 1.0 || !player.getInventory().containsAtLeast(ChimaeraWing.getChimaeraWing(0), 1)) {
            player.sendMessage(LocaleLoader.getString("Teleport.Cancelled"));
            return;
        }
        ItemStack inHand = player.getItemInHand();
        if (!ItemUtils.isChimaeraWing(inHand) || inHand.getAmount() < Config.getInstance().getChimaeraUseCost()) {
            player.sendMessage(LocaleLoader.getString("Skills.NeedMore", LocaleLoader.getString("Item.ChimaeraWing.Name")));
            return;
        }
        long recentlyHurt = this.mcMMOPlayer.getRecentlyHurt();
        int hurtCooldown = Config.getInstance().getChimaeraRecentlyHurtCooldown();
        if (hurtCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, player)) > 0) {
            player.sendMessage(LocaleLoader.getString("Item.Injured.Wait", timeRemaining));
            return;
        }
        ChimaeraWing.chimaeraExecuteTeleport();
    }
}

