/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.database;

import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.uuid.UUIDFetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.scheduler.BukkitRunnable;

public class UUIDUpdateAsyncTask
extends BukkitRunnable {
    private mcMMO plugin;
    private static final int MAX_LOOKUP = Math.max(HiddenConfig.getInstance().getUUIDConvertAmount(), 100);
    private static final int RATE_LIMIT = HiddenConfig.getInstance().getMojangRateLimit();
    private static final long LIMIT_PERIOD = HiddenConfig.getInstance().getMojangLimitPeriod();
    private static final int BATCH_SIZE = MAX_LOOKUP * 3;
    private List<String> userNames;
    private int size;
    private int checkedUsers;
    private long startMillis;

    public UUIDUpdateAsyncTask(mcMMO plugin, List<String> userNames) {
        this.plugin = plugin;
        this.userNames = userNames;
        this.checkedUsers = 0;
        this.startMillis = System.currentTimeMillis();
    }

    public void run() {
        this.size = this.userNames.size();
        this.plugin.getLogger().info("Starting to check and update UUIDs, total amount of users: " + this.size);
        HashMap<String, UUID> fetchedUUIDs = new HashMap<String, UUID>();
        while (this.size != 0) {
            List<String> userNamesSection;
            if (this.checkedUsers + 100 > RATE_LIMIT) {
                try {
                    Thread.sleep(LIMIT_PERIOD);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                this.startMillis = System.currentTimeMillis();
                this.checkedUsers = 0;
            }
            if (this.size > MAX_LOOKUP) {
                userNamesSection = this.userNames.subList(this.size - MAX_LOOKUP, this.size);
                this.size -= MAX_LOOKUP;
            } else {
                userNamesSection = this.userNames.subList(0, this.size);
                this.size = 0;
            }
            try {
                fetchedUUIDs.putAll((Map<String, UUID>)new UUIDFetcher(userNamesSection).call());
            }
            catch (Exception e) {
                if (e.getMessage().contains("429")) {
                    this.size += userNamesSection.size();
                    try {
                        Thread.sleep(LIMIT_PERIOD);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        e.printStackTrace();
                        return;
                    }
                }
                this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch UUIDs!", e);
                return;
            }
            this.checkedUsers += userNamesSection.size();
            userNamesSection.clear();
            this.size = this.userNames.size();
            Misc.printProgress(this.checkedUsers, 200, this.startMillis);
            if (fetchedUUIDs.size() < BATCH_SIZE) continue;
            mcMMO.getDatabaseManager().saveUserUUIDs(fetchedUUIDs);
            fetchedUUIDs = new HashMap();
        }
        if (fetchedUUIDs.size() == 0 || mcMMO.getDatabaseManager().saveUserUUIDs(fetchedUUIDs)) {
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS);
            this.plugin.getLogger().info("UUID upgrade completed!");
        }
    }
}

