/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.chat.ChatManagerFactory;
import com.gmail.nossr50.chat.PartyChatManager;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.ShareHandler;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.Unarmed;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.HardcoreManager;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.Motd;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.HashSet;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final mcMMO plugin;

    public PlayerListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || Config.getInstance().getXPAfterTeleportCooldown() <= 0 || event.getFrom().equals((Object)event.getTo())) {
            return;
        }
        UserManager.getPlayer(player).actualizeTeleportATS();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeathLowest(PlayerDeathEvent event) {
        String deathMessage = event.getDeathMessage();
        if (deathMessage == null) {
            return;
        }
        Player player = event.getEntity();
        event.setDeathMessage(MobHealthbarUtils.fixDeathMessage(deathMessage, player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeathMonitor(PlayerDeathEvent event) {
        boolean statLossEnabled = HardcoreManager.isStatLossEnabled();
        boolean vampirismEnabled = HardcoreManager.isVampirismEnabled();
        if (!statLossEnabled && !vampirismEnabled) {
            return;
        }
        Player killedPlayer = event.getEntity();
        if (!killedPlayer.hasMetadata("mcMMO: Player Data") || Permissions.hardcoreBypass((Permissible)killedPlayer)) {
            return;
        }
        Player killer = killedPlayer.getKiller();
        if (statLossEnabled || killer != null && vampirismEnabled) {
            if (EventUtils.callPreDeathPenaltyEvent(killedPlayer).isCancelled()) {
                return;
            }
            if (killer != null && vampirismEnabled) {
                HardcoreManager.invokeVampirism(killer, killedPlayer);
            }
            if (statLossEnabled) {
                HardcoreManager.invokeStatPenalty(killedPlayer);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        mcMMOPlayer.checkGodMode();
        mcMMOPlayer.checkParty();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Item drop = event.getItemDrop();
        ItemStack dropStack = drop.getItemStack();
        if (ItemUtils.isSharable(dropStack)) {
            drop.setMetadata("mcMMO: Tracked Item", (MetadataValue)mcMMO.metadataValue);
        }
        SkillUtils.removeAbilityBuff(dropStack);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerFishHighest(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || !SkillType.FISHING.getPermissions(player)) {
            return;
        }
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        switch (event.getState()) {
            case FISHING: {
                if (!Permissions.krakenBypass((Permissible)player)) {
                    event.setCancelled(fishingManager.exploitPrevention());
                }
                return;
            }
            case CAUGHT_FISH: {
                Item fishingCatch = (Item)event.getCaught();
                if (Config.getInstance().getFishingOverrideTreasures() && fishingCatch.getItemStack().getType() != Material.RAW_FISH) {
                    fishingCatch.setItemStack(new ItemStack(Material.RAW_FISH, 1));
                }
                if (Permissions.vanillaXpBoost((Permissible)player, SkillType.FISHING)) {
                    event.setExpToDrop(fishingManager.handleVanillaXpBoost(event.getExpToDrop()));
                }
                return;
            }
            case IN_GROUND: {
                Block block = player.getTargetBlock((HashSet)null, 100);
                if (fishingManager.canIceFish(block)) {
                    event.setCancelled(true);
                    fishingManager.iceFishing(event.getHook(), block);
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFishMonitor(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || !SkillType.FISHING.getPermissions(player)) {
            return;
        }
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        Entity caught = event.getCaught();
        switch (event.getState()) {
            case FISHING: {
                if (fishingManager.canMasterAngler()) {
                    fishingManager.masterAngler(event.getHook());
                }
                return;
            }
            case CAUGHT_FISH: {
                fishingManager.handleFishing((Item)caught);
                return;
            }
            case CAUGHT_ENTITY: {
                if (fishingManager.canShake(caught)) {
                    fishingManager.shakeCheck((LivingEntity)caught);
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        Item drop = event.getItem();
        ItemStack dropStack = drop.getItemStack();
        if (drop.hasMetadata("mcMMO: Disarmed Item")) {
            if (!player.getName().equals(((MetadataValue)drop.getMetadata("mcMMO: Disarmed Item").get(0)).asString())) {
                event.setCancelled(true);
            }
            return;
        }
        if (!drop.hasMetadata("mcMMO: Tracked Item") && mcMMOPlayer.inParty() && ItemUtils.isSharable(dropStack)) {
            event.setCancelled(ShareHandler.handleItemShare(drop, mcMMOPlayer));
            if (event.isCancelled()) {
                player.playSound(player.getLocation(), Sound.ITEM_PICKUP, 0.2f, Misc.getPopPitch());
                return;
            }
        }
        if (mcMMOPlayer.isUsingUnarmed() && ItemUtils.isSharable(dropStack) || mcMMOPlayer.getAbilityMode(AbilityType.BERSERK)) {
            boolean pickupSuccess = Unarmed.handleItemPickup(player.getInventory(), drop);
            boolean cancel = Config.getInstance().getUnarmedItemPickupDisabled() || pickupSuccess;
            event.setCancelled(cancel);
            if (pickupSuccess) {
                player.playSound(player.getLocation(), Sound.ITEM_PICKUP, 0.2f, Misc.getPopPitch());
                player.updateInventory();
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        mcMMOPlayer.logout(false);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (Misc.isNPCEntity((Entity)player)) {
            return;
        }
        new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)mcMMO.p, 1L);
        if (Config.getInstance().getMOTDEnabled() && Permissions.motd((Permissible)player)) {
            Motd.displayAll(player);
        }
        if (this.plugin.isXPEventEnabled()) {
            player.sendMessage(LocaleLoader.getString("XPRate.Event", ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
        }
        if (Permissions.updateNotifications((Permissible)player) && this.plugin.isUpdateAvailable()) {
            player.sendMessage(LocaleLoader.getString("UpdateChecker.Outdated"));
            player.sendMessage(LocaleLoader.getString("UpdateChecker.NewAvailable"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        UserManager.getPlayer(player).actualizeRespawnATS();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractLowest(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        MiningManager miningManager = mcMMOPlayer.getMiningManager();
        Block block = event.getClickedBlock();
        ItemStack heldItem = player.getItemInHand();
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                Material type = block.getType();
                if (!Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() || player.isSneaking()) {
                    if (type == Repair.anvilMaterial && SkillType.REPAIR.getPermissions(player) && mcMMO.getRepairableManager().isRepairable(heldItem)) {
                        RepairManager repairManager = mcMMOPlayer.getRepairManager();
                        event.setCancelled(true);
                        if (heldItem.getEnchantments().size() > 0 && !repairManager.checkConfirmation(true)) break;
                        repairManager.handleRepair(heldItem);
                        player.updateInventory();
                        break;
                    }
                    if (type != Salvage.anvilMaterial || !SkillType.SALVAGE.getPermissions(player) || !mcMMO.getSalvageableManager().isSalvageable(heldItem)) break;
                    SalvageManager salvageManager = UserManager.getPlayer(player).getSalvageManager();
                    event.setCancelled(true);
                    if (heldItem.getEnchantments().size() > 0 && !salvageManager.checkConfirmation(true)) break;
                    SkillUtils.handleAbilitySpeedDecrease(player);
                    salvageManager.handleSalvage(block.getLocation(), heldItem);
                    player.updateInventory();
                    break;
                }
                if (!miningManager.canDetonate()) break;
                if (type == Material.TNT) {
                    event.setCancelled(true);
                    break;
                }
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: {
                SalvageManager salvageManager;
                Material type = block.getType();
                if ((!Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() || !player.isSneaking()) && Config.getInstance().getAbilitiesOnlyActivateWhenSneaking()) break;
                if (type == Repair.anvilMaterial && SkillType.REPAIR.getPermissions(player) && mcMMO.getRepairableManager().isRepairable(heldItem)) {
                    RepairManager repairManager = mcMMOPlayer.getRepairManager();
                    if (!repairManager.checkConfirmation(false)) break;
                    repairManager.setLastAnvilUse(0);
                    player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Repair.Pretty.Name")));
                    break;
                }
                if (type != Salvage.anvilMaterial || !SkillType.SALVAGE.getPermissions(player) || !mcMMO.getSalvageableManager().isSalvageable(heldItem) || !(salvageManager = mcMMOPlayer.getSalvageManager()).checkConfirmation(false)) break;
                salvageManager.setLastAnvilUse(0);
                player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Salvage.Pretty.Name")));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractMonitor(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ItemStack heldItem = player.getItemInHand();
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                HerbalismManager herbalismManager;
                Block block = event.getClickedBlock();
                BlockState blockState = block.getState();
                if (BlockUtils.canActivateAbilities(blockState)) {
                    if (Config.getInstance().getAbilitiesEnabled()) {
                        if (BlockUtils.canActivateHerbalism(blockState)) {
                            mcMMOPlayer.processAbilityActivation(SkillType.HERBALISM);
                        }
                        mcMMOPlayer.processAbilityActivation(SkillType.AXES);
                        mcMMOPlayer.processAbilityActivation(SkillType.EXCAVATION);
                        mcMMOPlayer.processAbilityActivation(SkillType.MINING);
                        mcMMOPlayer.processAbilityActivation(SkillType.SWORDS);
                        mcMMOPlayer.processAbilityActivation(SkillType.UNARMED);
                        mcMMOPlayer.processAbilityActivation(SkillType.WOODCUTTING);
                    }
                    ChimaeraWing.activationCheck(player);
                }
                if ((herbalismManager = mcMMOPlayer.getHerbalismManager()).canGreenThumbBlock(blockState)) {
                    player.setItemInHand(new ItemStack(Material.SEEDS, heldItem.getAmount() - 1));
                    if (!herbalismManager.processGreenThumbBlocks(blockState) || !EventUtils.simulateBlockBreak(block, player, false)) break;
                    blockState.update(true);
                    break;
                }
                if (!herbalismManager.canUseShroomThumb(blockState) || !herbalismManager.processShroomThumb(blockState) || !EventUtils.simulateBlockBreak(block, player, false)) break;
                blockState.update(true);
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (Config.getInstance().getAbilitiesEnabled()) {
                    mcMMOPlayer.processAbilityActivation(SkillType.AXES);
                    mcMMOPlayer.processAbilityActivation(SkillType.EXCAVATION);
                    mcMMOPlayer.processAbilityActivation(SkillType.HERBALISM);
                    mcMMOPlayer.processAbilityActivation(SkillType.MINING);
                    mcMMOPlayer.processAbilityActivation(SkillType.SWORDS);
                    mcMMOPlayer.processAbilityActivation(SkillType.UNARMED);
                    mcMMOPlayer.processAbilityActivation(SkillType.WOODCUTTING);
                }
                ChimaeraWing.activationCheck(player);
                MiningManager miningManager = mcMMOPlayer.getMiningManager();
                if (!miningManager.canDetonate()) break;
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!player.isSneaking()) break;
                Material type = heldItem.getType();
                TamingManager tamingManager = mcMMOPlayer.getTamingManager();
                if (type == Config.getInstance().getTamingCOTWMaterial(EntityType.WOLF)) {
                    tamingManager.summonWolf();
                    break;
                }
                if (type == Config.getInstance().getTamingCOTWMaterial(EntityType.OCELOT)) {
                    tamingManager.summonOcelot();
                    break;
                }
                if (type != Config.getInstance().getTamingCOTWMaterial(EntityType.HORSE)) break;
                tamingManager.summonHorse();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (Misc.isNPCEntity((Entity)player) || !UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer((OfflinePlayer)player);
        if (mcMMOPlayer == null) {
            mcMMO.p.debug(player.getName() + "is chatting, but is currently not logged in to the server.");
            mcMMO.p.debug("Party & Admin chat will not work properly for this player.");
            return;
        }
        ChatManager chatManager = null;
        if (mcMMOPlayer.isChatEnabled(ChatMode.PARTY)) {
            Party party = mcMMOPlayer.getParty();
            if (party == null) {
                mcMMOPlayer.disableChat(ChatMode.PARTY);
                player.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return;
            }
            chatManager = ChatManagerFactory.getChatManager((Plugin)this.plugin, ChatMode.PARTY);
            ((PartyChatManager)chatManager).setParty(party);
        } else if (mcMMOPlayer.isChatEnabled(ChatMode.ADMIN)) {
            chatManager = ChatManagerFactory.getChatManager((Plugin)this.plugin, ChatMode.ADMIN);
        }
        if (chatManager != null) {
            chatManager.handleChat(player, event.getMessage(), event.isAsynchronous());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!Config.getInstance().getLocale().equalsIgnoreCase("en_US")) {
            String message = event.getMessage();
            String command = message.substring(1).split(" ")[0];
            String lowerCaseCommand = command.toLowerCase();
            for (SkillType skill : SkillType.values()) {
                String skillName = skill.toString().toLowerCase();
                String localizedName = skill.getName().toLowerCase();
                if (lowerCaseCommand.equals(localizedName)) {
                    event.setMessage(message.replace(command, skillName));
                    break;
                }
                if (lowerCaseCommand.equals(skillName)) break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerStatisticIncrementEvent(PlayerStatisticIncrementEvent event) {
        if (!mcMMO.getHolidayManager().isAprilFirst()) {
            return;
        }
        mcMMO.getHolidayManager().handleStatisticEvent(event);
    }
}

