/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.alchemy;

import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import java.util.List;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public enum PotionStage {
    FIVE(5),
    FOUR(4),
    THREE(3),
    TWO(2),
    ONE(1);

    int numerical;

    private PotionStage(int numerical) {
        this.numerical = numerical;
    }

    public int toNumerical() {
        return this.numerical;
    }

    private static PotionStage getPotionStageNumerical(int numerical) {
        for (PotionStage potionStage : PotionStage.values()) {
            if (numerical < potionStage.toNumerical()) continue;
            return potionStage;
        }
        return ONE;
    }

    public static PotionStage getPotionStage(AlchemyPotion input, AlchemyPotion output) {
        PotionStage potionStage = PotionStage.getPotionStage(output);
        if (!PotionStage.isWaterBottle(input) && PotionStage.getPotionStage(input) == potionStage) {
            potionStage = FIVE;
        }
        return potionStage;
    }

    private static boolean isWaterBottle(AlchemyPotion input) {
        return input.getDataValue() == 0;
    }

    public static PotionStage getPotionStage(AlchemyPotion alchemyPotion) {
        Potion potion = alchemyPotion.toPotion(1);
        List<PotionEffect> effects = alchemyPotion.getEffects();
        int stage = 1;
        if (potion.getType() != null || !effects.isEmpty()) {
            ++stage;
        }
        if (potion.getLevel() > 1) {
            ++stage;
        } else if (!effects.isEmpty()) {
            for (PotionEffect effect : effects) {
                if (effect.getAmplifier() <= 0) continue;
                ++stage;
                break;
            }
        }
        if (potion.hasExtendedDuration()) {
            ++stage;
        }
        if (potion.isSplash()) {
            ++stage;
        }
        return PotionStage.getPotionStageNumerical(stage);
    }
}

