/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;

public class StatementFinalizer
extends AbstractCreateStatementInterceptor {
    private static final Log log = LogFactory.getLog(StatementFinalizer.class);
    protected ArrayList<WeakReference<Statement>> statements = new ArrayList();

    public Object createStatement(Object proxy, Method method, Object[] args, Object statement, long time) {
        try {
            if (statement instanceof Statement) {
                this.statements.add(new WeakReference<Statement>((Statement)statement));
            }
        }
        catch (ClassCastException x) {
            // empty catch block
        }
        return statement;
    }

    public void closeInvoked() {
        while (this.statements.size() > 0) {
            WeakReference<Statement> ws = this.statements.remove(0);
            Statement st = (Statement)ws.get();
            if (st == null) continue;
            try {
                st.close();
            }
            catch (Exception ignore) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to closed statement upon connection close.", ignore);
            }
        }
    }

    public void reset(ConnectionPool parent, PooledConnection con) {
        this.statements.clear();
        super.reset(parent, con);
    }
}

