/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CustomArmorConfig
extends ConfigLoader {
    private boolean needsUpdate = false;
    public List<Material> customBoots = new ArrayList<Material>();
    public List<Material> customChestplates = new ArrayList<Material>();
    public List<Material> customHelmets = new ArrayList<Material>();
    public List<Material> customLeggings = new ArrayList<Material>();
    public List<Repairable> repairables = new ArrayList<Repairable>();

    protected CustomArmorConfig(String fileName) {
        super("mods", fileName);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.loadArmor("Boots", this.customBoots);
        this.loadArmor("Chestplates", this.customChestplates);
        this.loadArmor("Helmets", this.customHelmets);
        this.loadArmor("Leggings", this.customLeggings);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.backup();
        }
    }

    private void loadArmor(String armorType, List<Material> materialList) {
        if (this.needsUpdate) {
            return;
        }
        ConfigurationSection armorSection = this.config.getConfigurationSection(armorType);
        if (armorSection == null) {
            return;
        }
        Set armorConfigSet = armorSection.getKeys(false);
        for (String armorName : armorConfigSet) {
            if (this.config.contains(armorType + "." + armorName + "." + ".ID")) {
                this.needsUpdate = true;
                return;
            }
            Material armorMaterial = Material.matchMaterial((String)armorName);
            if (armorMaterial == null) {
                plugin.getLogger().warning("Invalid material name. This item will be skipped. - " + armorName);
                continue;
            }
            boolean repairable = this.config.getBoolean(armorType + "." + armorName + ".Repairable");
            Material repairMaterial = Material.matchMaterial((String)this.config.getString(armorType + "." + armorName + ".Repair_Material", ""));
            if (repairable && repairMaterial == null) {
                plugin.getLogger().warning("Incomplete repair information. This item will be unrepairable. - " + armorName);
                repairable = false;
            }
            if (repairable) {
                byte repairData = (byte)this.config.getInt(armorType + "." + armorName + ".Repair_Material_Data_Value", -1);
                int repairQuantity = SkillUtils.getRepairAndSalvageQuantities(new ItemStack(armorMaterial), repairMaterial, repairData);
                if (repairQuantity == 0) {
                    repairQuantity = this.config.getInt(armorType + "." + armorName + ".Repair_Material_Quantity", 2);
                }
                String repairItemName = this.config.getString(armorType + "." + armorName + ".Repair_Material_Pretty_Name");
                int repairMinimumLevel = this.config.getInt(armorType + "." + armorName + ".Repair_MinimumLevel", 0);
                double repairXpMultiplier = this.config.getDouble(armorType + "." + armorName + ".Repair_XpMultiplier", 1.0);
                short durability = armorMaterial.getMaxDurability();
                if (durability == 0) {
                    durability = (short)this.config.getInt(armorType + "." + armorName + ".Durability", 70);
                }
                this.repairables.add(RepairableFactory.getRepairable(armorMaterial, repairMaterial, repairData, repairItemName, repairMinimumLevel, repairQuantity, durability, ItemType.ARMOR, MaterialType.OTHER, repairXpMultiplier));
            }
            materialList.add(armorMaterial);
        }
    }
}

