/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillGuideCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.Motd;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class SkillCommand
implements TabExecutor {
    protected SkillType skill;
    private String skillName;
    protected DecimalFormat percent = new DecimalFormat("##0.00%");
    protected DecimalFormat decimal = new DecimalFormat("##0.00");
    private CommandExecutor skillGuideCommand;

    public SkillCommand(SkillType skill) {
        this.skill = skill;
        this.skillName = skill.getName();
        this.skillGuideCommand = new SkillGuideCommand(skill);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (CommandUtils.noConsoleUsage(sender)) {
            return true;
        }
        if (!CommandUtils.hasPlayerDataKey(sender)) {
            return true;
        }
        switch (args.length) {
            case 0: {
                List<String> statsMessages;
                Player player = (Player)sender;
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
                boolean isLucky = Permissions.lucky((Permissible)player, this.skill);
                boolean hasEndurance = PerksUtils.handleActivationPerks(player, 0, 0) != 0;
                float skillValue = mcMMOPlayer.getSkillLevel(this.skill);
                this.permissionsCheck(player);
                this.dataCalculations(player, skillValue, isLucky);
                if (Config.getInstance().getSkillUseBoard()) {
                    ScoreboardManager.enablePlayerSkillScoreboard(player, this.skill);
                }
                if (!this.skill.isChildSkill()) {
                    player.sendMessage(LocaleLoader.getString("Skills.Header", this.skillName));
                    player.sendMessage(LocaleLoader.getString("Commands.XPGain", LocaleLoader.getString("Commands.XPGain." + StringUtils.getCapitalized(this.skill.toString()))));
                    player.sendMessage(LocaleLoader.getString("Effects.Level", (int)skillValue, mcMMOPlayer.getSkillXpLevel(this.skill), mcMMOPlayer.getXpToLevel(this.skill)));
                } else {
                    player.sendMessage(LocaleLoader.getString("Skills.Header", this.skillName + " " + LocaleLoader.getString("Skills.Child")));
                    player.sendMessage(LocaleLoader.getString("Commands.XPGain", LocaleLoader.getString("Commands.XPGain.Child")));
                    player.sendMessage(LocaleLoader.getString("Effects.Child", (int)skillValue));
                    player.sendMessage(LocaleLoader.getString("Skills.Header", LocaleLoader.getString("Skills.Parents")));
                    Set<SkillType> parents = FamilyTree.getParents(this.skill);
                    for (SkillType parent : parents) {
                        player.sendMessage(parent.getName() + " - " + LocaleLoader.getString("Effects.Level", mcMMOPlayer.getSkillLevel(parent), mcMMOPlayer.getSkillXpLevel(parent), mcMMOPlayer.getXpToLevel(parent)));
                    }
                }
                List<String> effectMessages = this.effectsDisplay();
                if (!effectMessages.isEmpty()) {
                    player.sendMessage(LocaleLoader.getString("Skills.Header", LocaleLoader.getString("Effects.Effects")));
                    if (isLucky) {
                        player.sendMessage(Motd.PERK_PREFIX + LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Perks.Lucky.Name"), LocaleLoader.getString("Perks.Lucky.Desc", this.skillName)));
                    }
                    for (String message : effectMessages) {
                        player.sendMessage(message);
                    }
                }
                if (!(statsMessages = this.statsDisplay(player, skillValue, hasEndurance, isLucky)).isEmpty()) {
                    player.sendMessage(LocaleLoader.getString("Skills.Header", LocaleLoader.getString("Commands.Stats.Self")));
                    for (String message : statsMessages) {
                        player.sendMessage(message);
                    }
                }
                player.sendMessage(LocaleLoader.getString("Guides.Available", this.skillName, this.skillName.toLowerCase()));
                return true;
            }
        }
        return this.skillGuideCommand.onCommand(sender, command, label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                return ImmutableList.of((Object)"?");
            }
        }
        return ImmutableList.of();
    }

    protected int calculateRank(float skillValue, int maxLevel, int rankChangeLevel) {
        return Math.min((int)skillValue, maxLevel) / rankChangeLevel;
    }

    protected String[] calculateAbilityDisplayValues(double chance, boolean isLucky) {
        String[] displayValues = new String[]{this.percent.format(Math.min(chance, 100.0) / 100.0), isLucky ? this.percent.format(Math.min(chance * 1.3333, 100.0) / 100.0) : null};
        return displayValues;
    }

    protected String[] calculateAbilityDisplayValues(float skillValue, SecondaryAbility skillAbility, boolean isLucky) {
        int maxBonusLevel = AdvancedConfig.getInstance().getMaxBonusLevel(skillAbility);
        return this.calculateAbilityDisplayValues(AdvancedConfig.getInstance().getMaxChance(skillAbility) / (double)maxBonusLevel * (double)Math.min(skillValue, (float)maxBonusLevel), isLucky);
    }

    protected String[] calculateLengthDisplayValues(Player player, float skillValue) {
        int maxLength = this.skill.getAbility().getMaxLength();
        int length = 2 + (int)(skillValue / (float)AdvancedConfig.getInstance().getAbilityLength());
        int enduranceLength = PerksUtils.handleActivationPerks(player, length, maxLength);
        if (maxLength != 0) {
            length = Math.min(length, maxLength);
        }
        return new String[]{String.valueOf(length), String.valueOf(enduranceLength)};
    }

    protected abstract void dataCalculations(Player var1, float var2, boolean var3);

    protected abstract void permissionsCheck(Player var1);

    protected abstract List<String> effectsDisplay();

    protected abstract List<String> statsDisplay(Player var1, float var2, boolean var3, boolean var4);
}

