/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SalvageCommand
extends SkillCommand {
    private boolean canAdvancedSalvage;
    private boolean canArcaneSalvage;

    public SalvageCommand() {
        super(SkillType.SALVAGE);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canAdvancedSalvage = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ADVANCED_SALVAGE);
        this.canArcaneSalvage = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ARCANE_SALVAGE);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canAdvancedSalvage) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Salvage.Effect.0"), LocaleLoader.getString("Salvage.Effect.1")));
        }
        if (this.canArcaneSalvage) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Salvage.Effect.2"), LocaleLoader.getString("Salvage.Effect.3")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        SalvageManager salvageManager = UserManager.getPlayer(player).getSalvageManager();
        if (this.canAdvancedSalvage) {
            if (skillValue < (float)Salvage.advancedSalvageUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Salvage.Ability.Locked.0", Salvage.advancedSalvageUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Ability.Bonus.0"), LocaleLoader.getString("Salvage.Ability.Bonus.1", this.percent.format(salvageManager.getMaxSalvagePercentage()))));
            }
        }
        if (this.canArcaneSalvage) {
            messages.add(LocaleLoader.getString("Salvage.Arcane.Rank", salvageManager.getArcaneSalvageRank(), Salvage.Tier.values().length));
            if (Salvage.arcaneSalvageEnchantLoss) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractFull"), this.percent.format(salvageManager.getExtractFullEnchantChance() / 100.0)));
            }
            if (Salvage.arcaneSalvageDowngrades) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractPartial"), this.percent.format(salvageManager.getExtractPartialEnchantChance() / 100.0)));
            }
        }
        return messages;
    }
}

