/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ArcheryCommand
extends SkillCommand {
    private String skillShotBonus;
    private String dazeChance;
    private String dazeChanceLucky;
    private String retrieveChance;
    private String retrieveChanceLucky;
    private boolean canSkillShot;
    private boolean canDaze;
    private boolean canRetrieve;

    public ArcheryCommand() {
        super(SkillType.ARCHERY);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canSkillShot) {
            double bonus = (double)(skillValue / (float)Archery.skillShotIncreaseLevel) * Archery.skillShotIncreasePercentage;
            this.skillShotBonus = this.percent.format(Math.min(bonus, Archery.skillShotMaxBonusPercentage));
        }
        if (this.canDaze) {
            String[] dazeStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.DAZE, isLucky);
            this.dazeChance = dazeStrings[0];
            this.dazeChanceLucky = dazeStrings[1];
        }
        if (this.canRetrieve) {
            String[] retrieveStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.RETRIEVE, isLucky);
            this.retrieveChance = retrieveStrings[0];
            this.retrieveChanceLucky = retrieveStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkillShot = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SKILL_SHOT);
        this.canDaze = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.DAZE);
        this.canRetrieve = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.RETRIEVE);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canSkillShot) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Archery.Effect.0"), LocaleLoader.getString("Archery.Effect.1")));
        }
        if (this.canDaze) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Archery.Effect.2"), LocaleLoader.getString("Archery.Effect.3", Archery.dazeBonusDamage)));
        }
        if (this.canRetrieve) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Archery.Effect.4"), LocaleLoader.getString("Archery.Effect.5")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canSkillShot) {
            messages.add(LocaleLoader.getString("Archery.Combat.SkillshotBonus", this.skillShotBonus));
        }
        if (this.canDaze) {
            messages.add(LocaleLoader.getString("Archery.Combat.DazeChance", this.dazeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dazeChanceLucky) : ""));
        }
        if (this.canRetrieve) {
            messages.add(LocaleLoader.getString("Archery.Combat.RetrieveChance", this.retrieveChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.retrieveChanceLucky) : ""));
        }
        return messages;
    }
}

