/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class SkillresetCommand
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!this.permissionsCheckSelf(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[0])) {
                    return true;
                }
                SkillType skill = args[0].equalsIgnoreCase("all") ? null : SkillType.getSkill(args[1]);
                this.editValues((Player)sender, UserManager.getPlayer(sender.getName()).getProfile(), skill);
                return true;
            }
            case 2: {
                if (!this.permissionsCheckOthers(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[1])) {
                    return true;
                }
                SkillType skill = args[1].equalsIgnoreCase("all") ? null : SkillType.getSkill(args[1]);
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(playerName);
                if (mcMMOPlayer == null) {
                    PlayerProfile profile;
                    UUID uuid = null;
                    OfflinePlayer player = mcMMO.p.getServer().getOfflinePlayer(playerName);
                    if (player != null) {
                        uuid = player.getUniqueId();
                    }
                    if (CommandUtils.unloadedProfile(sender, profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName, uuid, false))) {
                        return true;
                    }
                    this.editValues(null, profile, skill);
                } else {
                    this.editValues(mcMMOPlayer.getPlayer(), mcMMOPlayer.getProfile(), skill);
                }
                SkillresetCommand.handleSenderMessage(sender, playerName, skill);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)args[1], SkillType.SKILL_NAMES, new ArrayList(SkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected void handleCommand(Player player, PlayerProfile profile, SkillType skill) {
        int levelsRemoved = profile.getSkillLevel(skill);
        float xpRemoved = profile.getSkillXpLevelRaw(skill);
        profile.modifySkill(skill, 0);
        if (player == null) {
            profile.scheduleAsyncSave();
            return;
        }
        EventUtils.handleLevelChangeEvent(player, skill, levelsRemoved, xpRemoved, false, XPGainReason.COMMAND);
    }

    protected boolean permissionsCheckSelf(CommandSender sender) {
        return Permissions.skillreset((Permissible)sender);
    }

    protected boolean permissionsCheckOthers(CommandSender sender) {
        return Permissions.skillresetOthers((Permissible)sender);
    }

    protected void handlePlayerMessageAll(Player player) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.All"));
    }

    protected void handlePlayerMessageSkill(Player player, SkillType skill) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.Single", skill.getName()));
    }

    private boolean validateArguments(CommandSender sender, String skillName) {
        return skillName.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(sender, skillName);
    }

    protected static void handleSenderMessage(CommandSender sender, String playerName, SkillType skill) {
        if (skill == null) {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", playerName));
        } else {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", skill.getName(), playerName));
        }
    }

    protected void editValues(Player player, PlayerProfile profile, SkillType skill) {
        if (skill == null) {
            for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
                this.handleCommand(player, profile, skillType);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player);
            }
        } else {
            this.handleCommand(player, profile, skill);
            if (player != null) {
                this.handlePlayerMessageSkill(player, skill);
            }
        }
    }
}

