/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public abstract class ExperienceCommand
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 2: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!this.permissionsCheckSelf(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[0], args[1])) {
                    return true;
                }
                SkillType skill = SkillType.getSkill(args[0]);
                if (args[1].equalsIgnoreCase("all")) {
                    skill = null;
                }
                this.editValues((Player)sender, UserManager.getPlayer(sender.getName()).getProfile(), skill, Integer.parseInt(args[1]));
                return true;
            }
            case 3: {
                if (!this.permissionsCheckOthers(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[1], args[2])) {
                    return true;
                }
                SkillType skill = SkillType.getSkill(args[1]);
                if (args[1].equalsIgnoreCase("all")) {
                    skill = null;
                }
                int value = Integer.parseInt(args[2]);
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(playerName);
                if (mcMMOPlayer == null) {
                    PlayerProfile profile;
                    UUID uuid = null;
                    OfflinePlayer player = mcMMO.p.getServer().getOfflinePlayer(playerName);
                    if (player != null) {
                        uuid = player.getUniqueId();
                    }
                    if (CommandUtils.unloadedProfile(sender, profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName, uuid, false))) {
                        return true;
                    }
                    this.editValues(null, profile, skill, value);
                } else {
                    this.editValues(mcMMOPlayer.getPlayer(), mcMMOPlayer.getProfile(), skill, value);
                }
                ExperienceCommand.handleSenderMessage(sender, playerName, skill);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)args[1], SkillType.SKILL_NAMES, new ArrayList(SkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean permissionsCheckSelf(CommandSender var1);

    protected abstract boolean permissionsCheckOthers(CommandSender var1);

    protected abstract void handleCommand(Player var1, PlayerProfile var2, SkillType var3, int var4);

    protected abstract void handlePlayerMessageAll(Player var1, int var2);

    protected abstract void handlePlayerMessageSkill(Player var1, int var2, SkillType var3);

    private boolean validateArguments(CommandSender sender, String skillName, String value) {
        return !CommandUtils.isInvalidInteger(sender, value) && (skillName.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(sender, skillName));
    }

    protected static void handleSenderMessage(CommandSender sender, String playerName, SkillType skill) {
        if (skill == null) {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", playerName));
        } else {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", skill.getName(), playerName));
        }
    }

    protected void editValues(Player player, PlayerProfile profile, SkillType skill, int value) {
        if (skill == null) {
            for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
                this.handleCommand(player, profile, skillType, value);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player, value);
            }
        } else {
            this.handleCommand(player, profile, skill, value);
            if (player != null) {
                this.handlePlayerMessageSkill(player, value, skill);
            }
        }
    }
}

