/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.api.exceptions.InvalidFormulaTypeException;
import com.gmail.nossr50.api.exceptions.InvalidPlayerException;
import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.api.exceptions.InvalidXPGainReasonException;
import com.gmail.nossr50.api.exceptions.McMMOPlayerNotFoundException;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class ExperienceAPI {
    private ExperienceAPI() {
    }

    public static boolean isValidSkillType(String skillType) {
        return SkillType.getSkill(skillType) != null;
    }

    public static boolean isNonChildSkill(String skillType) {
        SkillType skill = SkillType.getSkill(skillType);
        return skill != null && !skill.isChildSkill();
    }

    @Deprecated
    public static void addRawXP(Player player, String skillType, int XP) {
        ExperienceAPI.addRawXP(player, skillType, (float)XP);
    }

    @Deprecated
    public static void addRawXP(Player player, String skillType, float XP) {
        ExperienceAPI.addRawXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addRawXP(Player player, String skillType, float XP, String xpGainReason) {
        ExperienceAPI.addRawXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addRawXP(Player player, String skillType, float XP, String xpGainReason, boolean isUnshared) {
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason));
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason));
    }

    @Deprecated
    public static void addRawXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addRawXPOffline(playerName, skillType, (float)XP);
    }

    @Deprecated
    public static void addRawXPOffline(String playerName, String skillType, float XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)Math.floor(XP));
    }

    public static void addRawXPOffline(UUID uuid, String skillType, float XP) {
        ExperienceAPI.addOfflineXP(uuid, ExperienceAPI.getSkillType(skillType), (int)Math.floor(XP));
    }

    @Deprecated
    public static void addMultipliedXP(Player player, String skillType, int XP) {
        ExperienceAPI.addMultipliedXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addMultipliedXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason));
    }

    @Deprecated
    public static void addMultipliedXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addModifiedXP(Player player, String skillType, int XP) {
        ExperienceAPI.addModifiedXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addModifiedXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.addModifiedXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addModifiedXP(Player player, String skillType, int XP, String xpGainReason, boolean isUnshared) {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(skill, (int)((double)XP / skill.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason));
            return;
        }
        ExperienceAPI.getPlayer(player).applyXpGain(skill, (int)((double)XP / skill.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()), ExperienceAPI.getXPGainReason(xpGainReason));
    }

    @Deprecated
    public static void addModifiedXPOffline(String playerName, String skillType, int XP) {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        ExperienceAPI.addOfflineXP(playerName, skill, (int)((double)XP / skill.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    @Deprecated
    public static void addXP(Player player, String skillType, int XP) {
        ExperienceAPI.addXP(player, skillType, XP, "UNKNOWN");
    }

    public static void addXP(Player player, String skillType, int XP, String xpGainReason) {
        ExperienceAPI.addXP(player, skillType, XP, xpGainReason, false);
    }

    public static void addXP(Player player, String skillType, int XP, String xpGainReason, boolean isUnshared) {
        if (isUnshared) {
            ExperienceAPI.getPlayer(player).beginUnsharedXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason));
            return;
        }
        ExperienceAPI.getPlayer(player).beginXpGain(ExperienceAPI.getSkillType(skillType), XP, ExperienceAPI.getXPGainReason(xpGainReason));
    }

    public static int getXP(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getOfflineXP(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXP(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getXPRaw(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static float getOfflineXPRaw(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getOfflineXPRaw(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getXPToNextLevel(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getOfflineXPToNextLevel(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXPToNextLevel(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getXPRemaining(Player player, String skillType) {
        SkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getPlayer(player).getProfile();
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    @Deprecated
    public static int getOfflineXPRemaining(String playerName, String skillType) {
        SkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    public static float getOfflineXPRemaining(UUID uuid, String skillType) {
        SkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        return (float)profile.getXpToLevel(skill) - profile.getSkillXpLevelRaw(skill);
    }

    public static void addLevel(Player player, String skillType, int levels) {
        ExperienceAPI.getPlayer(player).addLevels(ExperienceAPI.getSkillType(skillType), levels);
    }

    @Deprecated
    public static void addLevelOffline(String playerName, String skillType, int levels) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            for (SkillType parentSkill : parentSkills) {
                profile.addLevels(parentSkill, levels / parentSkills.size());
            }
            profile.scheduleAsyncSave();
            return;
        }
        profile.addLevels(skill, levels);
        profile.scheduleAsyncSave();
    }

    public static void addLevelOffline(UUID uuid, String skillType, int levels) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            for (SkillType parentSkill : parentSkills) {
                profile.addLevels(parentSkill, levels / parentSkills.size());
            }
            profile.scheduleAsyncSave();
            return;
        }
        profile.addLevels(skill, levels);
        profile.scheduleAsyncSave();
    }

    public static int getLevel(Player player, String skillType) {
        return ExperienceAPI.getPlayer(player).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    @Deprecated
    public static int getLevelOffline(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getLevelOffline(UUID uuid, String skillType) {
        return ExperienceAPI.getOfflineProfile(uuid).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevel(Player player) {
        return ExperienceAPI.getPlayer(player).getPowerLevel();
    }

    @Deprecated
    public static int getPowerLevelOffline(String playerName) {
        int powerLevel = 0;
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        for (SkillType type : SkillType.NON_CHILD_SKILLS) {
            powerLevel += profile.getSkillLevel(type);
        }
        return powerLevel;
    }

    public static int getPowerLevelOffline(UUID uuid) {
        int powerLevel = 0;
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(uuid);
        for (SkillType type : SkillType.NON_CHILD_SKILLS) {
            powerLevel += profile.getSkillLevel(type);
        }
        return powerLevel;
    }

    public static int getLevelCap(String skillType) {
        return Config.getInstance().getLevelCap(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevelCap() {
        return Config.getInstance().getPowerLevelCap();
    }

    @Deprecated
    public static int getPlayerRankSkill(String playerName, String skillType) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(playerName).getPlayerName()).get((Object)ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getPlayerRankSkill(UUID uuid, String skillType) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(uuid).getPlayerName()).get((Object)ExperienceAPI.getNonChildSkillType(skillType));
    }

    @Deprecated
    public static int getPlayerRankOverall(String playerName) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(playerName).getPlayerName()).get(null);
    }

    public static int getPlayerRankOverall(UUID uuid) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(uuid).getPlayerName()).get(null);
    }

    public static void setLevel(Player player, String skillType, int skillLevel) {
        ExperienceAPI.getPlayer(player).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    @Deprecated
    public static void setLevelOffline(String playerName, String skillType, int skillLevel) {
        ExperienceAPI.getOfflineProfile(playerName).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setLevelOffline(UUID uuid, String skillType, int skillLevel) {
        ExperienceAPI.getOfflineProfile(uuid).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setXP(Player player, String skillType, int newValue) {
        ExperienceAPI.getPlayer(player).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    @Deprecated
    public static void setXPOffline(String playerName, String skillType, int newValue) {
        ExperienceAPI.getOfflineProfile(playerName).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void setXPOffline(UUID uuid, String skillType, int newValue) {
        ExperienceAPI.getOfflineProfile(uuid).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void removeXP(Player player, String skillType, int xp) {
        ExperienceAPI.getPlayer(player).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    @Deprecated
    public static void removeXPOffline(String playerName, String skillType, int xp) {
        ExperienceAPI.getOfflineProfile(playerName).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    public static void removeXPOffline(UUID uuid, String skillType, int xp) {
        ExperienceAPI.getOfflineProfile(uuid).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    public static int getXpNeededToLevel(int level) {
        return mcMMO.getFormulaManager().getCachedXpToLevel(level, ExperienceConfig.getInstance().getFormulaType());
    }

    public static int getXpNeededToLevel(int level, String formulaType) {
        return mcMMO.getFormulaManager().getCachedXpToLevel(level, ExperienceAPI.getFormulaType(formulaType));
    }

    private static void addOfflineXP(UUID playerUniqueId, SkillType skill, int XP) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerUniqueId);
        profile.addXp(skill, XP);
        profile.save();
    }

    @Deprecated
    private static void addOfflineXP(String playerName, SkillType skill, int XP) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        profile.addXp(skill, XP);
        profile.scheduleAsyncSave();
    }

    private static PlayerProfile getOfflineProfile(UUID uuid) {
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(uuid);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    @Deprecated
    private static PlayerProfile getOfflineProfile(String playerName) {
        UUID uuid = mcMMO.p.getServer().getOfflinePlayer(playerName).getUniqueId();
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(uuid);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    private static SkillType getSkillType(String skillType) throws InvalidSkillException {
        SkillType skill = SkillType.getSkill(skillType);
        if (skill == null) {
            throw new InvalidSkillException();
        }
        return skill;
    }

    private static SkillType getNonChildSkillType(String skillType) throws InvalidSkillException, UnsupportedOperationException {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (skill.isChildSkill()) {
            throw new UnsupportedOperationException("Child skills do not have XP");
        }
        return skill;
    }

    private static XPGainReason getXPGainReason(String reason) throws InvalidXPGainReasonException {
        XPGainReason xpGainReason = XPGainReason.getXPGainReason(reason);
        if (xpGainReason == null) {
            throw new InvalidXPGainReasonException();
        }
        return xpGainReason;
    }

    private static FormulaType getFormulaType(String formula) throws InvalidFormulaTypeException {
        FormulaType formulaType = FormulaType.getFormulaType(formula);
        if (formulaType == null) {
            throw new InvalidFormulaTypeException();
        }
        return formulaType;
    }

    private static McMMOPlayer getPlayer(Player player) throws McMMOPlayerNotFoundException {
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            throw new McMMOPlayerNotFoundException(player);
        }
        return UserManager.getPlayer(player);
    }
}

