/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.spawning.spawners.SpawnerManager;
import io.lumine.xikage.mythicmobs.util.NumberConversions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Effect;

public class MythicSpawner
implements Cloneable {
    private boolean active = true;
    private boolean ready = true;
    private String name;
    private String group;
    private String mobName;
    private AbstractLocation location;
    private String world;
    private int x;
    private int y;
    private int z;
    private boolean useTimer = true;
    private long spawnCooldownMillis = 0L;
    private long spawnCooldownTimer = 0L;
    private long spawnWarmupMillis = 4L;
    private long spawnWarmupTimer = 0L;
    private int spawnRadius = 0;
    private int spawnRadiusY = 0;
    private int maxMobs = 1;
    private int mobsPerSpawn = 1;
    private int mobLevel = 1;
    private boolean showFlames = false;
    private boolean breakable = false;
    private boolean checkForPlayers = true;
    private int activeRange = 40;
    private int leashRange = 32;
    private boolean leashHeal = false;
    private boolean leashResetThreat = false;
    private int leashTimer = 0;
    private int ICD = 8;
    private int mobHeight = 0;
    private ArrayList<String> conditions = new ArrayList();
    protected int cachedActiveMobs = 0;
    private Collection<UUID> mobs = Collections.newSetFromMap(new ConcurrentHashMap());

    public MythicSpawner(String name, AbstractLocation location, String mobName) {
        this.name = name;
        this.mobName = mobName;
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(this.mobName);
        if (mm == null && this.location == null) {
            MythicMobs.throwWarning("error-spawners-invalidmobtype", "Error enabling spawner '{0}' - MobType '{1}' is invalid! Spawner cannot initialize. Disabling.", this.name, this.mobName);
            this.Disable();
        }
        this.mobHeight = mm.getMythicEntity().getHeight();
        this.location = location;
        this.world = location.getWorld().getName();
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.spawnRadius = 0;
        if (this.location == null) {
            MythicMobs.throwWarning("error-spawners-invalidlocation", "Location data for spawner '{0}' is invalid! Spawner cannot be attached to world. Disabling.", this.name);
            this.Disable();
        }
        this.spawnCooldownTimer = System.currentTimeMillis();
        this.spawnWarmupTimer = System.currentTimeMillis();
    }

    public MythicSpawner(String name, String group, String mobName, String world, int x, int y, int z, int radius, int radiusY, boolean useTimer, int maxMobs, int mps, int moblevel, int cooldown, int cooldownTimer, int warmup, int warmupTimer, int activeRange, int leashRange, boolean leashHeal, boolean leashResetThreat, boolean showFlames, boolean breakable, int activeMobs, boolean checkForPlayers, ArrayList<String> conditions) {
        MythicMobs.debug(1, "Loading spawner: " + name + "");
        this.name = name;
        this.group = group;
        this.mobName = mobName;
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(this.mobName);
        if (mm == null) {
            MythicMobs.throwWarning("error-spawners-invalidmobtype", "Error enabling spawner '{0}' - MobType '{1}' is invalid! Spawner cannot initialize. Disabling.", this.name, this.mobName);
            this.Disable();
        }
        this.mobHeight = mm.getMythicEntity().getHeight();
        this.location = new AbstractLocation(BukkitAdapter.adapt(Bukkit.getWorld((String)world)), x, y, z);
        if (this.location == null) {
            MythicMobs.throwWarning("error-spawners-invalidlocation", "Location data for spawner '{0}' is invalid! Spawner cannot be attached to world. Disabling.", this.name);
            this.Disable();
        }
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.spawnRadius = radius;
        this.spawnRadiusY = radiusY;
        this.useTimer = useTimer;
        this.maxMobs = maxMobs;
        this.mobsPerSpawn = mps;
        this.mobLevel = moblevel;
        this.setCooldownSeconds(cooldown);
        this.setRemainingCooldownSeconds(cooldownTimer);
        this.setWarmupSeconds(warmup);
        this.setRemainingWarmupSeconds(warmupTimer);
        this.showFlames = showFlames;
        this.activeRange = activeRange;
        this.leashRange = leashRange;
        this.leashHeal = leashHeal;
        this.leashResetThreat = leashResetThreat;
        this.cachedActiveMobs = activeMobs;
        this.conditions = conditions;
        this.setBreakable(breakable);
        this.checkForPlayers = checkForPlayers;
        if (this.spawnRadius < 0) {
            this.spawnRadius = 0;
        }
        if (this.spawnRadiusY < 1) {
            this.spawnRadiusY = 1;
        }
        if (this.getRemainingWarmupSeconds() > 0 || this.getRemainingCooldownSeconds() > 0) {
            this.ready = false;
        }
    }

    public void unloadSpawner() {
        this.mobs.removeIf(uuid -> {
            Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob((UUID)uuid);
            if (maybeMob.isPresent()) {
                if (maybeMob.get().getType().getDespawns()) {
                    ActiveMob am = maybeMob.get();
                    if (!am.isDead() && am.getEntity().isValid()) {
                        ++this.cachedActiveMobs;
                        am.getEntity().remove();
                        MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                    }
                } else {
                    return false;
                }
            }
            return true;
        });
        this.ICD = 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getTypeName() {
        return this.mobName;
    }

    public void setType(String type) {
        this.mobName = type;
    }

    public void setType(MythicMob type) {
        this.mobName = type.getInternalName();
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public void setLocation(AbstractLocation location) {
        this.location = location;
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.world = location.getWorld().getName();
    }

    public int getBlockX() {
        return this.x;
    }

    public void setBlockX(int i) {
        this.x = i;
    }

    public int getBlockY() {
        return this.y;
    }

    public void setBlockY(int i) {
        this.y = i;
    }

    public int getBlockZ() {
        return this.z;
    }

    public void setBlockZ(int i) {
        this.z = i;
    }

    public String getWorldName() {
        return this.world;
    }

    public void setWorld(String worldName) {
        this.world = worldName;
    }

    public void setOnCooldown() {
        this.spawnCooldownTimer = System.currentTimeMillis();
    }

    public boolean isOnCooldown() {
        return this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis() > 0L;
    }

    public int getCooldownSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis);
    }

    public void setCooldownSeconds(int cooldown) {
        this.spawnCooldownMillis = TimeUnit.SECONDS.toMillis(cooldown);
    }

    public int getRemainingCooldownSeconds() {
        if (this.isOnCooldown()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingCooldownSeconds(long seconds) {
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public void setOnWarmup() {
        this.spawnWarmupTimer = System.currentTimeMillis();
    }

    public boolean isOnWarmup() {
        return this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis() > 0L;
    }

    public int getWarmupSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis);
    }

    public void setWarmupSeconds(int warmup) {
        this.spawnWarmupMillis = TimeUnit.SECONDS.toMillis(warmup);
    }

    public int getRemainingWarmupSeconds() {
        if (this.isOnWarmup()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingWarmupSeconds(long seconds) {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public boolean getUseTimer() {
        return this.useTimer;
    }

    public void setUseTimer(boolean bool) {
        this.useTimer = bool;
    }

    public boolean getShowFlames() {
        return this.showFlames;
    }

    public void setShowFlames(boolean bool) {
        this.showFlames = bool;
    }

    public int getLeashRange() {
        return this.leashRange;
    }

    public void setLeashRange(int range) {
        this.leashRange = range;
    }

    public boolean getHealLeashedMobs() {
        return this.leashHeal;
    }

    public void setHealLeashedMobs(boolean bool) {
        this.leashHeal = bool;
    }

    public int getMaxMobs() {
        return this.maxMobs;
    }

    public void setMaxMobs(int max) {
        this.maxMobs = max;
    }

    public int getMobsPerSpawn() {
        return this.mobsPerSpawn;
    }

    public void setMobsPerSpawn(int amount) {
        this.mobsPerSpawn = amount;
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int radius) {
        this.spawnRadius = radius;
    }

    public int getSpawnRadiusY() {
        return this.spawnRadiusY;
    }

    public void setSpawnRadiusY(int radius) {
        this.spawnRadiusY = radius;
    }

    public int getMobLevel() {
        return this.mobLevel;
    }

    public void setMobLevel(int level) {
        this.mobLevel = level;
    }

    public List<String> getConditionList() {
        return this.conditions;
    }

    public Collection<UUID> getAssociatedMobs() {
        return this.mobs;
    }

    public void setAssociatedMobs(Collection<UUID> collection) {
        this.mobs = collection;
    }

    public int getInternalCooldown() {
        return this.ICD;
    }

    public void tickSpawnerClock() {
        --this.ICD;
        boolean spawn = true;
        if (this.isOnCooldown() || this.isOnWarmup()) {
            spawn = false;
            this.ready = false;
        } else if (!this.useTimer) {
            spawn = false;
        }
        if (!this.active) {
            return;
        }
        if (this.ICD <= 1) {
            if (!(this.location != null && Bukkit.getWorld((String)this.world) != null || this.reattachToWorld())) {
                this.ICD = 8;
                return;
            }
            if (!(!this.checkForPlayers && this.cachedActiveMobs <= 0 || this.location.isLoaded() && SpawnerManager.playerWithinSpawnerRange(this.activeRange, this.location))) {
                this.ICD = 4;
                return;
            }
            if (this.maxMobs <= this.getNumberOfMobs()) {
                this.cleanMobList();
                if (this.isOnWarmup()) {
                    return;
                }
            }
        } else if (this.ICD > 1) {
            return;
        }
        if (this.leashRange > 0) {
            ++this.leashTimer;
            if (this.leashTimer >= 2) {
                this.Leash();
                this.leashTimer = 0;
            }
        }
        if (ConfigManager.debugLevel > 0 || this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (this.cachedActiveMobs > 0) {
            while (this.cachedActiveMobs > 0) {
                this.Spawn();
                --this.cachedActiveMobs;
            }
            return;
        }
        if (this.maxMobs <= this.getNumberOfMobs()) {
            return;
        }
        if (spawn && this.useTimer && !ConfigManager.debugMode && this.checkSpawnConditions()) {
            Collection<ActiveMob> spawns = this.Spawn();
            for (ActiveMob am : spawns) {
                new TriggeredSkill(SkillTrigger.READY, am, null);
            }
        }
    }

    public void ActivateSpawner() {
        if (this.location.getWorld() == null) {
            MythicMobs.debug(4, "Spawner world is unloaded.");
            return;
        }
        if (ConfigManager.debugLevel > 0 || this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (!this.active || this.isOnCooldown() || this.isOnWarmup()) {
            return;
        }
        if (this.maxMobs <= this.getNumberOfMobs()) {
            if (this.cleanMobList()) {
                if (this.spawnWarmupMillis > 0L) {
                    this.setOnWarmup();
                    return;
                }
            } else {
                return;
            }
        }
        if (this.checkSpawnConditions()) {
            Collection<ActiveMob> spawns = this.Spawn();
            for (ActiveMob am : spawns) {
                new TriggeredSkill(SkillTrigger.READY, am, null);
            }
        }
    }

    public boolean checkSpawnConditions() {
        if (this.conditions != null) {
            for (String strCondition : this.conditions) {
                String[] split = strCondition.split(" ");
                String conditionData = split.length == 1 ? null : split[1];
                try {
                    if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(this.location), null, conditionData)) continue;
                    return false;
                }
                catch (Exception e) {
                    MythicMobs.throwWarning("error-spawnconditions-invalid", "A spawning condition appears to be invalid: {0}", strCondition);
                }
            }
        }
        return true;
    }

    public Collection<ActiveMob> Spawn() {
        if (!this.active) {
            return null;
        }
        MythicMobs.debug(3, "Spawner " + this.name + " Spawn() called. Spawning mobs...");
        if (this.cachedActiveMobs == 0) {
            this.setOnCooldown();
        }
        AbstractLocation loc = new AbstractLocation(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 1.0, this.location.getZ() + 0.5);
        boolean good = false;
        int j = 25;
        ArrayList<ActiveMob> mobs = new ArrayList<ActiveMob>();
        for (int i = this.mobsPerSpawn; i > 0 && this.maxMobs > this.getNumberOfMobs(); --i) {
            ActiveMob am;
            if (this.spawnRadius > 0 || this.spawnRadiusY > 1) {
                j = 25;
                good = false;
                while (!good) {
                    double nx = this.location.getX() - (double)this.spawnRadius + (double)MythicMobs.r.nextInt(this.spawnRadius * 2) + 0.5;
                    double nz = this.location.getZ() - (double)this.spawnRadius + (double)MythicMobs.r.nextInt(this.spawnRadius * 2) + 0.5;
                    double ny = this.spawnRadiusY > 0 ? this.location.getY() - (double)this.spawnRadiusY + (double)MythicMobs.r.nextInt(this.spawnRadiusY * 2) + 0.5 : this.location.getY() + 1.0;
                    good = true;
                    for (int k = 0; k < this.mobHeight + 1; ++k) {
                        loc = new AbstractLocation(this.location.getWorld(), nx, ny + (double)k, nz);
                        if (!BukkitAdapter.adapt(loc).getBlock().getType().isSolid()) continue;
                        good = false;
                    }
                    if (good) {
                        loc = new AbstractLocation(this.location.getWorld(), nx, ny, nz);
                    } else {
                        --j;
                    }
                    if (j != 0) continue;
                    loc = new AbstractLocation(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 1.0, loc.getZ() + 0.5);
                    break;
                }
            } else {
                loc = new AbstractLocation(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 1.0, this.location.getZ() + 0.5);
            }
            if ((am = MythicMobs.inst().getMobManager().spawnMob(this.mobName, loc, this.mobLevel)) == null) {
                MythicMobs.debug(3, "-- Spawner " + this.name + " failed to spawn mob: SpawnMythicMob returned null.");
                return mobs;
            }
            this.mobs.add(am.getUniqueId());
            am.setSpawner(this);
            mobs.add(am);
        }
        MythicMobs.debug(3, "-- Spawner spawned mob(s). Number of mobs tied to spawner now: " + this.getNumberOfMobs());
        return mobs;
    }

    public void Leash() {
        if (this.leashRange < 1) {
            return;
        }
        for (UUID uuid : this.mobs) {
            Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(uuid);
            if (!maybeMob.isPresent()) continue;
            ActiveMob am = maybeMob.get();
            if (am.getLocation().getWorld().equals(this.location.getWorld())) {
                if (!(this.location.distanceSquared(am.getEntity().getLocation()) > NumberConversions.square(this.leashRange))) continue;
                if (am.getEntity().getVehicle() != null) {
                    AbstractEntity l = am.getEntity();
                    while (l.getVehicle() != null) {
                        if (this.leashHeal && l.isLiving()) {
                            l.setHealth(l.getMaxHealth());
                        }
                        if (this.leashResetThreat) {
                            MythicMobs.inst().getMobManager().getMythicMobInstance(l).resetTarget();
                        }
                        l = l.getVehicle();
                    }
                }
                this.doLeash(am);
                continue;
            }
            this.doLeash(am);
        }
    }

    public void doLeash(ActiveMob am) {
        AbstractLocation spawnLocation = this.location.clone().add(0.5, 1.0, 0.5);
        am.getEntity().teleport(spawnLocation);
        if (this.leashHeal && am.getEntity().isLiving()) {
            am.getEntity().setHealth(am.getEntity().getMaxHealth());
        }
        if (this.leashResetThreat) {
            am.resetTarget();
        }
    }

    private boolean cleanMobList() {
        Iterator<UUID> it = this.mobs.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            if (!MythicMobs.inst().getMobManager().isActiveMob(uuid)) {
                it.remove();
                return true;
            }
            ActiveMob am = MythicMobs.inst().getMobManager().getActiveMob(uuid).get();
            if (!am.isDead()) continue;
            if (this.getNumberOfMobs() >= this.maxMobs) {
                this.setOnWarmup();
            }
            it.remove();
            return true;
        }
        return false;
    }

    public void trackMob(ActiveMob am) {
        this.mobs.add(am.getUniqueId());
    }

    public void markMobDespawned(ActiveMob am) {
        this.mobs.remove(am.getUniqueId());
    }

    public void markMobDead(ActiveMob am) {
        if (this.mobs.contains(am.getUniqueId())) {
            if (this.getNumberOfMobs() >= this.maxMobs) {
                MythicMobs.log("Removed mob from spawner");
                this.setOnWarmup();
            }
            this.mobs.remove(am.getUniqueId());
        }
    }

    public boolean reattachToWorld() {
        if (Bukkit.getWorld((String)this.world) == null) {
            return false;
        }
        this.location = new AbstractLocation(BukkitAdapter.adapt(Bukkit.getWorld((String)this.world)), this.x, this.y, this.z);
        if (this.location == null) {
            MythicMobs.debug(2, "Spawner " + this.name + " has an invalid location and could not be reattached to world. Perhaps the world is unloaded?");
            return false;
        }
        return true;
    }

    public String getInternalName() {
        return this.name;
    }

    public int getNumberOfMobs() {
        return this.mobs.size() + this.cachedActiveMobs;
    }

    public void Disable() {
        this.active = false;
    }

    public void Enable() {
        this.active = true;
    }

    public double distanceTo(AbstractLocation abstractLocation) {
        return abstractLocation.distance(this.location);
    }

    public MythicSpawner clone() throws CloneNotSupportedException {
        return (MythicSpawner)super.clone();
    }

    public void resetTimers() {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis;
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis;
    }

    public boolean getCheckForPlayers() {
        return this.checkForPlayers;
    }

    public void setCheckForPlayers(boolean b) {
        this.checkForPlayers = b;
    }

    public int getActivationRange() {
        return this.activeRange;
    }

    public void setActivationRange(int range) {
        this.activeRange = range;
    }

    public boolean getLeashResetsThreat() {
        return this.leashResetThreat;
    }

    public void setLeashResetsThreat(boolean b) {
        this.leashResetThreat = b;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public void setBreakable(boolean b) {
        if (this.breakable == b) {
            return;
        }
        if (b) {
            MythicMobs.inst().getSpawnerManager().setBreakable(this, true);
            this.breakable = true;
        } else {
            MythicMobs.inst().getSpawnerManager().setBreakable(this, false);
            this.breakable = false;
        }
    }

    public int getChunkX() {
        return this.x / 16;
    }

    public int getChunkZ() {
        return this.z / 16;
    }

    public String getChunkString() {
        return this.world + "-" + this.getChunkX() + "-" + this.getChunkZ();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getNumberOfCachedMobs() {
        return this.cachedActiveMobs;
    }
}

