/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.random;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnGenerator;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawner;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnerAction;
import io.lumine.xikage.mythicmobs.util.BlockUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;

public class RandomSpawnerManager {
    private final MythicMobs core;
    private List<File> spawnFiles;
    private IOLoader<MythicMobs> defaultSpawns;
    private List<IOLoader<MythicMobs>> spawnLoaders;
    public List<RandomSpawner> listRandomSpawningA = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningR = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningD = new ArrayList<RandomSpawner>();
    public Set<RandomSpawnPoint> landSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> airSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> seaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> lavaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> groundSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<ActiveMob> randomlySpawnedMobs = Collections.newSetFromMap(new ConcurrentHashMap());
    RandomPointGeneratorLand generatorLand;

    public RandomSpawnerManager(MythicMobs core) {
        this.core = core;
        if (ConfigManager.generateRSPoints() && ConfigManager.getRSPointsPerSecondLand() > 0) {
            this.generatorLand = new RandomPointGeneratorLand();
        }
    }

    public void loadRandomSpawns() {
        this.defaultSpawns = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleRandomSpawns.yml", "RandomSpawns");
        this.spawnFiles = IOHandler.getAllFiles(this.defaultSpawns.thefile.getParent());
        this.spawnLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), this.spawnFiles, "RandomSpawns");
        this.listRandomSpawningA.clear();
        this.listRandomSpawningR.clear();
        this.listRandomSpawningD.clear();
        for (IOLoader<MythicMobs> sl : this.spawnLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfig mc = new MythicConfig(name, sl.getCustomConfig());
                String file = sl.thefile.getName();
                RandomSpawner rs = new RandomSpawner(file, name, mc);
                if (rs.getAction() == RandomSpawnerAction.ADD) {
                    this.listRandomSpawningA.add(rs);
                    continue;
                }
                if (rs.getAction() == RandomSpawnerAction.DENY) {
                    this.listRandomSpawningD.add(rs);
                    continue;
                }
                this.listRandomSpawningR.add(rs);
            }
        }
        MythicMobs.debug(2, "Sorting ADD Random Spawners...");
        this.listRandomSpawningA = this.sortSpawners(this.listRandomSpawningA);
        MythicMobs.debug(2, "Sorting REPLACE Random Spawners...");
        this.listRandomSpawningR = this.sortSpawners(this.listRandomSpawningR);
    }

    public int getNumberOfSpawners() {
        return this.listRandomSpawningA.size() + this.listRandomSpawningR.size() + this.listRandomSpawningD.size();
    }

    public AbstractEntity handleSpawnEvent(RandomSpawnPoint rsp) {
        if (rsp.getEntity() == null) {
            return null;
        }
        if (this.listRandomSpawningR.size() == 0) {
            return null;
        }
        if (!ConfigManager.generateRSPoints()) {
            this.landSpawnPoints.add(rsp);
        }
        for (RandomSpawner RS : this.listRandomSpawningR) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            return RS.spawn(rsp).getEntity();
        }
        return null;
    }

    public void reload() {
        if (this.generatorLand != null) {
            this.generatorLand.stop();
        }
        if (ConfigManager.generateRSPoints() && ConfigManager.getRSPointsPerSecondLand() > 0) {
            this.generatorLand = new RandomPointGeneratorLand();
        }
    }

    public void shutdown() {
        if (this.generatorLand != null) {
            this.generatorLand.stop();
        }
    }

    public void spawnMobs() {
        this.landSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp));
        this.landSpawnPoints.clear();
    }

    public void doSpawns(RandomSpawnPoint rsp) {
        if (rsp == null) {
            return;
        }
        for (RandomSpawner RS : this.listRandomSpawningA) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            RS.spawn(rsp);
            return;
        }
    }

    public int getMobsNearPlayer(AbstractPlayer p) {
        int i = 0;
        int spawnRadius = (int)Math.pow(ConfigManager.getRSPlayerRadius(), 2.0);
        for (AbstractEntity e : MythicMobs.inst().getEntityManager().getLivingEntities(p.getLocation().getWorld())) {
            if (!(e.getLocation().distanceSquared(p.getLocation()) <= (double)spawnRadius)) continue;
            ++i;
        }
        return i;
    }

    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        return MythicMobs.inst().getWorldManager().isChunkLoaded(world, x, z);
    }

    public Set<RandomSpawnPoint> getLandSpawnPoints() {
        return this.landSpawnPoints;
    }

    private List<RandomSpawner> sortSpawners(List<RandomSpawner> list) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            for (int q = 1; q < list.size() - i; ++q) {
                RandomSpawner o = list.get(q - 1);
                RandomSpawner n = list.get(q);
                if (o.priority >= n.priority) continue;
                list.set(q - 1, n);
                list.set(q, o);
            }
        }
        MythicMobs.debug(2, "Random Spawns Sorted to:");
        for (i = 0; i < list.size(); ++i) {
            MythicMobs.debug(2, "* " + list.get(i).getPriority() + " = " + list.get((int)i).name);
        }
        return list;
    }

    public class RandomPointGeneratorLand
    extends RandomSpawnGenerator {
        private final List<AbstractPlayer> players = new ArrayList<AbstractPlayer>();

        @Override
        public void generateSpawnPoints() {
            if (MythicMobs.inst().getEntityManager().getPlayers().size() <= 0) {
                return;
            }
            long startTime = System.currentTimeMillis();
            this.players.clear();
            this.players.addAll(MythicMobs.inst().getEntityManager().getPlayers());
            Collections.shuffle(this.players);
            int n = 0;
            long time = System.currentTimeMillis();
            boolean good = true;
            try {
                for (AbstractPlayer player : this.players) {
                    if (player.isInCreativeMode()) continue;
                    if (System.currentTimeMillis() - startTime <= (long)ConfigManager.getRSMaxGenerationTimeMillis()) {
                        for (int i = 0; i < ConfigManager.getRSPointsPerSecondLand(); ++i) {
                            RandomSpawnPoint point = this.findPointNearPlayer(player);
                            if (point == null) continue;
                            Iterator<RandomSpawner> it = RandomSpawnerManager.this.listRandomSpawningD.iterator();
                            good = true;
                            while (it.hasNext()) {
                                RandomSpawner RS = it.next();
                                if (!RS.checkSpawn(point)) continue;
                                good = false;
                                break;
                            }
                            if (!good) continue;
                            RandomSpawnerManager.this.landSpawnPoints.add(point);
                            ++n;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public RandomSpawnPoint findPointNearPlayer(AbstractPlayer player) {
            Location location = BukkitAdapter.adapt(player.getLocation());
            Location spawnLocation = new Location(location.getWorld(), 0.0, 0.0, 0.0);
            int spawnRadius = ConfigManager.getRSPlayerRadius();
            int spawnRadiusY = ConfigManager.getRSPlayerRadiusY();
            int minRadiusSquared = 256;
            boolean good = true;
            for (int i = 0; i < 10; ++i) {
                int nx = (int)(location.getX() - (double)spawnRadius) + MythicMobs.r.nextInt(spawnRadius * 2);
                int nz = (int)(location.getZ() - (double)spawnRadius) + MythicMobs.r.nextInt(spawnRadius * 2);
                int ny = (int)(location.getY() - (double)spawnRadiusY) + MythicMobs.r.nextInt(spawnRadiusY * 2);
                spawnLocation.setX((double)nx);
                spawnLocation.setY((double)ny);
                spawnLocation.setZ((double)nz);
                if (!RandomSpawnerManager.this.isChunkLoaded(player.getWorld(), spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4)) {
                    MythicMobs.debug(4, "-- Skipping player, area chunks not loaded.");
                    return null;
                }
                if (spawnLocation.distanceSquared(location) < (double)minRadiusSquared) continue;
                if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) {
                    good = false;
                    for (int j = 0; j < spawnRadiusY * 2; ++j) {
                        spawnLocation.setY((double)(--ny));
                        if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) continue;
                        good = true;
                        break;
                    }
                    if (!good) continue;
                }
                good = true;
                for (int k = 1; k < 3; ++k) {
                    spawnLocation.setY(spawnLocation.getY() + 1.0);
                    if (BlockUtil.isBreathable(spawnLocation.getBlock().getType())) continue;
                    good = false;
                    break;
                }
                if (!good) continue;
                AbstractLocation returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny + 1, (double)nz + 0.5);
                return new RandomSpawnPoint(returnLocation, RandomSpawnPoint.PointType.LAND);
            }
            return null;
        }
    }
}

