/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import java.util.HashSet;

public class MTLocation
extends ILocationSelector {
    protected double x = 0.0;
    protected double y = 0.0;
    protected double z = 0.0;

    public MTLocation(MythicLineConfig mlc) {
        String coords = mlc.getString(new String[]{"location", "loc", "l", "c"}, null, new String[0]);
        if (coords != null) {
            String[] split = coords.split(",");
            try {
                this.x = Double.parseDouble(split[0]);
                this.y = Double.parseDouble(split[1]);
                this.z = Double.parseDouble(split[2]);
            }
            catch (Exception ex) {
                MythicMobs.targeterConfigError("LOCATION", coords, "The 'location' attribute is required and must be in the format l=x,y,z.");
                return;
            }
        } else {
            this.x = mlc.getDouble("x", 0.0);
            this.y = mlc.getDouble("y", 0.0);
            this.z = mlc.getDouble("z", 0.0);
        }
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation l = MythicMobs.inst().getMinecraftServer().newLocation(am.getEntity().getWorld(), this.x, this.y, this.z);
        targets.add(l);
        return targets;
    }
}

