/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class ThreatSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float amount = 1.0f;

    public ThreatSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = false;
        this.amount = (float)mlc.getDouble("amount", 1.0);
        this.amount = (float)mlc.getDouble("a", (double)this.amount);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        if (am.getThreatTable() == null) {
            return false;
        }
        if (MythicMobs.inst().getMobManager().isActiveMob(target)) {
            ActiveMob amt = MythicMobs.inst().getMobManager().getMythicMobInstance(target);
            if (am.hasFaction() && am.getFaction().equals(amt.getFaction())) {
                return false;
            }
        }
        if (this.amount > 0.0f) {
            am.getThreatTable().threatGain(target, this.amount);
        } else {
            am.getThreatTable().threatLoss(target, -1.0f * this.amount);
        }
        return true;
    }
}

