/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.mechanics.SkillSkill;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import java.util.HashSet;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SudoSkillMechanic
extends SkillSkill {
    private boolean casterAsTrigger = false;

    public SudoSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.casterAsTrigger = mlc.getBoolean(new String[]{"setcasterastrigger", "cat"}, false);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        SkillTargeter targeter;
        HashSet<AbstractEntity> targets = data.getEntityTargets();
        if (this.targeter.isPresent() && (targeter = (SkillTargeter)this.targeter.get()) instanceof IEntitySelector) {
            targets = ((IEntitySelector)targeter).getEntities(data);
            ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
        }
        if (targets == null || targets.size() == 0) {
            return false;
        }
        for (AbstractEntity target : targets) {
            SkillCaster caster = MythicMobs.inst().getMobManager().isActiveMob(target) ? MythicMobs.inst().getMobManager().getMythicMobInstance(target) : new GenericCaster(target);
            final SkillMetadata newData = data.deepClone();
            newData.setCaster(caster);
            if (this.casterAsTrigger) {
                newData.setTrigger(data.getCaster().getEntity());
            }
            if (!this.metaskill.isPresent()) continue;
            final Skill ms = (Skill)this.metaskill.get();
            if (ms.isUsable(newData)) {
                MythicMobs.debug(3, "------ Executing SudoSkill " + this.skillName);
                if (this.forceSync) {
                    newData.setIsAsync(false);
                    new BukkitRunnable(){

                        public void run() {
                            newData.setIsAsync(false);
                            ms.execute(newData);
                        }
                    }.runTask((Plugin)MythicMobs.inst());
                    continue;
                }
                ms.execute(newData);
                continue;
            }
            MythicMobs.debug(3, "------ Skill is not usable at this time! Cancelling.");
            return false;
        }
        return true;
    }
}

