/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class SoundEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    String sound;
    float pitch;
    float volume;

    public SoundEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.sound = mlc.getString("sound", "reddust");
        this.sound = mlc.getString("s", this.sound);
        this.pitch = mlc.getFloat("pitch", 1.0f);
        this.pitch = mlc.getFloat("p", this.pitch);
        this.volume = mlc.getFloat("volume", 1.0f);
        this.volume = mlc.getFloat("v", this.volume);
        if (this.sound.equals("random.wood_click")) {
            this.sound = "random.wood click";
        } else if (this.sound.equals("mob.ghast.affectionate_scream")) {
            this.sound = "mob.ghast.affectionate scream";
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playSoundEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playSoundEffect(target.getLocation());
        return false;
    }

    protected void playSoundEffect(AbstractLocation l) {
        MythicMobs.inst().getVolatileCodeHandler().PlaySoundAtLocation(l, this.sound, this.volume, this.pitch);
    }
}

