/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;

public class ShootMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected ProjectileType projectileType = ProjectileType.REGULAR;
    protected int damage;
    protected int maxdistance;
    protected float velocity;
    protected double hSpread;
    protected double vSpread;
    protected boolean powerAffectsVelocity;
    protected float startYOffset;
    protected Class<? extends Projectile> projectileClass;
    protected ItemStack projectileItem;
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected int tickInterval;
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected boolean calculateFiringAngle;
    protected boolean fromOrigin;

    public ShootMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        String strProjectile = mlc.getString(new String[]{"type", "t"}, "arrow", new String[0]);
        this.damage = mlc.getInteger(new String[]{"damage", "d"}, 5);
        this.maxdistance = mlc.getInteger(new String[]{"maxdistance", "md"}, 64);
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 1.0f);
        this.vSpread = mlc.getDouble(new String[]{"vspread", "vs"}, 0.0);
        this.hSpread = mlc.getDouble(new String[]{"hspread", "hs"}, 0.0);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.startYOffset = mlc.getFloat("startyoffset", 0.0f);
        this.startYOffset = mlc.getFloat("syo", this.startYOffset);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.calculateFiringAngle = mlc.getBoolean(new String[]{"calculatefiringangle", "cfa"}, false);
        switch (strProjectile.toUpperCase()) {
            case "ARROW": {
                this.projectileClass = Arrow.class;
                break;
            }
            case "SNOWBALL": {
                this.projectileClass = Snowball.class;
                break;
            }
            case "EGG": {
                this.projectileClass = Egg.class;
                break;
            }
            case "ENDERPEARL": {
                this.projectileClass = EnderPearl.class;
                break;
            }
            case "POTION": {
                this.projectileClass = ThrownPotion.class;
                break;
            }
            case "ITEM": {
                this.projectileType = ProjectileType.ITEM;
                break;
            }
            case "BLOCK": 
            case "FALLING_BLOCK": {
                this.projectileType = ProjectileType.BLOCK;
                break;
            }
            default: {
                this.projectileClass = Arrow.class;
            }
        }
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        TaskManager.get().runAsyncLater(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onTickSkillName);
            if (this.onHitSkillName != null) {
                this.onHitSkill = MythicMobs.inst().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onHitSkillName);
            if (this.onEndSkillName != null) {
                this.onEndSkill = MythicMobs.inst().getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onEndSkillName);
        }, 200);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    public boolean shoot(SkillMetadata data, AbstractLocation target) {
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        float power = data.getPower();
        ProjectileData pd = new ProjectileData(caster, this.damage, this.onHitSkill, this.onEndSkill, power);
        if (!this.onTickSkill.isPresent() && this.onTickSkillName != null) {
            this.onTickSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTickSkillName);
        }
        if (!this.onHitSkill.isPresent() && this.onHitSkillName != null) {
            this.onHitSkill = MythicMobs.inst().getSkillManager().getSkill(this.onHitSkillName);
        }
        if (!this.onEndSkill.isPresent() && this.onEndSkillName != null) {
            this.onEndSkill = MythicMobs.inst().getSkillManager().getSkill(this.onEndSkillName);
        }
        float v = this.velocity;
        if (this.powerAffectsVelocity) {
            v *= power;
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.clone().add(0.0, this.startYOffset, 0.0);
        }
        AbstractEntity projectile = this.projectileType.equals((Object)ProjectileType.ITEM) ? SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, v, pd, this.fromOrigin) : (this.projectileType.equals((Object)ProjectileType.BLOCK) ? SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, v, pd, this.fromOrigin) : (this.calculateFiringAngle ? SkillAdapter.get().shootArcProjectile(caster, target, origin, this.projectileClass, v, pd, this.fromOrigin) : SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, v, pd, this.fromOrigin)));
        new ProjectileTracker(data, projectile, power);
        return true;
    }

    protected class ProjectileTracker
    implements Runnable {
        private int taskId;
        private SkillMetadata data;
        private SkillCaster caster;
        private AbstractEntity projectile;
        private boolean hasEnded = false;
        private float power;

        public ProjectileTracker(SkillMetadata caster, AbstractEntity projectile, float power) {
            this.caster = caster.getCaster();
            this.data = caster;
            this.projectile = projectile;
            this.power = power;
            this.taskId = TaskManager.get().scheduleAsyncTask(this, 0, ShootMechanic.this.tickInterval);
        }

        @Override
        public void run() {
            if (!this.projectile.isValid()) {
                this.doEndSkill();
                this.stop();
            }
            if (this.projectile.getBukkitEntity() instanceof Projectile && ((Projectile)this.projectile.getBukkitEntity()).isOnGround()) {
                this.doEndSkill();
            }
            if (ShootMechanic.this.onTickSkill.isPresent() && ShootMechanic.this.onTickSkill.get().usable(this.data, null)) {
                ShootMechanic.this.onTickSkill.get().execute(null, this.caster, null, this.projectile.getLocation().clone(), null, null, this.power);
            }
        }

        private void doEndSkill() {
            if (!this.hasEnded && ShootMechanic.this.onEndSkill.isPresent()) {
                if (ShootMechanic.this.onEndSkill.get().usable(this.data, null)) {
                    ShootMechanic.this.onEndSkill.get().execute(null, this.caster, null, this.projectile.getLocation().clone(), null, null, this.power);
                }
                this.hasEnded = true;
            }
        }

        public void stop() {
            TaskManager.get().cancelTask(this.taskId);
        }
    }

    public static class ProjectileData {
        private SkillCaster caster;
        private int damage;
        private Optional<Skill> onHitSkill;
        private Optional<Skill> onEndSkill;
        private float power;

        public ProjectileData(SkillCaster caster, int damage, Optional<Skill> onHitSkill, Optional<Skill> onEndSkill, float power) {
            this.caster = caster;
            this.damage = damage;
            this.onHitSkill = onHitSkill;
            this.onEndSkill = onEndSkill;
            this.power = power;
        }

        public SkillCaster getCaster() {
            return this.caster;
        }

        public int getDamage() {
            return this.damage;
        }

        public float getPower() {
            return this.power;
        }

        public void executeHitSkill(AbstractEntity projectile, AbstractEntity target) {
            HashSet t = Sets.newHashSet();
            t.add(target);
            SkillMetadata meta = new SkillMetadata(SkillTrigger.ATTACK, this.caster, target, projectile.getLocation(), t, null, this.power);
            if (this.onHitSkill.isPresent() && this.onHitSkill.get().usable(meta, null)) {
                this.onHitSkill.get().execute(meta);
            }
            if (this.onEndSkill.isPresent() && this.onEndSkill.get().usable(meta, null)) {
                this.onEndSkill.get().execute(null, this.caster, null, projectile.getLocation().clone(), null, null, this.power);
            }
        }
    }

    protected static enum ProjectileType {
        REGULAR,
        ITEM,
        BLOCK;

    }
}

