/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SendTitleSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected String title;
    protected String subtitle;
    protected int timeIn;
    protected int timeSt;
    protected int timeOt;

    public SendTitleSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        this.title = mlc.getString(new String[]{"title", "t"});
        try {
            this.title = this.title.substring(1, this.title.length() - 1);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("SENDTITLE", line, "The 'title' attribute is required.");
            this.title = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
            MythicMobs.inst().handleException(ex);
        }
        this.subtitle = mlc.getString(new String[]{"subtitle", "st"});
        try {
            this.subtitle = this.subtitle.substring(1, this.subtitle.length() - 1);
        }
        catch (Exception ex) {
            this.subtitle = null;
        }
        this.timeIn = mlc.getInteger("fadein", 1);
        this.timeIn = mlc.getInteger("fi", this.timeIn);
        this.timeSt = mlc.getInteger("duration", 1);
        this.timeSt = mlc.getInteger("d", this.timeSt);
        this.timeOt = mlc.getInteger("fadeout", 1);
        this.timeOt = mlc.getInteger("fo", this.timeOt);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        String t = SkillString.parseMobVariables(this.title, data.getCaster(), target, data.getTrigger());
        String st = SkillString.parseMobVariables(this.subtitle, data.getCaster(), target, data.getTrigger());
        Entity e = BukkitAdapter.adapt(target);
        if (e instanceof Player) {
            MythicMobs.inst().getVolatileCodeHandler().sendTitleToPlayer((Player)e, t, st, this.timeIn, this.timeSt, this.timeOt);
            return true;
        }
        return false;
    }
}

