/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.inventivetalent.glow.GlowAPI;

public class GlowEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    protected GlowAPI.Color color;
    protected int duration;

    public GlowEffect(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        String color = mlc.getString(new String[]{"color", "c"}, "WHITE", new String[0]);
        try {
            this.color = GlowAPI.Color.valueOf((String)color);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("GLOW", line, "The GLOW Effect requires GlowAPI and the 'color' attribute must be a valid GlowAPI Color.");
        }
        this.duration = mlc.getInteger("duration", 100);
        this.duration = mlc.getInteger("d", this.duration);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target);
        return true;
    }

    private class Animator {
        public Animator(AbstractEntity entity) {
            TaskManager.get().run(() -> GlowAPI.setGlowing((Entity)BukkitAdapter.adapt(entity), (GlowAPI.Color)GlowEffect.this.color, (Collection)Bukkit.getOnlinePlayers()));
            TaskManager.get().runLater(() -> GlowAPI.setGlowing((Entity)BukkitAdapter.adapt(entity), (boolean)false, (Collection)Bukkit.getOnlinePlayers()), GlowEffect.this.duration);
        }
    }
}

