/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class DamageSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected double amount = 1.0;
    protected boolean ignore_armor = false;
    protected boolean preventKnockback;
    protected boolean preventImmunity;

    public DamageSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.amount = mlc.getDouble(new String[]{"amount", "a"}, 1.0);
        this.ignore_armor = mlc.getBoolean(new String[]{"ignorearmor", "ia", "i"}, false);
        this.preventKnockback = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        this.preventImmunity = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        if (data.getCaster().isUsingDamageSkill()) {
            return false;
        }
        double damage = this.amount * (double)data.getPower();
        MythicMobs.debug(3, "Damage AbstractSkill Fired for " + damage + " with " + data.getPower() + " power");
        SkillAdapter.get().doDamage(data.getCaster(), target, damage, this.ignore_armor, this.preventKnockback, this.preventImmunity);
        return true;
    }
}

