/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.legacy.LegacyMythicSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ActivateSpawnerSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ArrowVolleySkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.AtomEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.BaseDamageMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.BlockMaskEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.BlockUnmaskEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.CancelEventMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.CommandSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ConsumeHeldItemMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ConsumeSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.CurrencyGiveMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.CurrencyTakeMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.CustomMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.DNAEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.DamagePercentMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.DamageSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.DecapitateMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.DelaySkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.DisguiseSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.DismountSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.DopplegangerSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.EjectPassengerSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.EnderBeamMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.EnderEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.EquipSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ExplosionEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ExplosionSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.FireworkEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.FlamesEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ForcePullSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.GCDSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.GeyserEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.GlowEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.HealPercentMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.HealSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.IgniteSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ItemSprayEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.JumpSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.LeapSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.LightningEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.LightningSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.LungeMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.MessageJSONMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.MessageSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.MissileSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyGlobalScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyMobScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyProjectileMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyTargetScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.MountSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.MountTargetSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleBoxEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleLineEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleRingEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleSphereEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleTornadoEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.PoseArmorStandMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.PotionSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.PrisonSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ProjectileMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.PullSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.PushButtonSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RallySkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RandomMessageSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RandomSkillSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RemountMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.RemoveSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RunAIGoalSelectorSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.RunAITargetSelectorSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SendActionMessageSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SendTitleSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetBlockTypeMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetGlidingMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetGlobalScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetHealthSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetLevelSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetMaxHealthSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetMobScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetOwnerMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetStanceMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetTargetScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootFireballSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootPotionSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootSkullSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SignalSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SkillSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SkyboxEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SmokeEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SmokeSwirlEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SoundEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SpinEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SpringSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SudoSkillMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SuicideSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.SummonSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.TagAddMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.TagRemoveMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.TeleportSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.TeleportToSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ThreatSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ThrowSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.ToggleLeverSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.TotemSkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.VelocitySkill;
import io.lumine.xikage.mythicmobs.skills.mechanics.VolleyMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.WeatherSkill;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class SkillManager {
    protected final MythicMobs core;
    private List<File> skillFiles;
    private IOLoader<MythicMobs> defaultSkills;
    private List<IOLoader<MythicMobs>> skillLoaders;
    private ConcurrentHashMap<String, Skill> skills = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();

    public SkillManager(MythicMobs core) {
        this.core = core;
    }

    public void loadSkills() {
        this.defaultSkills = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.thefile.getParent());
        this.skillLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), this.skillFiles, "Skills");
        this.skills.clear();
        for (IOLoader<MythicMobs> sl : this.skillLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfig mc = new MythicConfig(name, sl.getCustomConfig());
                Skill ms = new Skill(name, mc);
                this.skills.put(name, ms);
                if (sl.getCustomConfig().getStringList(name + ".LegacySkills") == null) continue;
                double cooldown = sl.getCustomConfig().getDouble(name + ".Cooldown");
                String file = sl.thefile.getName();
                List list = sl.getCustomConfig().getStringList(name + ".LegacySkills");
                List conditions = sl.getCustomConfig().getStringList(name + ".Conditions");
                MythicMobs.inst().listLegacySkills.add(new LegacyMythicSkill(name, file, list, cooldown, conditions));
            }
        }
        this.runSecondPass();
    }

    public void runSecondPass() {
        MythicMobs.debug(1, "Doing second pass on " + this.secondPass.size() + " skills.");
        this.secondPass.forEach(r -> r.run());
        this.secondPass.clear();
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public Optional<Skill> getSkill(String internalName) {
        if (internalName != null && this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    public SkillMechanic getSkillMechanic(String skill) {
        MythicMobs.debug(2, "Getting MythicSkill for string: " + skill);
        if (skill.contains("}")) {
            String ns;
            String sp2;
            String sp1;
            if (skill.contains("@")) {
                if (skill.substring(0, skill.indexOf("@")).contains("}")) {
                    sp1 = skill.substring(0, skill.indexOf("}"));
                    sp2 = skill.substring(skill.indexOf("}"));
                    skill = ns = sp1.replace(" ", "") + sp2;
                }
            } else {
                sp1 = skill.substring(0, skill.indexOf("}"));
                sp2 = skill.substring(skill.indexOf("}"));
                skill = ns = sp1.replace(" ", "") + sp2;
            }
            MythicMobs.debug(2, "-- Normalized skill string to: " + skill);
        }
        String[] s = skill.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s[0]);
        name = s[0].contains("{") ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        MythicMobs.debug(3, "-- Matching MythicSkill type to " + name.toUpperCase());
        try {
            switch (name.toUpperCase()) {
                case "SKILL": 
                case "META": {
                    return new SkillSkill(skill, mlc);
                }
                case "SUDOSKILL": 
                case "SUDO": {
                    return new SudoSkillMechanic(skill, mlc);
                }
                case "PROJECTILE": 
                case "P": {
                    return new ProjectileMechanic(skill, mlc);
                }
                case "TOTEM": 
                case "TOTEME": 
                case "T": {
                    return new TotemSkill(skill, mlc);
                }
                case "DELAY": {
                    return new DelaySkill(skill, mlc);
                }
                case "CANCELEVENT": {
                    return new CancelEventMechanic(skill, mlc);
                }
                case "ACTIVATESPAWNER": 
                case "AS": {
                    return new ActivateSpawnerSkill(skill, mlc);
                }
                case "ARROWVOLLEY": {
                    return new ArrowVolleySkill(skill, mlc);
                }
                case "BASEDAMAGE": 
                case "WEAPONDAMAGE": 
                case "BD": 
                case "WD": {
                    return new BaseDamageMechanic(skill, mlc);
                }
                case "COMMAND": 
                case "CMD": {
                    return new CommandSkill(skill, mlc);
                }
                case "CONSUME": {
                    return new ConsumeSkill(skill, mlc);
                }
                case "CONSUMEHELDITEM": 
                case "REMOVEHELDITEM": {
                    return new ConsumeHeldItemMechanic(skill, mlc);
                }
                case "CURRENCYGIVE": 
                case "GIVECURRENCY": {
                    return new CurrencyGiveMechanic(skill, mlc);
                }
                case "CURRENCYTAKE": 
                case "TAKECURRENCY": {
                    return new CurrencyTakeMechanic(skill, mlc);
                }
                case "DAMAGE": 
                case "D": {
                    return new DamageSkill(skill, mlc);
                }
                case "DAMAGEPERCENT": 
                case "PERCENTDAMAGE": {
                    return new DamagePercentMechanic(skill, mlc);
                }
                case "DECAPITATE": 
                case "DROPHEAD": {
                    return new DecapitateMechanic(skill, mlc);
                }
                case "DISGUISE": {
                    return new DisguiseSkill(skill, mlc);
                }
                case "DOPPLEGANGER": 
                case "COPYPLAYER": {
                    return new DopplegangerSkill(skill, mlc);
                }
                case "DISMOUNT": {
                    return new DismountSkill(skill, mlc);
                }
                case "EJECT_PASSENGER": 
                case "EJECTPASSENGER": {
                    return new EjectPassengerSkill(skill, mlc);
                }
                case "EQUIP": {
                    return new EquipSkill(skill, mlc);
                }
                case "EXPLOSION": 
                case "EXPLODE": {
                    return new ExplosionSkill(skill, mlc);
                }
                case "FORCEPULL": {
                    return new ForcePullSkill(skill, mlc);
                }
                case "GCD": 
                case "SETGCD": 
                case "GLOBALCOOLDOWN": 
                case "SETGLOBALCOOLDOWN": {
                    return new GCDSkill(skill, mlc);
                }
                case "HEAL": 
                case "H": {
                    return new HealSkill(skill, mlc);
                }
                case "HEALPERCENT": 
                case "HP": {
                    return new HealPercentMechanic(skill, mlc);
                }
                case "IGNITE": {
                    return new IgniteSkill(skill, mlc);
                }
                case "JUMP": {
                    return new JumpSkill(skill, mlc);
                }
                case "LEAP": {
                    return new LeapSkill(skill, mlc);
                }
                case "LIGHTNING": {
                    return new LightningSkill(skill, mlc);
                }
                case "LUNGE": {
                    return new LungeMechanic(skill, mlc);
                }
                case "MESSAGE": 
                case "MSG": 
                case "M": {
                    return new MessageSkill(skill, mlc);
                }
                case "MESSAGEJSON": 
                case "JSONMESSAGE": 
                case "JMSG": 
                case "JM": {
                    return new MessageJSONMechanic(skill, mlc);
                }
                case "MISSILE": 
                case "MI": {
                    return new MissileSkill(skill, mlc);
                }
                case "MODIFYGLOBALSCORE": 
                case "MGS": {
                    return new ModifyGlobalScoreMechanic(skill, mlc);
                }
                case "MODIFYMOBSCORE": 
                case "MMS": {
                    return new ModifyMobScoreMechanic(skill, mlc);
                }
                case "MODIFYPROJECTILE": {
                    return new ModifyProjectileMechanic(skill, mlc);
                }
                case "MODIFYTARGETSCORE": 
                case "MTS": {
                    return new ModifyTargetScoreMechanic(skill, mlc);
                }
                case "MOUNT": {
                    return new MountSkill(skill, mlc);
                }
                case "MOUNTTARGET": 
                case "MOUNTPLAYER": {
                    return new MountTargetSkill(skill, mlc);
                }
                case "REMOUNT": {
                    return new RemountMechanic(skill, mlc);
                }
                case "POSEARMORSTAND": 
                case "ARMORSTANDPOSE": {
                    return new PoseArmorStandMechanic(skill, mlc);
                }
                case "POTION": {
                    return new PotionSkill(skill, mlc);
                }
                case "PRISON": {
                    return new PrisonSkill(skill, mlc);
                }
                case "PULL": {
                    return new PullSkill(skill, mlc);
                }
                case "PUSHBUTTON": {
                    return new PushButtonSkill(skill, mlc);
                }
                case "RALLY": {
                    return new RallySkill(skill, mlc);
                }
                case "RANDOMMESSAGE": 
                case "RANDOMMSG": 
                case "RM": {
                    return new RandomMessageSkill(skill, mlc);
                }
                case "RANDOMSKILL": {
                    return new RandomSkillSkill(skill, mlc);
                }
                case "REMOVE": {
                    return new RemoveSkill(skill, mlc);
                }
                case "RUNAIGOALSELECTOR": {
                    return new RunAIGoalSelectorSkill(skill, mlc);
                }
                case "RUNAITARGETSELECTOR": {
                    return new RunAITargetSelectorSkill(skill, mlc);
                }
                case "SENDACTIONMESSAGE": 
                case "ACTIONMESSAGE": 
                case "AM": {
                    return new SendActionMessageSkill(skill, mlc);
                }
                case "SENDTITLE": 
                case "TITLE": {
                    return new SendTitleSkill(skill, mlc);
                }
                case "SETHEALTH": 
                case "SETHP": {
                    return new SetHealthSkill(skill, mlc);
                }
                case "SETMAXHEALTH": 
                case "SETMAXHP": {
                    return new SetMaxHealthSkill(skill, mlc);
                }
                case "SETLEVEL": 
                case "MODIFYLEVEL": {
                    return new SetLevelSkill(skill, mlc);
                }
                case "SCORE": 
                case "MODIFYSCORE": {
                    return new ModifyScoreMechanic(skill, mlc);
                }
                case "SETBLOCKTYPE": 
                case "SETBLOCK": {
                    return new SetBlockTypeMechanic(skill, mlc);
                }
                case "SETSCORE": {
                    return new SetScoreMechanic(skill, mlc);
                }
                case "SETGLIDING": {
                    return new SetGlidingMechanic(skill, mlc);
                }
                case "SETGLOBALSCORE": 
                case "SGS": {
                    return new SetGlobalScoreMechanic(skill, mlc);
                }
                case "SETMOBSCORE": 
                case "SMS": {
                    return new SetMobScoreMechanic(skill, mlc);
                }
                case "SETOWNER": {
                    return new SetOwnerMechanic(skill, mlc);
                }
                case "SETTARGETSCORE": 
                case "STS": {
                    return new SetTargetScoreMechanic(skill, mlc);
                }
                case "SETSTANCE": 
                case "STANCE": {
                    return new SetStanceMechanic(skill, mlc);
                }
                case "SHOOTFIREBALL": 
                case "FIREBALL": {
                    return new ShootFireballSkill(skill, mlc);
                }
                case "SHOOTPOTION": {
                    return new ShootPotionSkill(skill, mlc);
                }
                case "SHOOTPROJECTILE": 
                case "SHOOT": {
                    return new ShootMechanic(skill, mlc);
                }
                case "SHOOTSKULL": 
                case "SKULL": 
                case "WITHERSKULL": {
                    return new ShootSkullSkill(skill, mlc);
                }
                case "SIGNAL": 
                case "SENDSIGNAL": {
                    return new SignalSkill(skill, mlc);
                }
                case "SPRING": 
                case "WATER": {
                    return new SpringSkill(skill, mlc);
                }
                case "SUICIDE": {
                    return new SuicideSkill(skill, mlc);
                }
                case "SUMMON": 
                case "SPAWNMOBS": {
                    return new SummonSkill(skill, mlc);
                }
                case "TAGADD": 
                case "ADDTAG": 
                case "ADDSCOREBOARDTAG": {
                    return new TagAddMechanic(skill, mlc);
                }
                case "TAGREMOVE": 
                case "REMOVETAG": 
                case "REMOVESCOREBOARDTAG": {
                    return new TagRemoveMechanic(skill, mlc);
                }
                case "TELEPORT": 
                case "TP": {
                    return new TeleportSkill(skill, mlc);
                }
                case "TELEPORTTO": 
                case "TPT": 
                case "TELEPORTLOCATION": 
                case "TPL": {
                    return new TeleportToSkill(skill, mlc);
                }
                case "THREATCHANGE": 
                case "THREATMOD": 
                case "THREAT": {
                    return new ThreatSkill(skill, mlc);
                }
                case "THROW": {
                    return new ThrowSkill(skill, mlc);
                }
                case "TOGGLELEVER": 
                case "LEVER": {
                    return new ToggleLeverSkill(skill, mlc);
                }
                case "VELOCITY": {
                    return new VelocitySkill(skill, mlc);
                }
                case "VOLLEY": {
                    return new VolleyMechanic(skill, mlc);
                }
                case "WEATHER": {
                    return new WeatherSkill(skill, mlc);
                }
                case "EFFECT:BLOCKMASK": 
                case "E:BLOCKMASK": {
                    return new BlockMaskEffect(skill, mlc);
                }
                case "EFFECT:BLOCKUNMASK": 
                case "E:BLOCKUNMASK": {
                    return new BlockUnmaskEffect(skill, mlc);
                }
                case "EFFECT:ENDER": 
                case "ENDER": 
                case "E:ENDER": {
                    return new EnderEffect(skill, mlc);
                }
                case "EFFECT:ENDERBEAM": 
                case "ENDERBEAM": {
                    return new EnderBeamMechanic(skill, mlc);
                }
                case "EFFECT:EXPLOSION": 
                case "E:EXPLOSION": {
                    return new ExplosionEffect(skill, mlc);
                }
                case "EFFECT:FIREWORK": 
                case "E:FIREWORK": 
                case "FIREWORK": {
                    return new FireworkEffect(skill, mlc);
                }
                case "EFFECT:FLAMES": 
                case "E:FLAMES": {
                    return new FlamesEffect(skill, mlc);
                }
                case "EFFECT:GEYSER": 
                case "E:GEYSER": 
                case "GEYSER": {
                    return new GeyserEffect(skill, mlc);
                }
                case "EFFECT:GLOW": 
                case "E:GLOW": 
                case "GLOW": {
                    return new GlowEffect(skill, mlc);
                }
                case "EFFECT:LIGHTNING": 
                case "E:LIGHTNING": {
                    return new LightningEffect(skill, mlc);
                }
                case "EFFECT:ITEMSPRAY": 
                case "E:ITEMSPRAY": 
                case "ITEMSPRAY": {
                    return new ItemSprayEffect(skill, mlc);
                }
                case "EFFECT:PARTICLES": 
                case "PARTICLES": 
                case "E:PARTICLES": 
                case "E:P": {
                    return new ParticleEffect(skill, mlc);
                }
                case "EFFECT:PARTICLEBOX": 
                case "PARTICLEBOX": 
                case "E:PB": 
                case "PB": {
                    return new ParticleBoxEffect(skill, mlc);
                }
                case "EFFECT:PARTICLELINE": 
                case "PARTICLELINE": 
                case "E:PL": 
                case "PL": {
                    return new ParticleLineEffect(skill, mlc);
                }
                case "EFFECT:PARTICLERING": 
                case "PARTICLERING": 
                case "E:PR": 
                case "PR": {
                    return new ParticleRingEffect(skill, mlc);
                }
                case "EFFECT:PARTICLESPHERE": 
                case "PARTICLESPHERE": 
                case "E:PS": 
                case "PS": {
                    return new ParticleSphereEffect(skill, mlc);
                }
                case "EFFECT:PARTICLETORNADO": 
                case "PARTICLETORNADO": 
                case "E:PT": {
                    return new ParticleTornadoEffect(skill, mlc);
                }
                case "EFFECT:SKYBOX": 
                case "E:SKYBOX": {
                    return new SkyboxEffect(skill, mlc);
                }
                case "EFFECT:SMOKE": 
                case "E:SMOKE": {
                    return new SmokeEffect(skill, mlc);
                }
                case "EFFECT:SMOKESWIRL": 
                case "E:SMOKESWIRL": {
                    return new SmokeSwirlEffect(skill, mlc);
                }
                case "EFFECT:SOUND": 
                case "SOUND": 
                case "E:S": 
                case "S": {
                    return new SoundEffect(skill, mlc);
                }
                case "EFFECT:SPIN": 
                case "E:SPIN": 
                case "SPIN": {
                    return new SpinEffect(skill, mlc);
                }
                case "EFFECT:ATOM": 
                case "ATOM": 
                case "E:ATOM": {
                    return new AtomEffect(skill, mlc);
                }
                case "EFFECT:DNA": 
                case "DNA": 
                case "E:DNA": {
                    return new DNAEffect(skill, mlc);
                }
            }
            return new CustomMechanic(name.toUpperCase(), skill, mlc);
        }
        catch (Exception ex) {
            MythicMobs.error("Bad syntax! Failed to load skill line: " + skill);
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

