/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ConditionAction;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.AltitudeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.BiomeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.BlockTypeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.CrouchingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.CustomCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.DawnCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.DayCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.DistanceCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.DistanceFromSpawnCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.DuskCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.EntityTypeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.FallSpeedCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.GlidingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HasCurrencyCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HasInventorySpaceCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HasPermissionCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HasPotionEffectCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HasTagCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HeightAboveCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HeightBelowCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HeightCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.HoldingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.InBlockCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.InCombatCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.InsideCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.ItemRechargingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.LastSignalCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.LevelCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.LightLevelCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.LineOfSightCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.LunarPhaseCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.MobsInChunkCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.MobsInWorldCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.MountedCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.MythicMobTypeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.NightCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.NotInRegionCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.OffGCDCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.OnBlockCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.OnGroundCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.OutsideCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.OwnerCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.PlayerKillsCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.PlayerNotWithinCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.PlayerWithinCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.RainingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.RegionCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.ScoreCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.ScoreGlobalCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.StanceCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.SunnyCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.TCBiomeCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.TargetInLineOfSightCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.TargetNotInLineOfSightCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.TargetNotWithinCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.TargetWithinCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.ThunderingCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.WorldCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.all.WorldTimeCondition;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import java.util.HashSet;

public class SkillCondition {
    protected String conditionVar = "0";
    protected ConditionAction ACTION = ConditionAction.REQUIRED;
    protected String actionVar = null;

    public SkillCondition(String line) {
        String[] split = line.split(" ");
        if (split.length < 2) {
            return;
        }
        if (ConditionAction.isAction(split[1])) {
            this.ACTION = ConditionAction.valueOf(split[1].toUpperCase());
            if (split.length > 2) {
                this.actionVar = split[2];
            }
        } else {
            this.conditionVar = split[1];
            if (split.length > 2 && ConditionAction.isAction(split[2])) {
                this.ACTION = ConditionAction.valueOf(split[2].toUpperCase());
                if (split.length > 3) {
                    this.actionVar = split[3];
                }
            }
        }
    }

    public boolean evaluateCaster(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(meta.getCaster().getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(meta.getCaster().getLocation()));
        }
        return false;
    }

    public boolean evaluateTrigger(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getTrigger() == null) {
            return false;
        }
        if (this instanceof IEntityCondition) {
            return condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check(meta.getTrigger()));
        }
        if (this instanceof IEntityComparisonCondition) {
            return condition.handleOutcome(meta, ((IEntityComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), meta.getTrigger()));
        }
        if (this instanceof ILocationCondition) {
            return condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(meta.getTrigger().getLocation()));
        }
        if (this instanceof ILocationComparisonCondition) {
            return condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), meta.getTrigger().getLocation()));
        }
        return false;
    }

    public boolean evaluateTargets(SkillMetadata meta) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
            HashSet targets = (HashSet)meta.getEntityTargets().clone();
            targets.removeIf(target -> {
                if (condition instanceof IEntityCondition) {
                    return !condition.handleOutcome(meta, ((IEntityCondition)((Object)condition)).check((AbstractEntity)target));
                }
                if (condition instanceof IEntityComparisonCondition) {
                    return !condition.handleOutcome(meta, ((IEntityComparisonCondition)((Object)condition)).check(meta.getCaster().getEntity(), (AbstractEntity)target));
                }
                if (condition instanceof ILocationCondition) {
                    return !condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check(target.getLocation()));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), target.getLocation()));
                }
                return false;
            });
            meta.setEntityTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
            HashSet targets = (HashSet)meta.getLocationTargets().clone();
            targets.removeIf(target -> {
                if (condition instanceof ILocationCondition) {
                    return !condition.handleOutcome(meta, ((ILocationCondition)((Object)condition)).check((AbstractLocation)target));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !condition.handleOutcome(meta, ((ILocationComparisonCondition)((Object)condition)).check(meta.getCaster().getLocation(), (AbstractLocation)target));
                }
                return false;
            });
            meta.setLocationTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
        SkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return condition.handleOutcome(rsp, ((IEntityCondition)((Object)condition)).check(rsp.getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return condition.handleOutcome(rsp, ((ILocationCondition)((Object)condition)).check(rsp.getLocation()));
        }
        return false;
    }

    public boolean handleOutcome(SkillMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CAST: {
                break;
            }
            case CASTINSTEAD: {
                break;
            }
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case POWER: {
                try {
                    float powerMod = Float.valueOf(this.actionVar).floatValue();
                    meta.setPower(meta.getPower() * powerMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public boolean handleOutcome(RandomSpawnPoint rsp, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case LEVEL: {
                try {
                    float levelMod = Float.valueOf(this.actionVar).floatValue();
                    rsp.setLevelMod(levelMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public void setAction(ConditionAction action) {
        this.ACTION = action;
    }

    public static SkillCondition getCondition(String condition) {
        if (condition.contains("}")) {
            String ns;
            String sp1 = condition.substring(0, condition.indexOf("}"));
            String sp2 = condition.substring(condition.indexOf("}"));
            condition = ns = sp1.replace(" ", "") + sp2;
            MythicMobs.debug(4, "------ Normalized Condition string to: " + condition);
        }
        String[] s = condition.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s[0]);
        name = s[0].contains("{") ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        MythicMobs.debug(3, "------ Matching MythicCondition type to " + name);
        switch (name.toUpperCase()) {
            case "ALTITUDE": 
            case "HEIGHTFROMSURFACE": {
                return new AltitudeCondition(condition, mlc);
            }
            case "BIOME": {
                return new BiomeCondition(condition, mlc);
            }
            case "BLOCKTYPE": {
                return new BlockTypeCondition(condition, mlc);
            }
            case "CROUCHING": 
            case "SNEAKING": {
                return new CrouchingCondition(condition, mlc);
            }
            case "DAWN": {
                return new DawnCondition(condition);
            }
            case "DAY": {
                return new DayCondition(condition);
            }
            case "DISTANCE": {
                return new DistanceCondition(condition, mlc);
            }
            case "DISTANCEFROMSPAWN": {
                return new DistanceFromSpawnCondition(condition, mlc);
            }
            case "DUSK": {
                return new DuskCondition(condition);
            }
            case "ENTITYTYPE": 
            case "MOBTYPE": {
                return new EntityTypeCondition(condition, mlc);
            }
            case "FALLSPEED": 
            case "FALLINGSPEED": {
                return new FallSpeedCondition(condition, mlc);
            }
            case "GLIDING": 
            case "ISGLIDING": {
                return new GlidingCondition(condition, mlc);
            }
            case "HASCURRENCY": {
                return new HasCurrencyCondition(condition, mlc);
            }
            case "HASINVENTORYSPACE": {
                return new HasInventorySpaceCondition(condition, mlc);
            }
            case "HASPERMISSION": {
                return new HasPermissionCondition(condition, mlc);
            }
            case "HASPOTIONEFFECT": {
                return new HasPotionEffectCondition(condition, mlc);
            }
            case "HASTAG": 
            case "HASSCOREBOARDTAG": {
                return new HasTagCondition(condition, mlc);
            }
            case "HEIGHT": {
                return new HeightCondition(condition);
            }
            case "HEIGHTABOVE": {
                return new HeightAboveCondition(condition);
            }
            case "HEIGHTBELOW": {
                return new HeightBelowCondition(condition);
            }
            case "HOLDING": {
                return new HoldingCondition(condition, mlc);
            }
            case "INBLOCK": 
            case "INSIDEBLOCK": {
                return new InBlockCondition(condition);
            }
            case "INCOMBAT": {
                return new InCombatCondition(condition);
            }
            case "INSIDE": {
                return new InsideCondition(condition);
            }
            case "ITEMRECHARGING": {
                return new ItemRechargingCondition(condition, mlc);
            }
            case "LASTSIGNAL": {
                return new LastSignalCondition(condition, mlc);
            }
            case "LEVEL": {
                return new LevelCondition(condition);
            }
            case "LIGHTLEVEL": {
                return new LightLevelCondition(condition, mlc);
            }
            case "LINEOFSIGHT": 
            case "INLINEOFSIGHT": {
                return new LineOfSightCondition(condition, mlc);
            }
            case "LUNARPHASE": {
                return new LunarPhaseCondition(condition, mlc);
            }
            case "MOBSINCHUNK": {
                return new MobsInChunkCondition(condition, mlc);
            }
            case "MOBSINWORLD": {
                return new MobsInWorldCondition(condition, mlc);
            }
            case "MYTHICMOBTYPE": {
                return new MythicMobTypeCondition(condition, mlc);
            }
            case "MOUNTED": {
                return new MountedCondition(condition, mlc);
            }
            case "NIGHT": {
                return new NightCondition(condition);
            }
            case "NOTINREGION": {
                return new NotInRegionCondition(condition, mlc);
            }
            case "OFFGCD": {
                return new OffGCDCondition(condition, mlc);
            }
            case "ONBLOCK": {
                return new OnBlockCondition(condition);
            }
            case "ONGROUND": 
            case "GROUNDED": {
                return new OnGroundCondition(condition, mlc);
            }
            case "OUTSIDE": {
                return new OutsideCondition(condition);
            }
            case "OWNER": {
                return new OwnerCondition(condition, mlc);
            }
            case "PLAYERKILLS": {
                return new PlayerKillsCondition(condition, mlc);
            }
            case "PLAYERWITHIN": {
                return new PlayerWithinCondition(condition, mlc);
            }
            case "PLAYERNOTWITHIN": {
                return new PlayerNotWithinCondition(condition, mlc);
            }
            case "RAINING": 
            case "ISRAINING": {
                return new RainingCondition(condition);
            }
            case "REGION": 
            case "INREGION": {
                return new RegionCondition(condition, mlc);
            }
            case "SCORE": {
                return new ScoreCondition(condition, mlc);
            }
            case "SCOREGLOBAL": 
            case "GLOBALSCORE": {
                return new ScoreGlobalCondition(condition, mlc);
            }
            case "STANCE": {
                return new StanceCondition(condition, mlc);
            }
            case "SUNNY": 
            case "ISSUNNY": {
                return new SunnyCondition(condition);
            }
            case "TARGETINLINEOFSIGHT": {
                return new TargetInLineOfSightCondition(condition, mlc);
            }
            case "TARGETNOTINLINEOFSIGHT": {
                return new TargetNotInLineOfSightCondition(condition, mlc);
            }
            case "TARGETWITHIN": {
                return new TargetWithinCondition(condition, mlc);
            }
            case "TARGETNOTWITHIN": {
                return new TargetNotWithinCondition(condition, mlc);
            }
            case "TCBIOME": 
            case "TERRAINCONTROLBIOME": {
                return new TCBiomeCondition(condition, mlc);
            }
            case "THUNDERING": 
            case "ISTHUNDERING": {
                return new ThunderingCondition(condition);
            }
            case "WORLD": {
                return new WorldCondition(condition, mlc);
            }
            case "WORLDTIME": {
                return new WorldTimeCondition(condition, mlc);
            }
        }
        return new CustomCondition(name, condition, mlc);
    }
}

