/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class MythicZombieVillager
extends MythicEntity {
    private static final int height = 2;
    private double reinforcementChance = -1.0;
    private Villager.Profession villagerProfession;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        String prof = mc.getString("Options.Profession", "FARMER");
        try {
            this.villagerProfession = Villager.Profession.valueOf((String)prof.toUpperCase());
        }
        catch (Exception ex) {
            this.villagerProfession = Villager.Profession.FARMER;
        }
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)location.getWorld().spawnEntity(location, EntityType.ZOMBIE_VILLAGER);
            e.setBaby(false);
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(this.villagerProfession);
            } else {
                e.setVillager(true);
            }
            e = (ZombieVillager)this.applyOptions((Entity)e);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            e.setVillagerProfession(this.villagerProfession);
        } else {
            e.setVillager(true);
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)location.getWorld().spawnEntity(location, EntityType.ZOMBIE_VILLAGER);
            e.setBaby(false);
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(this.villagerProfession);
            } else {
                e.setVillager(true);
            }
            e = (ZombieVillager)this.applyOptions((Entity)e);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            e.setVillagerProfession(this.villagerProfession);
        } else {
            e.setVillager(true);
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)entity;
            if (this.reinforcementChance >= 0.0) {
                if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                    e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
                } else {
                    MythicMobs.inst().getVolatileCodeHandler().setZombieSpawnReinforcements((Zombie)e, this.reinforcementChance);
                }
            }
            return e;
        }
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
            } else {
                MythicMobs.inst().getVolatileCodeHandler().setZombieSpawnReinforcements(e, this.reinforcementChance);
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return MythicZombieVillager.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            if (e instanceof ZombieVillager && !((ZombieVillager)e).isBaby()) {
                return true;
            }
        } else if (e instanceof Zombie) {
            return !((Zombie)e).isBaby() && ((Zombie)e).isVillager();
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

