/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class MythicRabbit
extends MythicEntity {
    private static final int height = 1;
    private int age = 0;
    private boolean ageLock = false;
    private boolean isAngry = false;
    private boolean isBaby = false;
    private Rabbit.Type type;

    @Override
    public void instantiate(MythicConfig mc) {
        this.age = mc.getInt("Options.Age", 0);
        this.ageLock = mc.getBoolean("Options.AgeLock", false);
        this.isAngry = mc.getBoolean("Options.Angry", false);
        this.isBaby = mc.getBoolean("Options.Baby", false);
        String t = mc.getString("Options.RabbitType", null);
        if (t != null) {
            this.type = Rabbit.Type.valueOf((String)t.toUpperCase());
        }
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Rabbit e = (Rabbit)location.getWorld().spawnEntity(location, EntityType.RABBIT);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Rabbit e = (Rabbit)location.getWorld().spawnEntity(location, EntityType.RABBIT);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Rabbit e = (Rabbit)entity;
        e.setAge(this.age);
        e.setAgeLock(this.ageLock);
        if (this.isBaby) {
            e.setBaby();
        }
        if (this.type != null) {
            e.setRabbitType(this.type);
        }
        if (this.isAngry) {
            e.setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Rabbit;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

