/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicWolf;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class ActiveMob
implements SkillCaster {
    private long aliveTime = 0L;
    private UUID uuid;
    private AbstractEntity entity;
    private AbstractLocation spawnLocation;
    private MythicMob type;
    private int level;
    private int gcd = 0;
    private Optional<String> faction = Optional.empty();
    private String stance;
    private String lastSignal = "";
    private int playerkills = 0;
    private transient Optional<AbstractBossBar> bossBar = Optional.empty();
    private transient int noDamageTicks;
    private transient AbstractEntity newTarget = null;
    private transient double lastDamageSkillAmount = 0.0;
    private transient boolean damageSkillRunning = false;
    private transient boolean dead = false;
    public transient HashMap<String, Long> cooldowns = new HashMap();
    private transient Optional<UUID> owner = Optional.empty();
    private transient ActiveMob parent;
    private transient ThreatTable threatTable;
    private transient ImmunityTable immunityTable;
    private transient Optional<ActiveMob> mount = Optional.empty();
    protected transient AbstractEntity lastAggroCause;
    protected transient MythicSpawner spawner = null;

    public ActiveMob(UUID uuid, AbstractEntity e, MythicMob type, int level) {
        this.uuid = uuid;
        this.entity = e;
        this.type = type;
        this.spawnLocation = e.getLocation();
        this.level = level;
        this.setScoreboardLevel(level);
        this.gcd = 0;
        this.stance = "default";
        this.noDamageTicks = type.getNoDamageTicks();
        if (type.usesBossBar()) {
            this.bossBar = type.getBossBar();
        }
        if (!this.getType().getDespawns()) {
            this.remountSpawner();
        }
        this.threatTable = ConfigManager.EnableThreatTables && type.usesThreatTable() ? new ThreatTable() : null;
        this.immunityTable = type.usesImmunityTable() ? new ImmunityTable() : null;
    }

    @Override
    public AbstractEntity getEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity.isLiving()) {
            return (LivingEntity)this.entity.getBukkitEntity();
        }
        return null;
    }

    public void setEntity(AbstractEntity e) {
        this.entity = e;
    }

    @Override
    public AbstractLocation getLocation() {
        return this.entity.getLocation();
    }

    public MythicMob getType() {
        return this.type;
    }

    public AbstractLocation getSpawnLocation() {
        return this.spawnLocation;
    }

    public void setParent(ActiveMob am) {
        this.parent = am;
    }

    public ActiveMob getParent() {
        return this.parent;
    }

    public void setOwner(UUID uuid) {
        this.owner = Optional.of(uuid);
        if (this.getType().getMythicEntity() instanceof MythicWolf) {
            Wolf wolf = (Wolf)this.getEntity().getBukkitEntity();
            wolf.setOwner((AnimalTamer)Bukkit.getPlayer((UUID)uuid));
        }
    }

    public Optional<UUID> getOwner() {
        return this.owner;
    }

    public void removeOwner() {
        this.owner = Optional.empty();
    }

    public void setMount(ActiveMob am) {
        this.mount = Optional.of(am);
    }

    public Optional<ActiveMob> getMount() {
        return this.mount;
    }

    public void remountType() {
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(this.type.getInternalName());
        if (mm != null) {
            this.type = mm;
        }
    }

    public double getDamage() {
        double damage = this.getType().getBaseDamage();
        if (this.level > 1 && this.getType().getPerLevelDamage() > 0.0) {
            damage += this.getType().getPerLevelDamage() * (double)(this.level - 1);
        }
        return damage;
    }

    public double getArmor() {
        double armor = this.getType().getBaseArmor();
        if (this.level > 1 && this.getType().getPerLevelArmor() > 0.0) {
            armor += this.getType().getPerLevelArmor() * (double)(this.level - 1);
        }
        return armor;
    }

    public void setLevel(int level) {
        this.setScoreboardLevel(level);
        this.level = level;
        this.getType().applyMobOptions(this, level);
    }

    private void setScoreboardLevel(int level) {
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobLevel");
        if (o == null) {
            o = sb.registerNewObjective("MythicMobLevel", "dummy");
        }
        o.getScore(this.getUniqueId().toString()).setScore(level);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public float getPower() {
        return (float)(1.0 + (double)(this.getLevel() - 1) * this.getType().getPerLevelPower());
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public int getGlobalCooldown() {
        return this.gcd;
    }

    public void setGlobalCooldown(int gcd) {
        this.gcd = gcd;
    }

    public void tickGlobalCooldown(int c) {
        ++this.aliveTime;
        if (this.gcd > 0) {
            this.gcd -= c;
        }
        this.updateBossBar();
    }

    public String getStance() {
        return this.stance;
    }

    public void setStance(String stance) {
        this.stance = stance;
    }

    public boolean hasFaction() {
        if (this.faction.isPresent()) {
            return true;
        }
        return this.type.hasFaction();
    }

    public String getFaction() {
        if (this.faction.isPresent()) {
            return this.faction.get();
        }
        return this.type.getFaction();
    }

    public ActiveMob setFaction(String faction) {
        this.faction = Optional.ofNullable(faction);
        if (faction != null) {
            this.getLivingEntity().setMetadata("Faction", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)this.getFaction()));
        }
        return this;
    }

    public int getPlayerKills() {
        return this.playerkills;
    }

    public void incrementPlayerKills() {
        ++this.playerkills;
    }

    public void importPlayerKills(int pk) {
        this.playerkills = pk;
    }

    public void setLastAggroCause(AbstractEntity aggro) {
        this.lastAggroCause = aggro;
    }

    public AbstractEntity getLastAggroCause() {
        return this.lastAggroCause;
    }

    public boolean hasTarget() {
        if (this.hasThreatTable()) {
            return this.threatTable.getTopThreatHolder() == null;
        }
        if (this.entity.isCreature()) {
            return this.entity.getTarget() != null;
        }
        return false;
    }

    public void setTarget(AbstractEntity l) {
        this.newTarget = l;
        if (this.entity.isLiving()) {
            MythicMobs.inst().getVolatileCodeHandler().setTarget((LivingEntity)BukkitAdapter.adapt(this.entity), (LivingEntity)BukkitAdapter.adapt(l));
        }
    }

    public boolean changingTarget() {
        return !(this.newTarget == null);
    }

    public AbstractEntity getNewTarget() {
        return this.newTarget;
    }

    public void voidTargetChange() {
        this.newTarget = null;
    }

    public void resetTarget() {
        if (this.hasThreatTable()) {
            this.threatTable.dropCombat();
        } else {
            MythicMobs.inst().getVolatileCodeHandler().setTarget((LivingEntity)BukkitAdapter.adapt(this.entity), null);
        }
    }

    public boolean hasThreatTable() {
        return this.threatTable != null;
    }

    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public void importThreatTable(ThreatTable tt) {
        this.threatTable = tt;
    }

    public boolean hasImmunityTable() {
        return this.immunityTable != null;
    }

    public ImmunityTable getImmunityTable() {
        return this.immunityTable;
    }

    public void setDespawned() {
        this.dead = true;
        if (this.getSpawner() != null) {
            this.getSpawner().markMobDespawned(this);
        }
        this.unregister();
    }

    public void setDead() {
        this.dead = true;
        if (this.getSpawner() != null) {
            this.getSpawner().markMobDead(this);
        }
        this.unregister();
    }

    public boolean isDead() {
        return this.dead;
    }

    public void unregister() {
        MythicMobs.inst().getMobManager().getVoidList().add(this.entity.getUniqueId());
        if (this.bossBar.isPresent()) {
            this.bossBar.get().removeAll();
            this.bossBar = Optional.empty();
        }
        try {
            TaskManager.get().runLater(() -> Bukkit.getScoreboardManager().getMainScoreboard().resetScores(this.getUniqueId().toString()), 100);
        }
        catch (IllegalPluginAccessException ex) {
            Bukkit.getScoreboardManager().getMainScoreboard().resetScores(this.getUniqueId().toString());
        }
    }

    @Override
    public void setUsingDamageSkill(boolean b) {
        this.damageSkillRunning = b;
    }

    @Override
    public boolean isUsingDamageSkill() {
        return this.damageSkillRunning;
    }

    public void setLastDamageSkillAmount(double d) {
        this.lastDamageSkillAmount = d;
    }

    public double getLastDamageSkillAmount() {
        return this.lastDamageSkillAmount;
    }

    public void setSpawner(MythicSpawner ms) {
        this.spawner = ms;
        if (this.getType().isPersistent()) {
            Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
            Objective o = sb.getObjective("MythicMobSpawner");
            if (o == null) {
                o = sb.registerNewObjective("MythicMobSpawner", "dummy");
            }
            o.getScore(this.getUniqueId().toString()).setScore(ms.hashCode());
        }
    }

    public MythicSpawner getSpawner() {
        return this.spawner;
    }

    public void remountSpawner() {
        Optional<MythicSpawner> maybeSpawner;
        int score;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobSpawner");
        if (o == null) {
            o = sb.registerNewObjective("MythicMobSpawner", "dummy");
        }
        if ((score = o.getScore(this.getUniqueId().toString()).getScore()) != 0 && (maybeSpawner = MythicMobs.inst().getSpawnerManager().getSpawnerByHashcode(score)).isPresent()) {
            this.spawner = maybeSpawner.get();
            this.spawner.trackMob(this);
        }
    }

    public void signalMob(AbstractEntity trigger, String signal) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.SIGNAL, this, trigger);
        if (trigger != null) {
            HashSet<AbstractEntity> eTargets = new HashSet<AbstractEntity>();
            eTargets.add(data.getTrigger());
            data.setEntityTargets(eTargets);
        }
        data.setPower(this.getPower());
        this.lastSignal = signal;
        this.getType().executeSignalSkill(signal, data);
    }

    public String getLastSignal() {
        return this.lastSignal;
    }

    public void updateBossBar() {
        if (!this.bossBar.isPresent()) {
            return;
        }
        AbstractBossBar bar = this.bossBar.get();
        Set<AbstractPlayer> inRange = MythicMobs.inst().getEntityManager().getPlayersInRangeSq(this.getLocation(), this.getType().getBossBarRangeSquared());
        List<AbstractPlayer> current = this.bossBar.get().getPlayers();
        double progress = this.getEntity().getHealth() / this.getEntity().getMaxHealth();
        String title = SkillString.parseMobVariables(this.type.getBossBarTitle(), this, null, null);
        bar.setTitle(title);
        bar.setProgress(progress);
        current.stream().forEach(player -> {
            if (!inRange.contains(player)) {
                bar.removePlayer((AbstractPlayer)player);
            }
        });
        inRange.stream().forEach(player -> {
            if (!current.contains(player)) {
                bar.addPlayer((AbstractPlayer)player);
            }
        });
    }

    public int hashCode() {
        return this.getUniqueId().toString().hashCode();
    }

    public class ThreatTable
    implements Cloneable {
        private WeakReference<ActiveMob> mob;
        private double totalThreat = 0.0;
        private double targetThreat = 0.0;
        private int targetOutOfRangeTicks = 0;
        private AbstractEntity target = null;
        private ConcurrentHashMap<AbstractEntity, Double> threatTable = new ConcurrentHashMap();

        public void setParent(ActiveMob am) {
            this.mob = new WeakReference<ActiveMob>(am);
        }

        public void tickThreat() {
            if (this.target == null) {
                this.clearTarget();
                this.targetHighestThreat();
                return;
            }
            if (this.target.isDead()) {
                this.targetDeath();
                return;
            }
            if (this.threatTable.size() == 0) {
                this.dropCombat();
                return;
            }
            if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && !this.target.hasLineOfSight(ActiveMob.this.getEntity())) {
                this.decayTargetThreat();
            }
            if (this.target.isPlayer() && !this.target.asPlayer().isOnline()) {
                this.clearTarget();
                this.targetHighestThreat();
            }
            if (!this.target.getLocation().getWorld().equals(ActiveMob.this.getEntity().getLocation().getWorld()) || this.target.isPlayer() && (this.target.asPlayer().isInCreativeMode() || this.target.asPlayer().isInSpectatorMode())) {
                this.clearTarget();
                this.targetHighestThreat();
                this.targetOutOfRangeTicks = 0;
            } else if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && this.target.getLocation().distance(ActiveMob.this.getEntity().getLocation()) > (double)ActiveMob.this.getType().maxThreatDistance) {
                ++this.targetOutOfRangeTicks;
                if (this.targetOutOfRangeTicks >= 10) {
                    this.clearTarget();
                    this.targetHighestThreat();
                    this.targetOutOfRangeTicks = 0;
                }
            } else {
                this.targetOutOfRangeTicks = 0;
            }
        }

        public boolean inCombat() {
            return this.threatTable.size() > 0;
        }

        public boolean targetEvent(AbstractEntity l) {
            if (l == null) {
                return false;
            }
            MythicMobs.debug(3, "Called TargetChangeEvent. Evaluating...");
            if (this.target == null) {
                MythicMobs.debug(3, "== No previous target. Assigning new target.");
                this.target = l;
                ActiveMob.this.setTarget(l);
                this.targetThreat = this.threatTable.containsKey(l) ? this.threatTable.get(l) : 1.0;
                if (!this.inCombat()) {
                    MythicMobs.inst().getMobManager().setInCombat(ActiveMob.this, true);
                    new TriggeredSkill(SkillTrigger.ENTERCOMBAT, ActiveMob.this, l);
                }
                return true;
            }
            if (this.target.equals(l)) {
                MythicMobs.debug(3, "== Target change was to primary target anyway!");
                return true;
            }
            if (this.target.isDead()) {
                this.targetDeath();
                return this.target != null && this.target.equals(l);
            }
            MythicMobs.debug(3, "== Target was changing to not-top-threat. Ignoring!");
            return false;
        }

        public boolean Taunt(AbstractEntity l) {
            if (l.equals(this.target)) {
                return false;
            }
            this.threatTable.put(l, this.targetThreat * 1.1);
            this.targetThreateningEntity(l);
            return true;
        }

        public void dropCombat() {
            MythicMobs.debug(3, "Dropping combat!");
            this.target = null;
            this.targetThreat = 0.0;
            this.totalThreat = 0.0;
            this.threatTable.clear();
            MythicMobs.inst().getMobManager().setInCombat(ActiveMob.this, false);
            MythicMobs.inst().getVolatileCodeHandler().setTarget((LivingEntity)ActiveMob.this.entity.getBukkitEntity(), null);
            new TriggeredSkill(SkillTrigger.DROPCOMBAT, ActiveMob.this, null);
        }

        public void observeDeath(AbstractEntity l) {
            MythicMobs.debug(3, "Entity died. Evaluating threat table.");
            if (this.target == null) {
                return;
            }
            if (this.target.equals(l)) {
                this.targetDeath();
            }
            this.threatTable.remove(l);
        }

        public boolean targetThreateningEntity(AbstractEntity l) {
            MythicMobs.debug(3, "Targeting someone else on my threat table...");
            this.target = l;
            this.targetThreat = this.threatTable.get(l);
            ActiveMob.this.setTarget(this.target);
            return true;
        }

        public void targetHighestThreat() {
            MythicMobs.debug(3, "Finding highest threat target available!");
            if (this.threatTable.size() == 0) {
                this.dropCombat();
                return;
            }
            Iterator<Map.Entry<AbstractEntity, Double>> it = this.threatTable.entrySet().iterator();
            this.targetThreat = 0.0;
            while (it.hasNext()) {
                Map.Entry<AbstractEntity, Double> pairs = it.next();
                if (!(pairs.getValue() > this.targetThreat)) continue;
                this.targetThreat = pairs.getValue();
                this.target = pairs.getKey();
            }
            ActiveMob.this.setTarget(this.target);
        }

        public void clearTarget() {
            MythicMobs.debug(3, "Clearing threat target");
            if (this.target != null) {
                this.threatTable.remove(this.target);
            }
            if (this.threatTable.size() == 0) {
                this.dropCombat();
                return;
            }
        }

        public void targetDeath() {
            MythicMobs.debug(3, "Target may have died!");
            if (!this.target.isDead()) {
                return;
            }
            this.clearTarget();
            this.targetHighestThreat();
        }

        public void threatGain(AbstractEntity l, double amount) {
            if (l == null) {
                return;
            }
            MythicMobs.debug(3, "An attacker attacked for " + amount + " threat!");
            if (l.getUniqueId().equals(ActiveMob.this.getUniqueId())) {
                return;
            }
            if (ActiveMob.this.owner.isPresent() && ((UUID)ActiveMob.this.owner.get()).equals(l.getUniqueId())) {
                return;
            }
            if (l.isPlayer() && (l.asPlayer().isInCreativeMode() || l.asPlayer().isInSpectatorMode())) {
                return;
            }
            if (this.target == null) {
                MythicMobs.debug(3, "== Entity previously had no target, assigning target...");
                this.targetEvent(l);
                this.targetThreat = amount;
            } else if (this.target.equals(l)) {
                MythicMobs.debug(3, "== Entity was current target!");
                this.targetThreat += amount;
                amount = this.targetThreat;
            } else {
                MythicMobs.debug(3, "== Entity was different hostile!");
                if (this.threatTable.containsKey(l)) {
                    amount += this.threatTable.get(l).doubleValue();
                }
            }
            MythicMobs.debug(3, "==== Attacker threat set to " + amount + " threat!");
            this.threatTable.put(l, amount);
            if (amount > this.targetThreat * 1.1) {
                this.targetThreateningEntity(l);
            }
            this.totalThreat += amount;
        }

        public void threatLoss(AbstractEntity l, double amount) {
            double nT;
            MythicMobs.debug(3, "A target lost " + amount + " threat!");
            if (this.threatTable.containsKey(l)) {
                nT = this.threatTable.get(l) - amount;
                if (nT < 0.0) {
                    amount -= 0.0 - nT;
                    nT = 0.0;
                }
            } else {
                return;
            }
            MythicMobs.debug(3, "==== Attacker threat set to " + amount + " threat!");
            this.threatTable.put(l, nT);
            this.totalThreat -= amount;
            if (this.target.equals(l)) {
                this.targetHighestThreat();
            }
        }

        public void decayTargetThreat() {
            double dt = this.targetThreat * 0.96;
            this.totalThreat -= this.targetThreat - dt;
            this.targetThreat = dt;
            this.threatTable.put(this.target, dt);
        }

        public AbstractEntity getTopThreatHolder() {
            return this.target;
        }

        public double getTopTargetThreat() {
            return this.targetThreat;
        }

        public double getThreat(AbstractEntity l) {
            if (this.threatTable.containsKey(l)) {
                return this.threatTable.get(l);
            }
            return 0.0;
        }

        public double getTotalThreat() {
            return this.totalThreat;
        }

        public Set<AbstractEntity> getAllThreatTargets() {
            return this.threatTable.keySet();
        }

        public int size() {
            return this.threatTable.size();
        }

        public ThreatTable clone() throws CloneNotSupportedException {
            return (ThreatTable)super.clone();
        }
    }

    public class ImmunityTable {
        private long otherSource;
        private ConcurrentHashMap<AbstractEntity, Long> immunityTable = new ConcurrentHashMap();

        public void setCooldown(AbstractEntity e) {
            if (e == null) {
                this.otherSource = ActiveMob.this.aliveTime;
            } else {
                this.immunityTable.put(e, ActiveMob.this.aliveTime);
            }
        }

        public boolean onCooldown(AbstractEntity e) {
            if (e == null) {
                return ActiveMob.this.aliveTime - this.otherSource <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            if (this.immunityTable.containsKey(e)) {
                long last = this.immunityTable.get(e);
                return ActiveMob.this.aliveTime - last <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            return false;
        }
    }
}

