/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.drops.MythicDropTable;
import io.lumine.xikage.mythicmobs.drops.MythicEquipable;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.mobs.EquipmentManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;

public class SkillEquip {
    public static void ExecuteSkill(LivingEntity l, String skill) {
        Optional<MythicDropTable> maybeDT;
        String[] split;
        String[] base = skill.split(" ");
        String s = base[1];
        MythicEquipable helmet = null;
        MythicEquipable chest = null;
        MythicEquipable leggings = null;
        MythicEquipable boots = null;
        MythicEquipable hand = null;
        EntityEquipment ee = l.getEquipment();
        ee.setItemInHandDropChance(0.0f);
        ee.setHelmetDropChance(0.0f);
        ee.setChestplateDropChance(0.0f);
        ee.setLeggingsDropChance(0.0f);
        ee.setBootsDropChance(0.0f);
        MythicMobs.debug(3, "Executing Equip AbstractSkill");
        MythicMobs.debug(3, "-- Parsing equipment: " + s);
        String prefix = "";
        MythicDropTable dt = null;
        if (s.contains(":")) {
            split = s.split(":");
            maybeDT = MythicMobs.inst().getDropManager().getDropTable(split[0]);
            prefix = split[1];
        } else {
            maybeDT = MythicMobs.inst().getDropManager().getDropTable(s);
        }
        if (maybeDT.isPresent()) {
            dt = maybeDT.get();
            MythicMobs.debug(3, "---- Retrieved Drop Table: " + dt.dtName);
            MythicMobs.debug(4, "---- Drop Table contains: " + dt.equipablesList.toString());
        } else {
            MythicMobs.debug(3, "---- No Drop Table found named " + s + ". Searching for item...");
            split = s.split(":");
            Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(split[0]);
            if (maybeItem.isPresent()) {
                try {
                    List<String> baseEquipmentList = Arrays.asList(s);
                    dt = new MythicDropTable(baseEquipmentList, null, null, null, null);
                }
                catch (Exception e) {
                    MythicMobs.error("Equip AbstractSkill appears to have invalid equipment configured for it. Please check the formatting! Equipment: " + s);
                }
            }
        }
        if (dt != null) {
            dt.parseTable(MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l));
            for (MythicEquipable is : dt.equipablesList) {
                MythicMobs.debug(4, "------ Loaded item in slot " + is.getSlot() + " with Item Stack: " + is.getItemStack().toString());
                if (is.getSlot() == 5 || !(MythicMobs.r.nextFloat() <= is.getChance())) continue;
                if (is.getSlot() == 0 && EquipmentManager.CompareEquipment(is, hand)) {
                    hand = is;
                    if (prefix.equals("!")) {
                        ee.setItemInHandDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 1 && EquipmentManager.CompareEquipment(is, boots)) {
                    boots = is;
                    if (prefix.equals("!")) {
                        ee.setBootsDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 2 && EquipmentManager.CompareEquipment(is, leggings)) {
                    leggings = is;
                    if (prefix.equals("!")) {
                        ee.setLeggingsDropChance(1.0f);
                    }
                }
                if (is.getSlot() == 3 && EquipmentManager.CompareEquipment(is, chest)) {
                    chest = is;
                    if (prefix.equals("!")) {
                        ee.setChestplateDropChance(1.0f);
                    }
                }
                if (is.getSlot() != 4 || !EquipmentManager.CompareEquipment(is, helmet)) continue;
                helmet = is;
                if (!prefix.equals("!")) continue;
                ee.setHelmetDropChance(1.0f);
            }
        }
        if (helmet != null) {
            ee.setHelmet(helmet.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Helm to: " + helmet.getItemStack().toString());
        }
        if (chest != null) {
            ee.setChestplate(chest.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Chest to: " + chest.getItemStack().toString());
        }
        if (leggings != null) {
            ee.setLeggings(leggings.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Legs to: " + leggings.getItemStack().toString());
        }
        if (boots != null) {
            ee.setBoots(boots.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Boots to: " + boots.getItemStack().toString());
        }
        if (hand != null) {
            ee.setItemInHand(hand.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Hand to: " + hand.getItemStack().toString());
        }
    }
}

