/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy.commands;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.legacy.commands.CommandHandler;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.spawning.spawners.SpawnerSlice;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnerCommands {
    public static void menuCommands(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "* Page 1 of 2");
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.ITALIC + "Command argumnts in <>'s are optional");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.ITALIC + "Commands for creating spawners...");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners create [name] [mob_name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Turns the block you're looking at into a mob spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners delete [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Deletes the mob spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners info [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Turns the block you're looking at into a mob spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners listnear <radius>" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - List all loaded Mythic Spawners");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners set [name] [attribute] [value]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Set the attribute of a Mythic Spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners spawn [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Activates a Mythic Spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners addcondition [name] [condition] [value]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Adds a condition to a spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners removecondition [name] [condition]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Removes a condition from a spawner.");
    }

    public static void menuCommands2(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "* Page 2 of 2");
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.ITALIC + "Command argumnts in <>'s are optional");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.ITALIC + "Commands for moving spawners...");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners move [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Moves the spawner to the location you are looking at.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners copy [name] [new_name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Turns the block you're looking at into a copy of a mob spawner.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners cut [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Cuts the given spawners and saves them to the clipboard.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners paste [name]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Pastes spawners in your clipboard based on your relative location.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners undo" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Undo the last clipboard-related change you've done (clipboard must still have spawners in it for this to work)");
    }

    public static void parseCommands(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (args.length == 1) {
            SpawnerCommands.menuCommands(sender);
            return;
        }
        switch (args[1].toLowerCase()) {
            case "1": {
                SpawnerCommands.menuCommands(sender);
                break;
            }
            case "2": {
                SpawnerCommands.menuCommands2(sender);
                break;
            }
            case "create": 
            case "c": {
                SpawnerCommands.cmdSpawnerCreate(sender, args);
                break;
            }
            case "copy": 
            case "cp": 
            case "duplicate": 
            case "replicate": 
            case "dp": {
                SpawnerCommands.cmdSpawnerDuplicate(sender, args);
                break;
            }
            case "cut": {
                SpawnerCommands.cmdSpawnerCut(sender, args);
                break;
            }
            case "paste": 
            case "p": {
                SpawnerCommands.cmdSpawnerPaste(sender, args);
                break;
            }
            case "undo": {
                SpawnerCommands.cmdSpawnerUndo(sender, args);
                break;
            }
            case "move": 
            case "m": {
                SpawnerCommands.cmdSpawnerMove(sender, args);
                break;
            }
            case "set": 
            case "s": {
                SpawnerCommands.cmdSpawnerSet(sender, args);
                break;
            }
            case "listnear": 
            case "ln": {
                SpawnerCommands.cmdSpawnerListNear(sender, args);
                break;
            }
            case "remove": 
            case "delete": {
                SpawnerCommands.cmdSpawnerRemove(sender, args);
                break;
            }
            case "activate": 
            case "spawn": 
            case "a": {
                SpawnerCommands.cmdSpawnerActivate(sender, args);
                break;
            }
            case "info": 
            case "i": {
                SpawnerCommands.cmdSpawnerInfo(sender, args);
                break;
            }
            case "addcondition": 
            case "ac": {
                SpawnerCommands.cmdConditionAdd(sender, args);
                break;
            }
            case "removecondition": 
            case "rc": {
                SpawnerCommands.cmdConditionRemove(sender, args);
                break;
            }
            case "resettimers": {
                SpawnerCommands.cmdResetTimers(sender, args);
                break;
            }
            default: {
                SpawnerCommands.menuCommands(sender);
            }
        }
    }

    public static void cmdSpawnerCreate(CommandSender sender, String[] args) {
        String mobName;
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 4) {
            sender.sendMessage(ChatColor.RED + "Command Format: " + ChatColor.AQUA + "/mm spawners create [name] [mob_name]");
            return;
        }
        String name = args[2];
        if (name == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a name for the spawner.");
            return;
        }
        Optional<MythicSpawner> maybeSpawner = MythicMobs.inst().getSpawnerManager().getSpawnerByHashcode(name.hashCode());
        if (maybeSpawner.isPresent()) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner name must resolve to a unique hashcode.");
            return;
        }
        int level = 1;
        if (args[3].contains(":")) {
            String[] split = args[3].split(":");
            mobName = split[0];
            try {
                level = Integer.parseInt(split[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid mob level supplied: must be an integer.");
                return;
            }
        } else {
            mobName = args[3];
        }
        if (mobName == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a Mythic Mob for the spawner to spawn.");
            return;
        }
        if (MythicMobs.inst().getMobManager().getMythicMob(args[3]) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Mob. That one was not found!");
            return;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 10).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to place the spawner!");
            return;
        }
        MythicSpawner ms = MythicMobs.inst().getSpawnerManager().createSpawner(name, location, mobName);
        if (ms != null) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "New spawner was created successfully!");
            if (level > 1) {
                ms.setMobLevel(level);
            }
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner creation failed: spawner name is probably already taken!");
            return;
        }
    }

    public static void cmdSpawnerDuplicate(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a spawner to copy.");
            return;
        }
        String name = args[2];
        if (MythicMobs.inst().getSpawnerManager().getSpawnerByName(name) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner to copy!");
            return;
        }
        if (args.length < 4) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a name for the new spawner.");
            return;
        }
        String nameNew = args[3];
        MythicSpawner msNew = MythicMobs.inst().getSpawnerManager().getSpawnerByName(args[3]);
        if (msNew != null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The name you entered for a new spawner is already in use!");
            return;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 10).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to place the spawner!");
            return;
        }
        if (MythicMobs.inst().getSpawnerManager().copySpawner(name, nameNew, BukkitAdapter.adapt(location))) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "New spawner was cloned successfully!");
        }
    }

    public static void cmdSpawnerMove(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a spawner to move.");
            return;
        }
        String name = args[2];
        if (MythicMobs.inst().getSpawnerManager().getSpawnerByName(name) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner to move!");
            return;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 10).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to move the spawner!");
            return;
        }
        if (MythicMobs.inst().getSpawnerManager().moveSpawner(name, BukkitAdapter.adapt(location))) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner " + name + " was moved successfully!");
        }
    }

    public static void cmdSpawnerSet(CommandSender sender, String[] args) {
        if (args.length < 5) {
            SpawnerCommands.menuSet(sender);
            return;
        }
        String name = args[2];
        String option = args[3];
        String value = args[4];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicMobs.inst().getSpawnerManager().setSpawnerAttribute(ms, option, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The attribute or value you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner attribute " + ChatColor.AQUA + option + ChatColor.GREEN + " set to " + ChatColor.AQUA + value + ChatColor.GREEN + " on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (MythicMobs.inst().getSpawnerManager().setSpawnerAttribute(ms, option, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner attribute " + ChatColor.AQUA + option + ChatColor.GREEN + " set to " + ChatColor.AQUA + value + ChatColor.GREEN + " on all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicMobs.inst().getSpawnerManager().setSpawnerAttribute(ms, option, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner attribute " + ChatColor.AQUA + option + ChatColor.GREEN + " set to " + ChatColor.AQUA + value + ChatColor.GREEN + " on spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return;
            }
            if (!MythicMobs.inst().getSpawnerManager().setSpawnerAttribute(ms, option, value)) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The attribute or value you entered was invalid!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner attribute " + ChatColor.AQUA + option + ChatColor.GREEN + " set to " + ChatColor.AQUA + value + " on spawner " + name);
            }
        }
    }

    public static void cmdSpawnerListNear(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        double radius = 32.0;
        if (args.length >= 3) {
            radius = Double.parseDouble(args[2]);
        }
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.GOLD + "Spawners within " + radius + " blocks of you:");
        for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
            if (ms.getLocation().getWorld() == null || !ms.getLocation().getWorld().equals(BukkitAdapter.adapt(((Player)sender).getLocation()).getWorld()) || !(ms.distanceTo(BukkitAdapter.adapt((Player)sender).getLocation()) <= radius)) continue;
            sender.sendMessage(ChatColor.GOLD + "- " + ChatColor.GREEN + ms.getName() + ChatColor.AQUA + " (" + (int)ms.distanceTo(BukkitAdapter.adapt((Player)sender).getLocation()) + " blocks away)");
        }
    }

    public static void cmdSpawnerRemove(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner to remove!");
            return;
        }
        String name = args[2];
        MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
        if (ms == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            return;
        }
        if (MythicMobs.inst().getSpawnerManager().removeSpawner(ms)) {
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.SMOKE, 0);
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner was removed successfully!");
        }
    }

    public static void cmdSpawnerActivate(CommandSender sender, String[] args) {
        String name;
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner to activate!");
        }
        if ((name = args[2]).startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                ms.ActivateSpawner();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "All spawners in group " + group + " have been activated!");
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                ms.ActivateSpawner();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "All spawners have been activated!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?"))) continue;
                ms.ActivateSpawner();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner matching pattern " + name + " have been activated!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            }
            ms.ActivateSpawner();
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawners " + name + " has been activated!");
        }
    }

    public static void cmdSpawnerInfo(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner!");
            return;
        }
        String name = args[2];
        MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
        if (ms == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            return;
        }
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(ms.getTypeName());
        sender.sendMessage(ChatColor.GOLD + "Stats for Spawner " + ChatColor.BOLD + ChatColor.GRAY + ms.getName() + ":");
        sender.sendMessage(ChatColor.GOLD + "Location: " + ChatColor.GRAY + ms.getLocation().getBlockX() + "," + ms.getLocation().getBlockY() + "," + ms.getLocation().getBlockZ() + "@" + ms.getLocation().getWorld().getName() + "");
        sender.sendMessage(ChatColor.GOLD + "MobSpawn: " + ChatColor.GRAY + mm.getInternalName());
        sender.sendMessage(ChatColor.GOLD + "Group: " + ChatColor.GRAY + ms.getGroup());
        sender.sendMessage(ChatColor.GOLD + "MaxMobs: " + ChatColor.GRAY + ms.getMaxMobs());
        sender.sendMessage(ChatColor.GOLD + "MobLevel: " + ChatColor.GRAY + ms.getMobLevel());
        sender.sendMessage(ChatColor.GOLD + "MobsPerSpawn: " + ChatColor.GRAY + ms.getMobsPerSpawn());
        sender.sendMessage(ChatColor.GOLD + "SpawnRadius: " + ChatColor.GRAY + ms.getSpawnRadius());
        sender.sendMessage(ChatColor.GOLD + "SpawnRadiusY: " + ChatColor.GRAY + ms.getSpawnRadiusY());
        sender.sendMessage(ChatColor.GOLD + "ActivationRange: " + ChatColor.GRAY + ms.getActivationRange());
        sender.sendMessage(ChatColor.GOLD + "LeashRange: " + ChatColor.GRAY + ms.getLeashRange());
        sender.sendMessage(ChatColor.GOLD + "HealOnLeash: " + ChatColor.GRAY + ms.getHealLeashedMobs());
        sender.sendMessage(ChatColor.GOLD + "Cooldown: " + ChatColor.GRAY + ms.getCooldownSeconds());
        sender.sendMessage(ChatColor.GOLD + "Warmup: " + ChatColor.GRAY + ms.getWarmupSeconds());
        sender.sendMessage(ChatColor.GOLD + "Breakable: " + ChatColor.GRAY + ms.isBreakable());
        sender.sendMessage(ChatColor.GOLD + "Conditions: " + ChatColor.GRAY + ms.getConditionList().toString());
        sender.sendMessage(ChatColor.RED + "Current # Mobs Spawned: " + ChatColor.GRAY + ms.getNumberOfMobs() + " mobs (Cached: " + ms.getNumberOfCachedMobs() + ")");
        sender.sendMessage(ChatColor.RED + "Spawner On Cooldown: " + ChatColor.WHITE + ms.isOnCooldown() + " (" + ChatColor.GRAY + ms.getRemainingCooldownSeconds() + " seconds)");
        sender.sendMessage(ChatColor.RED + "Spawner On Warmup: " + ChatColor.WHITE + ms.isOnWarmup() + " (" + ChatColor.GRAY + ms.getRemainingWarmupSeconds() + " seconds)");
        sender.sendMessage(ChatColor.RED + "Spawner Internal Cooldown: " + ChatColor.GRAY + ms.getInternalCooldown() + " ticks");
        if (ConfigManager.debugLevel > 0) {
            sender.sendMessage(ChatColor.YELLOW + "Associated Mobs: " + ChatColor.AQUA + ms.getAssociatedMobs().toString());
        }
    }

    public static void menuSet(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.YELLOW + "Command: " + ChatColor.AQUA + "/mm spawners set [name] [attribute] [value]");
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.BOLD + "Available Attributes:");
        sender.sendMessage(ChatColor.GOLD + "activationrange" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The name of a group to organize the spawner into.");
        sender.sendMessage(ChatColor.GOLD + "cooldown" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The time (in seconds) between mob spawns.");
        sender.sendMessage(ChatColor.GOLD + "group" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The name of a group to organize the spawner into.");
        sender.sendMessage(ChatColor.GOLD + "healonleash" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - (true/false) Whether or not a mob will heal to full health upon being leashed.");
        sender.sendMessage(ChatColor.GOLD + "leashrange" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The max range a mob can be from the spawner before it is teleported back (0=none).");
        sender.sendMessage(ChatColor.GOLD + "maxmobs" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The maximum number of mobs this spawner can have active at once.");
        sender.sendMessage(ChatColor.GOLD + "moblevel" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The level of the mobs spawned by the spawner.");
        sender.sendMessage(ChatColor.GOLD + "mobsperspawn" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - How many mobs will spawn per spawner cycle.");
        sender.sendMessage(ChatColor.GOLD + "resetthreatonleash" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - (true/false) Whether or not the mob's target should be reset upon being leashed.");
        sender.sendMessage(ChatColor.GOLD + "showflames" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - (true/false) whether to always show spawner flames on the block.");
        sender.sendMessage(ChatColor.GOLD + "usetimer" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - (true/false) whether the spawner should spawn on a timer or not..");
        sender.sendMessage(ChatColor.GOLD + "warmup" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - The time (in seconds) until a mob spawns after a mob dies, when the max number of mobs has been reached.");
    }

    public static void menuConditions(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.YELLOW + "Command: " + ChatColor.AQUA + "/mm spawners addcondition [condition] <data>");
        sender.sendMessage(ChatColor.YELLOW + "View conditions @ http://xikage.elseland.net/mythicmobs");
    }

    public static void cmdConditionAdd(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 5) {
            SpawnerCommands.menuConditions(sender);
            return;
        }
        String name = args[2];
        String condition = args[3];
        String value = args[4];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicMobs.inst().getSpawnerManager().addSpawnerCondition(ms, condition, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " set to " + ChatColor.AQUA + value + " on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (MythicMobs.inst().getSpawnerManager().addSpawnerCondition(ms, condition, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " added to all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicMobs.inst().getSpawnerManager().addSpawnerCondition(ms, condition, value)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " added to spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return;
            }
            if (!MythicMobs.inst().getSpawnerManager().addSpawnerCondition(ms, condition, value)) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " set to " + ChatColor.AQUA + value);
            }
        }
    }

    public static void cmdConditionRemove(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        String name = args[2];
        String condition = args[3];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicMobs.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " was removed on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (MythicMobs.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " removed from all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicMobs.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) continue;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The condition you entered was invalid!");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " removed from spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return;
            }
            if (!MythicMobs.inst().getSpawnerManager().removeSpawnerCondition(ms, condition)) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The attribute or value you entered was invalid!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner condition " + ChatColor.AQUA + condition + ChatColor.GREEN + " has been removed!");
            }
        }
    }

    public static void cmdResetTimers(CommandSender sender, String[] args) {
        String name = args[2];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner timers reset on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner timers reset on all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner timers reset on spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return;
            }
            ms.resetTimers();
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner timers reset on spawner " + name);
        }
    }

    public static void cmdSpawnerCut(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a spawner to move.");
            return;
        }
        String name = args[2];
        ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByString(BukkitAdapter.adapt((Player)sender).getLocation(), name);
        if (msl.size() == 0) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Your entry returned no spawners to copy.");
            return;
        }
        sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Cut " + ChatColor.AQUA + msl.size() + ChatColor.GREEN + " spawners to the clipboard!");
        SpawnerSlice.CutSpawners(msl, BukkitAdapter.adapt(((Player)sender).getLocation()));
    }

    public static void cmdSpawnerPaste(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (SpawnerSlice.PasteSpawners(BukkitAdapter.adapt(((Player)sender).getLocation()))) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawners pasted from the clipboard!");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "There are no spawners to paste in the clipboard (or an error occured!)");
        }
    }

    public static void cmdSpawnerUndo(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            CommandHandler.NoConsole(sender);
            return;
        }
        if (SpawnerSlice.Undo()) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Last spawner clipboard changes undone!");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "There are no spawners in the clipboard to undo an action on!");
        }
    }
}

