/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy.commands;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class DebugCommands {
    public static void menuCommands(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.ITALIC + "Command argumnts in <>'s are optional");
        sender.sendMessage(ChatColor.YELLOW + "/mm debug [level]" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Sets debug reporting. Can be between 0 and 4 (0=off,4=too much info).");
        sender.sendMessage(ChatColor.YELLOW + "/mm debug mode [true/false]" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Sets debug mode on or off. See plugin manual for details).");
        sender.sendMessage(ChatColor.YELLOW + "/mm debug timings" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Show basic timing information (timings must be on first).");
        sender.sendMessage(ChatColor.YELLOW + "/mm debug timings [on/off]" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Turns timings on/off.");
        sender.sendMessage(ChatColor.YELLOW + "/mm debug timings spawners" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Shows spawner-specific timings in the console.");
    }

    public static void parseCommands(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (args.length == 1) {
            DebugCommands.menuCommands(sender);
            return;
        }
        switch (args[1].toLowerCase()) {
            case "mode": 
            case "m": {
                DebugCommands.cmdDebugMode(sender, args);
                break;
            }
            case "timings": {
                DebugCommands.cmdTimings(sender, args);
                break;
            }
            case "spawns": {
                DebugCommands.cmdSpawns(sender, args);
                break;
            }
            default: {
                DebugCommands.cmdDebug(sender, args);
            }
        }
    }

    public static void cmdDebug(CommandSender sender, String[] args) {
        try {
            ConfigManager.debugLevel = Integer.parseInt(args[1]);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Debug level has been set to " + args[1]);
        }
        catch (Exception e) {
            DebugCommands.menuCommands(sender);
        }
    }

    public static void cmdDebugMode(CommandSender sender, String[] args) {
        try {
            ConfigManager.debugMode = Boolean.parseBoolean(args[2]);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Debug level has been set to " + args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + " Error: Debug Mode must be true or false.");
        }
    }

    public static void cmdTimings(CommandSender sender, String[] args) {
        if (args.length > 2) {
            if ("ON".equals(args[2].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().enable();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been enabled.");
            } else if ("OFF".equals(args[2].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().disable();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been disabled.");
            } else if ("RESET".equals(args[2].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().reset();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been reset.");
            } else if ("SPAWNERS".equals(args[2].toUpperCase())) {
                double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSpawners = MythicMobs.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
                MythicMobs.debug(0, " Spawner Timings");
                MythicMobs.debug(0, "Time Analyzed: " + overallMS);
                MythicMobs.debug(0, "Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicMobs.debug(0, "- CSpawners: " + Math.round(totalSpawners * 100.0) / 100L + "ms (" + Math.round(totalSpawners / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSpawners / overallMS * 10000.0) / 100L + "% Overall)");
                MythicMobs.debug(0, "-- All Spawners:");
                HashMap map = (HashMap)MythicMobs.inst().getTimingsHandler().getAllSpawnerTimes().clone();
                map = DebugCommands.sortHashMapByValuesD(map);
                for (String s : map.keySet()) {
                    long tM = (Long)map.get(s) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSpawners * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicMobs.debug(0, String.format("** %32s %8d ms - %4d pS %4d pC %4d pOverall)", s, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Spawner timings have been pasted to the console.");
            } else if ("SKILLS".equals(args[2].toUpperCase())) {
                double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSkills = MythicMobs.inst().getTimingsHandler().getTimeSkills() / 1000000L;
                MythicMobs.debug(0, " AbstractSkill Timings");
                MythicMobs.debug(0, "Time Analyzed: " + overallMS);
                MythicMobs.debug(0, "Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicMobs.debug(0, "- TmrSkills: " + Math.round(totalSkills * 100.0) / 100L + "ms (" + Math.round(totalSkills / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSkills / overallMS * 10000.0) / 100L + "% Overall)");
                MythicMobs.debug(0, "-- All Timer Skills:");
                HashMap map = (HashMap)MythicMobs.inst().getTimingsHandler().getAllSkillTimes().clone();
                map = DebugCommands.sortHashMapByValuesD(map);
                for (String s : map.keySet()) {
                    long tM = (Long)map.get(s) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSkills * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicMobs.debug(0, String.format("** %64s %8d ms - %4d pS %4d pC %4d pOverall)", s, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " AbstractSkill timings have been pasted to the console.");
            } else {
                DebugCommands.menuCommands(sender);
            }
        } else {
            if (!MythicMobs.inst().getTimingsHandler().isEnabled()) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings must be enabled first.");
                return;
            }
            double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
            double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
            double totalSkills = MythicMobs.inst().getTimingsHandler().getTimeSkills() / 1000000L;
            double totalRandomSpawners = MythicMobs.inst().getTimingsHandler().getTimeRandomSpawners() / 1000000L;
            double totalScanner = MythicMobs.inst().getTimingsHandler().getTimeScanner() / 1000000L;
            double totalSpawners = MythicMobs.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
            double totalThreatT = MythicMobs.inst().getTimingsHandler().getTimeThreatTables() / 1000000L;
            double overhead = totalMS - totalSkills - totalSpawners - totalThreatT - totalScanner - totalRandomSpawners;
            sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + " Clock Timings");
            sender.sendMessage(ChatColor.AQUA + "Time Analyzed: " + overallMS);
            sender.sendMessage(ChatColor.AQUA + "Clock Time: " + ChatColor.GREEN + (double)Math.round(totalMS * 100.0) / 100.0 + "ms (" + (double)Math.round(totalMS / overallMS * 10000.0) / 100.0 + "%)");
            sender.sendMessage(ChatColor.AQUA + "- TmrSkills: " + ChatColor.GREEN + (double)Math.round(totalSkills * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSkills / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSkills / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- RndSpawns: " + ChatColor.GREEN + (double)Math.round(totalRandomSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalRandomSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalRandomSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- CSpawners: " + ChatColor.GREEN + (double)Math.round(totalSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- MobScannr: " + ChatColor.GREEN + (double)Math.round(totalScanner * 100.0) / 100.0 + "ms (" + (double)Math.round(totalScanner / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalScanner / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- ThrtTables: " + ChatColor.GREEN + (double)Math.round(totalThreatT * 100.0) / 100.0 + "ms (" + (double)Math.round(totalThreatT / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalThreatT / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- Overhead+: " + ChatColor.GREEN + (double)Math.round(overhead * 100.0) / 100.0 + "ms (" + (double)Math.round(overhead / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(overhead / overallMS * 10000.0) / 100.0 + "% Overall)");
        }
    }

    public static void cmdSpawns(CommandSender sender, String[] args) {
        if (args.length > 2) {
            if ("ON".equals(args[2].toUpperCase())) {
                ConfigManager.debugSpawners = false;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " All spawning has been enabled.");
            } else if ("OFF".equals(args[2].toUpperCase())) {
                ConfigManager.debugSpawners = true;
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " All spawning has been disabled.");
            } else {
                DebugCommands.menuCommands(sender);
            }
        } else {
            DebugCommands.menuCommands(sender);
        }
    }

    public static LinkedHashMap sortHashMapByValuesD(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (Long)val);
                continue block0;
            }
        }
        return sortedMap;
    }
}

