/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.io;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class MythicConfig {
    private String configName;
    private FileConfiguration fc;

    public MythicConfig(String name, FileConfiguration fc) {
        this.configName = name;
        this.fc = fc;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fc;
    }

    public boolean isSet(String field) {
        return this.fc.isSet(this.configName + "." + field);
    }

    public String getString(String field) {
        return this.fc.getString(this.configName + "." + field);
    }

    public String getString(String field, String def) {
        return this.fc.getString(this.configName + "." + field, def);
    }

    public String getColorString(String field) {
        String s = this.fc.getString(this.configName + "." + field);
        if (s != null) {
            s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        }
        return s;
    }

    public String getColorString(String field, String def) {
        String s = this.fc.getString(this.configName + "." + field, def);
        if (s != null) {
            s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        }
        return s;
    }

    public boolean getBoolean(String field) {
        return this.fc.getBoolean(this.configName + "." + field);
    }

    public boolean getBoolean(String field, boolean def) {
        return this.fc.getBoolean(this.configName + "." + field, def);
    }

    public int getInt(String field) {
        return this.fc.getInt(this.configName + "." + field);
    }

    public int getInt(String field, int def) {
        return this.fc.getInt(this.configName + "." + field, def);
    }

    public double getDouble(String field) {
        return this.fc.getDouble(this.configName + "." + field);
    }

    public double getDouble(String field, double def) {
        return this.fc.getDouble(this.configName + "." + field, def);
    }

    public List<String> getStringList(String field) {
        return this.fc.getStringList(this.configName + "." + field);
    }

    public List<String> getColorStringList(String field) {
        List list = this.fc.getStringList(this.configName + "." + field);
        ArrayList<String> parsed = new ArrayList<String>();
        if (list != null) {
            for (String str : list) {
                parsed.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
            }
        }
        return parsed;
    }

    public List<Map<?, ?>> getMapList(String field) {
        return this.fc.getMapList(this.configName + "." + field);
    }

    public List<?> getList(String field) {
        return this.fc.getList(this.configName + "." + field);
    }

    public List<Byte> getByteList(String field) {
        return this.fc.getByteList(this.configName + "." + field);
    }

    public ItemStack getItemStack(String field, String def) {
        return this.fc.getItemStack(this.configName + "." + field);
    }

    public Set<String> getKeys(String section) {
        return this.fc.getConfigurationSection(this.configName + "." + section).getKeys(false);
    }
}

