/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.drops.MythicDropTable;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;

public class DropManager {
    private final MythicMobs core;
    private ConcurrentHashMap<String, MythicDropTable> droptables = new ConcurrentHashMap();

    public DropManager(MythicMobs core) {
        this.core = core;
    }

    public void loadDropTables() {
        IOLoader<MythicMobs> defaultDroptables = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleDropTables.yml", "DropTables");
        List<File> droptableFiles = IOHandler.getAllFiles(defaultDroptables.thefile.getParent());
        List<IOLoader<MythicMobs>> droptableLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), droptableFiles, "DropTables");
        this.droptables.clear();
        for (IOLoader<MythicMobs> sl : droptableLoaders) {
            for (String s : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                if (sl.getCustomConfig().getStringList(s + ".Drops") == null) continue;
                String file = sl.thefile.getName();
                MythicConfig mc = new MythicConfig(s, sl.getCustomConfig());
                MythicDropTable dt = new MythicDropTable(file, s, mc);
                this.droptables.put(s, dt);
            }
        }
    }

    public Collection<MythicDropTable> getDropTables() {
        return this.droptables.values();
    }

    public Optional<MythicDropTable> getDropTable(String name) {
        return Optional.ofNullable(this.droptables.getOrDefault(name, null));
    }

    public static double parseAmount(String s) {
        double i = 1.0;
        if (s.contains("-")) {
            String[] range = s.split("-");
            int min = Integer.parseInt(range[0]);
            int max = Integer.parseInt(range[1]);
            i = MythicMobs.r.nextInt(max - min + 1) + min;
        } else {
            try {
                i = Double.parseDouble(s);
            }
            catch (Exception e) {
                i = 1.0;
            }
        }
        return i;
    }

    public static void Drop(Location loc, int exp, List<ItemStack> drops) {
        for (ItemStack is : drops) {
            loc.getWorld().dropItemNaturally(loc, is);
        }
        if (exp != 0) {
            int i = exp % 4;
            int per = (exp - exp % 4) / 4;
            for (int y = 0; y < 4; ++y) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(per);
            }
            if (i != 0) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(i);
            }
        }
    }
}

