/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class HeroesSupport {
    private Heroes heroes = (Heroes)Bukkit.getPluginManager().getPlugin("Heroes");

    public Heroes getHeroes() {
        return this.heroes;
    }

    public void giveHeroesExp(ActiveMob am, Player player, int amount) {
        if (!ConfigManager.compatHeroesXPEnable) {
            return;
        }
        if (player == null) {
            return;
        }
        Hero h = this.heroes.getCharacterManager().getHero(player);
        if (h.hasParty()) {
            double bonusExp;
            HeroParty hp = h.getParty();
            HashSet<Hero> inRangeMembers = new HashSet<Hero>();
            for (Hero partyMember : hp.getMembers()) {
                if (!player.getLocation().getWorld().equals(partyMember.getPlayer().getLocation().getWorld()) || player.getLocation().distanceSquared(partyMember.getPlayer().getLocation()) > 2500.0 || !partyMember.canGain(HeroClass.ExperienceType.KILLING)) continue;
                inRangeMembers.add(partyMember);
            }
            int partySize = inRangeMembers.size();
            double sharedExp = amount / partySize;
            double d = bonusExp = partySize > 1 ? sharedExp : 0.0;
            if (partySize > 1) {
                bonusExp *= Properties.partyMults[partySize - 1];
            }
            bonusExp *= Heroes.properties.partyBonus;
            bonusExp = Util.formatDouble((double)bonusExp);
            for (Hero partyMember : inRangeMembers) {
                partyMember.gainExp(sharedExp + bonusExp, HeroClass.ExperienceType.KILLING, BukkitAdapter.adapt(am.getLocation()));
                this.sendXPMessage(partyMember.getPlayer(), am, sharedExp + bonusExp);
            }
        } else {
            h.gainExp((double)amount, HeroClass.ExperienceType.KILLING, BukkitAdapter.adapt(am.getLocation()));
            this.sendXPMessage(h.getPlayer(), am, amount);
        }
    }

    private void sendXPMessage(Player p, ActiveMob am, double amount) {
        if (ConfigManager.compatHeroesShowXPMessage) {
            String message = ConfigManager.compatHeroesXPMessageFormat;
            message = SkillString.parseMobVariables(message, am, null, BukkitAdapter.adapt(p));
            message = message.replace("<drops.xp>", String.valueOf(amount));
            p.sendMessage(message);
        }
    }

    public void setMobDamage(LivingEntity l, double damage) {
        this.heroes.getCharacterManager().getMonster(l).setDamage(damage);
    }
}

