/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.events;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootMechanic;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SkillShootProjectileListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        List metas = projectile.getMetadata("MythicMobsProjectile");
        if (metas == null || metas.size() == 0) {
            return;
        }
        for (MetadataValue meta : metas) {
            if (!(meta.value() instanceof ShootMechanic.ProjectileData)) continue;
            ShootMechanic.ProjectileData data = (ShootMechanic.ProjectileData)meta.value();
            if (data.getDamage() == 0) {
                event.setCancelled(true);
            } else {
                event.setDamage((double)data.getDamage());
            }
            data.executeHitSkill(BukkitAdapter.adapt((Entity)projectile), BukkitAdapter.adapt(event.getEntity()));
            break;
        }
        projectile.removeMetadata("MythicMobsProjectile", (Plugin)MythicMobs.inst());
        projectile.remove();
    }
}

