/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs;

import io.lumine.xikage.mythicmobs.adapters.ServerInterface;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.WorldManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitServer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitSkillTriggers;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorldManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.BlockBreakListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.ChunkLoadListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.ChunkUnloadListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.EndermanTeleportListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.MobEggListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.MobLeashListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.MobSpawnListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.MobTagListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.MobTargetListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.PlayerLoginListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.SilverfishEnterBlockListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.SkillShootProjectileListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.SkillTriggerAD;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.SlimeSplitListener;
import io.lumine.xikage.mythicmobs.adapters.bukkit.events.SnowFormListener;
import io.lumine.xikage.mythicmobs.api.bukkit.BukkitAPIHelper;
import io.lumine.xikage.mythicmobs.clock.MythicMobsAsyncClock;
import io.lumine.xikage.mythicmobs.clock.MythicMobsClock;
import io.lumine.xikage.mythicmobs.clock.TimingsHandler;
import io.lumine.xikage.mythicmobs.commands.BaseCommand;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.compatibility.LanguageAPISupport;
import io.lumine.xikage.mythicmobs.drops.DropManager;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.items.ItemManager;
import io.lumine.xikage.mythicmobs.legacy.LegacyMythicSkill;
import io.lumine.xikage.mythicmobs.legacy.commands.CommandHandler;
import io.lumine.xikage.mythicmobs.mcstats.MetricsLite;
import io.lumine.xikage.mythicmobs.mobs.EntityManager;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.SkillManager;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnerManager;
import io.lumine.xikage.mythicmobs.spawning.spawners.SpawnerManager;
import io.lumine.xikage.mythicmobs.util.Patterns;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeDisabled;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MythicMobs
extends JavaPlugin {
    private static MythicMobs plugin;
    private Logger logger = Logger.getLogger("Minecraft");
    public static Random r;
    private List<Listener> skillEvents = new ArrayList<Listener>();
    public List<LegacyMythicSkill> listLegacySkills = new ArrayList<LegacyMythicSkill>();
    public Set<Player> onlinePlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    private VolatileCodeHandler volatileCodeHandler;
    private TimingsHandler timingsHandler;
    public static String menu_header;
    private String bukkitVersion;
    private int minecraftVersion;
    private static LanguageAPISupport Language;
    private boolean updateAvailable = false;
    private ConfigManager configManager;
    private EntityManager entityManager;
    private WorldManager worldManager;
    private RandomSpawnerManager rsManager;
    private MobManager mobManager;
    private SkillManager skillManager;
    private DropManager dropsManager;
    private ItemManager itemManager;
    private SpawnerManager spawnerManager;
    private CompatibilityManager compatibility;
    private ServerInterface server;
    private BukkitAPIHelper apiHelper;

    public void onEnable() {
        plugin = this;
        this.server = new BukkitServer();
        TaskManager.initializeBukkit(this);
        SkillAdapter.initializeBukkit();
        PluginDescriptionFile pdfFile = this.getDescription();
        this.bukkitVersion = Bukkit.getServer().getClass().getPackage().getName().substring(23);
        try {
            String[] split = this.bukkitVersion.split("_");
            this.minecraftVersion = Integer.parseInt(split[1]);
        }
        catch (Exception ex) {
            this.minecraftVersion = 11;
            ex.printStackTrace();
        }
        Language = new LanguageAPISupport((Plugin)plugin, "enUS");
        MythicMobs.log(Language.get((CommandSender)Bukkit.getConsoleSender(), "loading", "Loading {0} for Bukkit {1} (Minecraft 1.{2})...", pdfFile.getName(), this.bukkitVersion, this.minecraftVersion));
        Patterns.CompilePatterns();
        this.configManager = new ConfigManager(this);
        this.compatibility = new CompatibilityManager(this);
        this.itemManager = new ItemManager(this);
        this.dropsManager = new DropManager(this);
        this.mobManager = new MobManager(this);
        this.skillManager = new SkillManager(this);
        this.spawnerManager = new SpawnerManager(this);
        this.rsManager = new RandomSpawnerManager(this);
        MythicMobs.inst().getConfigManager().LoadAll(true);
        MythicMobs.log("MythicMobs configuration file loaded successfully.");
        this.volatileCodeHandler = this.getVolatileCodeHandler();
        this.timingsHandler = new TimingsHandler();
        this.getMobManager().loadCachedActiveMobs();
        this.entityManager = new EntityManager();
        this.worldManager = new BukkitWorldManager();
        this.registerCommand("mythicmobs", new BaseCommand(this));
        this.getCommand("mythicmobslegacy").setExecutor((CommandExecutor)new CommandHandler());
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new MythicMobsClock(), 0L, (long)ConfigManager.ClockInterval);
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new MythicMobsAsyncClock(), 0L, (long)ConfigManager.ClockInterval);
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)this.entityManager, (Plugin)this);
        manager.registerEvents((Listener)this.worldManager, (Plugin)this);
        manager.registerEvents((Listener)new ChunkLoadListener(), (Plugin)this);
        manager.registerEvents((Listener)new ChunkUnloadListener(), (Plugin)this);
        manager.registerEvents((Listener)new BukkitSkillTriggers(), (Plugin)this);
        manager.registerEvents((Listener)new SkillTriggerAD(), (Plugin)this);
        manager.registerEvents((Listener)new MobSpawnListener(), (Plugin)this);
        manager.registerEvents((Listener)new SkillShootProjectileListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobLeashListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobTagListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobTargetListener(), (Plugin)this);
        manager.registerEvents((Listener)new SlimeSplitListener(), (Plugin)this);
        manager.registerEvents((Listener)new EndermanTeleportListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobEggListener(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerLoginListener(), (Plugin)this);
        manager.registerEvents((Listener)new SilverfishEnterBlockListener(), (Plugin)this);
        manager.registerEvents((Listener)new SnowFormListener(), (Plugin)this);
        manager.registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.apiHelper = new BukkitAPIHelper();
        MythicMobs.log("v" + pdfFile.getVersion() + " has been successfully loaded!");
        if (ConfigManager.AllowMetrics) {
            try {
                MetricsLite metrics = new MetricsLite((Plugin)this);
                metrics.start();
            }
            catch (IOException e) {
                MythicMobs.debug(1, "Metrics: Failed to submit Metrics stats.");
            }
        }
        MythicMobs.inst().getMobManager().ScanWorld();
    }

    public void onDisable() {
        MythicMobs.log("Disabling Mythic Mobs...");
        this.rsManager.shutdown();
        this.getSpawnerManager().resetAndSaveAll();
        this.configManager.SaveAll();
        this.getMobManager().despawnAllMobs();
        PluginDescriptionFile pdfFile = this.getDescription();
        this.entityManager = null;
        this.volatileCodeHandler = null;
        this.timingsHandler = null;
        MythicMobs.log("All active settings have been saved.");
        this.configManager.ResetAll();
        this.compatibility.shutdown();
        MythicMobs.log("v" + pdfFile.getVersion() + " has been Disabled!");
    }

    public static MythicMobs inst() {
        return plugin;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MobManager getMobManager() {
        return this.mobManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public DropManager getDropManager() {
        return this.dropsManager;
    }

    public BukkitAPIHelper getAPIHelper() {
        return this.apiHelper;
    }

    public CompatibilityManager getCompatibility() {
        return this.compatibility;
    }

    public ServerInterface getMinecraftServer() {
        return this.server;
    }

    public void registerSkillEvents(Listener l) {
        this.getServer().getPluginManager().registerEvents(l, (Plugin)this);
    }

    public void unregisterSkillEvents() {
        for (Listener l : this.skillEvents) {
            HandlerList.unregisterAll((Listener)l);
        }
        this.skillEvents.clear();
    }

    public static void throwSevere(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.SEVERE, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void throwWarning(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.WARNING, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void throwInfo(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.INFO, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void debug(String message) {
        MythicMobs.debug(2, message);
    }

    public static void debug(int level, String message) {
        if (level <= ConfigManager.debugLevel) {
            MythicMobs.log(Level.INFO, message);
        }
    }

    public static void log(String message) {
        MythicMobs.log(Level.INFO, "" + message);
    }

    public static void log(Level level, String message) {
        plugin.getLogger().log(level, message);
    }

    public static void error(String message) {
        MythicMobs.log(Level.WARNING, message);
    }

    public static void skillConfigError(String skill, String line, String message) {
        MythicMobs.log(Level.WARNING, "Error with '" + skill + "' skill: " + message);
        MythicMobs.log(Level.WARNING, "-- Incorrect line: " + line);
    }

    public static void targeterConfigError(String skill, String line, String message) {
        MythicMobs.log(Level.WARNING, "Error with '" + skill + "' targeter: " + message);
        MythicMobs.log(Level.WARNING, "-- Incorrect attribute: " + line);
    }

    public TimingsHandler getTimingsHandler() {
        return this.timingsHandler;
    }

    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        VolatileCodeHandler VCH = new VolatileCodeDisabled();
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (version.equals("craftbukkit")) {
            version = "pre";
        }
        try {
            Class<?> clazz = Class.forName("io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeEnabled_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                VCH = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            MythicMobs.error(menu_header);
            MythicMobs.error("This version of MythicMobs is not fully compatible with your version of Bukkit.");
            MythicMobs.error("Some features may be limited or disabled until you use a compatible version.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        return VCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Exception ex) {
        if (ConfigManager.errorLogging) {
            plugin.getLogger().severe("AN EXCEPTION HAS OCCURED:");
            try (PrintWriter writer = null;){
                File folder = new File(plugin.getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    plugin.getLogger().severe("    " + t.getMessage() + " (" + t.getClass().getName() + ")");
                    t.printStackTrace(writer);
                    writer.println();
                }
                plugin.getLogger().severe("This error has been saved in the Error Logs folder");
                writer.println("MythicMobs version: " + plugin.getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Error ex) {
        if (ConfigManager.errorLogging) {
            plugin.getLogger().severe("AN ERROR HAS OCCURED:");
            try (PrintWriter writer = null;){
                File folder = new File(plugin.getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    plugin.getLogger().severe("    " + t.getMessage() + " (" + t.getClass().getName() + ")");
                    t.printStackTrace(writer);
                    writer.println();
                }
                plugin.getLogger().severe("This error has been saved in the Error Logs folder");
                writer.println("MythicMobs version: " + plugin.getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    private <T extends CommandExecutor & TabCompleter> void registerCommand(String cmd, T handler) {
        this.getCommand(cmd).setExecutor(handler);
        this.getCommand(cmd).setTabCompleter((TabCompleter)handler);
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public RandomSpawnerManager getRandomSpawningManager() {
        return this.rsManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    public boolean getIsUpdateAvailable() {
        return this.updateAvailable;
    }

    static {
        r = new Random();
        menu_header = ChatColor.GOLD + "--====|||| " + ChatColor.RED + ChatColor.BOLD + " MythicMobs " + ChatColor.GOLD + " ||||====--";
    }
}

