/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDoubleMatrix;
import org.jblas.ComplexFloatMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.Solve;

public class MatrixFunctions {
    public static DoubleMatrix absi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.abs(x.get(i)));
            ++i;
        }
        return x;
    }

    public static ComplexDoubleMatrix absi(ComplexDoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, x.get(i).abs());
            ++i;
        }
        return x;
    }

    public static DoubleMatrix acosi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.acos(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix asini(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.asin(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix atani(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.atan(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix cbrti(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.cbrt(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix ceili(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.ceil(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix cosi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.cos(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix coshi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.cosh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix expi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.exp(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix floori(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.floor(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix logi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.log(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix log10i(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.log10(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix powi(DoubleMatrix x, double d) {
        if (d == 2.0) {
            return x.muli(x);
        }
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.pow(x.get(i), d));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix powi(double base, DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.pow(base, x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix powi(DoubleMatrix x, DoubleMatrix e) {
        x.checkLength(e.length);
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.pow(x.get(i), e.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix signumi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.signum(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix sini(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.sin(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix sinhi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.sinh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix sqrti(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.sqrt(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix tani(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.tan(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix tanhi(DoubleMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.tanh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static DoubleMatrix abs(DoubleMatrix x) {
        return MatrixFunctions.absi(x.dup());
    }

    public static DoubleMatrix acos(DoubleMatrix x) {
        return MatrixFunctions.acosi(x.dup());
    }

    public static DoubleMatrix asin(DoubleMatrix x) {
        return MatrixFunctions.asini(x.dup());
    }

    public static DoubleMatrix atan(DoubleMatrix x) {
        return MatrixFunctions.atani(x.dup());
    }

    public static DoubleMatrix cbrt(DoubleMatrix x) {
        return MatrixFunctions.cbrti(x.dup());
    }

    public static DoubleMatrix ceil(DoubleMatrix x) {
        return MatrixFunctions.ceili(x.dup());
    }

    public static DoubleMatrix cos(DoubleMatrix x) {
        return MatrixFunctions.cosi(x.dup());
    }

    public static DoubleMatrix cosh(DoubleMatrix x) {
        return MatrixFunctions.coshi(x.dup());
    }

    public static DoubleMatrix exp(DoubleMatrix x) {
        return MatrixFunctions.expi(x.dup());
    }

    public static DoubleMatrix floor(DoubleMatrix x) {
        return MatrixFunctions.floori(x.dup());
    }

    public static DoubleMatrix log(DoubleMatrix x) {
        return MatrixFunctions.logi(x.dup());
    }

    public static DoubleMatrix log10(DoubleMatrix x) {
        return MatrixFunctions.log10i(x.dup());
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static DoubleMatrix pow(DoubleMatrix x, double e) {
        return MatrixFunctions.powi(x.dup(), e);
    }

    public static DoubleMatrix pow(double b, DoubleMatrix x) {
        return MatrixFunctions.powi(b, x.dup());
    }

    public static DoubleMatrix pow(DoubleMatrix x, DoubleMatrix e) {
        return MatrixFunctions.powi(x.dup(), e);
    }

    public static DoubleMatrix signum(DoubleMatrix x) {
        return MatrixFunctions.signumi(x.dup());
    }

    public static DoubleMatrix sin(DoubleMatrix x) {
        return MatrixFunctions.sini(x.dup());
    }

    public static DoubleMatrix sinh(DoubleMatrix x) {
        return MatrixFunctions.sinhi(x.dup());
    }

    public static DoubleMatrix sqrt(DoubleMatrix x) {
        return MatrixFunctions.sqrti(x.dup());
    }

    public static DoubleMatrix tan(DoubleMatrix x) {
        return MatrixFunctions.tani(x.dup());
    }

    public static DoubleMatrix tanh(DoubleMatrix x) {
        return MatrixFunctions.tanhi(x.dup());
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    public static double cbrt(double x) {
        return Math.cbrt(x);
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double cosh(double x) {
        return Math.cosh(x);
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double signum(double x) {
        return Math.signum(x);
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double sinh(double x) {
        return Math.sinh(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double tanh(double x) {
        return Math.tanh(x);
    }

    public static DoubleMatrix expm(DoubleMatrix A) {
        double c0 = 1.0;
        double c1 = 0.5;
        double c2 = 0.12;
        double c3 = 0.01833333333333333;
        double c4 = 0.0019927536231884053;
        double c5 = 1.630434782608695E-4;
        double c6 = 1.0351966873706E-5;
        double c7 = 5.175983436853E-7;
        double c8 = 2.0431513566525E-8;
        double c9 = 6.306022705717593E-10;
        double c10 = 1.4837700484041396E-11;
        double c11 = 2.5291534915979653E-13;
        double c12 = 2.8101705462199615E-15;
        double c13 = 1.5440497506703084E-17;
        int j = Math.max(0, 1 + (int)Math.floor(Math.log(A.normmax()) / Math.log(2.0)));
        DoubleMatrix As = A.div(Math.pow(2.0, j));
        int n = A.getRows();
        DoubleMatrix As_2 = As.mmul(As);
        DoubleMatrix As_4 = As_2.mmul(As_2);
        DoubleMatrix As_6 = As_4.mmul(As_2);
        DoubleMatrix U = DoubleMatrix.eye(n).muli(1.0).addi(As_2.mul(0.12)).addi(As_4.mul(0.0019927536231884053)).addi(DoubleMatrix.eye(n).muli(1.0351966873706E-5).addi(As_2.mul(2.0431513566525E-8)).addi(As_4.mul(1.4837700484041396E-11)).addi(As_6.mul(2.8101705462199615E-15)).mmuli(As_6));
        DoubleMatrix V = DoubleMatrix.eye(n).muli(0.5).addi(As_2.mul(0.01833333333333333)).addi(As_4.mul(1.630434782608695E-4)).addi(DoubleMatrix.eye(n).muli(5.175983436853E-7).addi(As_2.mul(6.306022705717593E-10)).addi(As_4.mul(2.5291534915979653E-13)).addi(As_6.mul(1.5440497506703084E-17)).mmuli(As_6));
        DoubleMatrix AV = As.mmuli(V);
        DoubleMatrix N = U.add(AV);
        DoubleMatrix D = U.subi(AV);
        DoubleMatrix F = Solve.solve(D, N);
        int k = 0;
        while (k < j) {
            F.mmuli(F);
            ++k;
        }
        return F;
    }

    public static DoubleMatrix floatToDouble(FloatMatrix fm) {
        DoubleMatrix dm = new DoubleMatrix(fm.rows, fm.columns);
        int i = 0;
        while (i < fm.length) {
            dm.put(i, (double)fm.get(i));
            ++i;
        }
        return dm;
    }

    public static FloatMatrix doubleToFloat(DoubleMatrix dm) {
        FloatMatrix fm = new FloatMatrix(dm.rows, dm.columns);
        int i = 0;
        while (i < dm.length) {
            fm.put(i, (float)dm.get(i));
            ++i;
        }
        return fm;
    }

    public static FloatMatrix absi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.abs(x.get(i)));
            ++i;
        }
        return x;
    }

    public static ComplexFloatMatrix absi(ComplexFloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, x.get(i).abs());
            ++i;
        }
        return x;
    }

    public static FloatMatrix acosi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.acos(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix asini(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.asin(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix atani(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.atan(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix cbrti(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.cbrt(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix ceili(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.ceil(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix cosi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.cos(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix coshi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.cosh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix expi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.exp(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix floori(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.floor(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix logi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.log(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix log10i(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.log10(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix powi(FloatMatrix x, float d) {
        if (d == 2.0f) {
            return x.muli(x);
        }
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.pow(x.get(i), d));
            ++i;
        }
        return x;
    }

    public static FloatMatrix powi(float base, FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.pow(base, x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix powi(FloatMatrix x, FloatMatrix e) {
        x.checkLength(e.length);
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.pow(x.get(i), e.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix signumi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, Math.signum(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix sini(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.sin(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix sinhi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.sinh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix sqrti(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.sqrt(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix tani(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.tan(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix tanhi(FloatMatrix x) {
        int i = 0;
        while (i < x.length) {
            x.put(i, (float)Math.tanh(x.get(i)));
            ++i;
        }
        return x;
    }

    public static FloatMatrix abs(FloatMatrix x) {
        return MatrixFunctions.absi(x.dup());
    }

    public static FloatMatrix acos(FloatMatrix x) {
        return MatrixFunctions.acosi(x.dup());
    }

    public static FloatMatrix asin(FloatMatrix x) {
        return MatrixFunctions.asini(x.dup());
    }

    public static FloatMatrix atan(FloatMatrix x) {
        return MatrixFunctions.atani(x.dup());
    }

    public static FloatMatrix cbrt(FloatMatrix x) {
        return MatrixFunctions.cbrti(x.dup());
    }

    public static FloatMatrix ceil(FloatMatrix x) {
        return MatrixFunctions.ceili(x.dup());
    }

    public static FloatMatrix cos(FloatMatrix x) {
        return MatrixFunctions.cosi(x.dup());
    }

    public static FloatMatrix cosh(FloatMatrix x) {
        return MatrixFunctions.coshi(x.dup());
    }

    public static FloatMatrix exp(FloatMatrix x) {
        return MatrixFunctions.expi(x.dup());
    }

    public static FloatMatrix floor(FloatMatrix x) {
        return MatrixFunctions.floori(x.dup());
    }

    public static FloatMatrix log(FloatMatrix x) {
        return MatrixFunctions.logi(x.dup());
    }

    public static FloatMatrix log10(FloatMatrix x) {
        return MatrixFunctions.log10i(x.dup());
    }

    public static float pow(float x, float y) {
        return (float)Math.pow(x, y);
    }

    public static FloatMatrix pow(FloatMatrix x, float e) {
        return MatrixFunctions.powi(x.dup(), e);
    }

    public static FloatMatrix pow(float b, FloatMatrix x) {
        return MatrixFunctions.powi(b, x.dup());
    }

    public static FloatMatrix pow(FloatMatrix x, FloatMatrix e) {
        return MatrixFunctions.powi(x.dup(), e);
    }

    public static FloatMatrix signum(FloatMatrix x) {
        return MatrixFunctions.signumi(x.dup());
    }

    public static FloatMatrix sin(FloatMatrix x) {
        return MatrixFunctions.sini(x.dup());
    }

    public static FloatMatrix sinh(FloatMatrix x) {
        return MatrixFunctions.sinhi(x.dup());
    }

    public static FloatMatrix sqrt(FloatMatrix x) {
        return MatrixFunctions.sqrti(x.dup());
    }

    public static FloatMatrix tan(FloatMatrix x) {
        return MatrixFunctions.tani(x.dup());
    }

    public static FloatMatrix tanh(FloatMatrix x) {
        return MatrixFunctions.tanhi(x.dup());
    }

    public static float abs(float x) {
        return Math.abs(x);
    }

    public static float acos(float x) {
        return (float)Math.acos(x);
    }

    public static float asin(float x) {
        return (float)Math.asin(x);
    }

    public static float atan(float x) {
        return (float)Math.atan(x);
    }

    public static float cbrt(float x) {
        return (float)Math.cbrt(x);
    }

    public static float ceil(float x) {
        return (float)Math.ceil(x);
    }

    public static float cos(float x) {
        return (float)Math.cos(x);
    }

    public static float cosh(float x) {
        return (float)Math.cosh(x);
    }

    public static float exp(float x) {
        return (float)Math.exp(x);
    }

    public static float floor(float x) {
        return (float)Math.floor(x);
    }

    public static float log(float x) {
        return (float)Math.log(x);
    }

    public static float log10(float x) {
        return (float)Math.log10(x);
    }

    public static float signum(float x) {
        return Math.signum(x);
    }

    public static float sin(float x) {
        return (float)Math.sin(x);
    }

    public static float sinh(float x) {
        return (float)Math.sinh(x);
    }

    public static float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static float tan(float x) {
        return (float)Math.tan(x);
    }

    public static float tanh(float x) {
        return (float)Math.tanh(x);
    }

    public static FloatMatrix expm(FloatMatrix A) {
        float c0 = 1.0f;
        float c1 = 0.5f;
        float c2 = 0.12f;
        float c3 = 0.018333333f;
        float c4 = 0.0019927537f;
        float c5 = 1.6304349E-4f;
        float c6 = 1.0351967E-5f;
        float c7 = 5.175983E-7f;
        float c8 = 2.0431514E-8f;
        float c9 = 6.306023E-10f;
        float c10 = 1.48377E-11f;
        float c11 = 2.5291534E-13f;
        float c12 = 2.8101705E-15f;
        float c13 = 1.5440497E-17f;
        int j = Math.max(0, 1 + (int)Math.floor(Math.log(A.normmax()) / Math.log(2.0)));
        FloatMatrix As = A.div((float)Math.pow(2.0, j));
        int n = A.getRows();
        FloatMatrix As_2 = As.mmul(As);
        FloatMatrix As_4 = As_2.mmul(As_2);
        FloatMatrix As_6 = As_4.mmul(As_2);
        FloatMatrix U = FloatMatrix.eye(n).muli(1.0f).addi(As_2.mul(0.12f)).addi(As_4.mul(0.0019927537f)).addi(FloatMatrix.eye(n).muli(1.0351967E-5f).addi(As_2.mul(2.0431514E-8f)).addi(As_4.mul(1.48377E-11f)).addi(As_6.mul(2.8101705E-15f)).mmuli(As_6));
        FloatMatrix V = FloatMatrix.eye(n).muli(0.5f).addi(As_2.mul(0.018333333f)).addi(As_4.mul(1.6304349E-4f)).addi(FloatMatrix.eye(n).muli(5.175983E-7f).addi(As_2.mul(6.306023E-10f)).addi(As_4.mul(2.5291534E-13f)).addi(As_6.mul(1.5440497E-17f)).mmuli(As_6));
        FloatMatrix AV = As.mmuli(V);
        FloatMatrix N = U.add(AV);
        FloatMatrix D = U.subi(AV);
        FloatMatrix F = Solve.solve(D, N);
        int k = 0;
        while (k < j) {
            F.mmuli(F);
            ++k;
        }
        return F;
    }
}

