/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDoubleMatrix;
import org.jblas.ComplexFloatMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.SimpleBlas;
import org.jblas.exceptions.NoEigenResultException;
import org.jblas.ranges.IntervalRange;
import org.jblas.ranges.Range;

public class Eigen {
    private static final DoubleMatrix dummyDouble = new DoubleMatrix(1);
    private static final FloatMatrix dummyFloat = new FloatMatrix(1);

    public static DoubleMatrix symmetricEigenvalues(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix eigenvalues = new DoubleMatrix(A.rows);
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('N', 'A', 'U', A.dup(), 0.0, 0.0, 0, 0, 0.0, eigenvalues, dummyDouble, isuppz);
        return eigenvalues;
    }

    public static DoubleMatrix[] symmetricEigenvectors(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix eigenvalues = new DoubleMatrix(A.rows);
        DoubleMatrix eigenvectors = A.dup();
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('V', 'A', 'U', A.dup(), 0.0, 0.0, 0, 0, 0.0, eigenvalues, eigenvectors, isuppz);
        return new DoubleMatrix[]{eigenvectors, DoubleMatrix.diag(eigenvalues)};
    }

    public static ComplexDoubleMatrix eigenvalues(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix WR = new DoubleMatrix(A.rows);
        DoubleMatrix WI = WR.dup();
        SimpleBlas.geev('N', 'N', A.dup(), WR, WI, dummyDouble, dummyDouble);
        return new ComplexDoubleMatrix(WR, WI);
    }

    public static ComplexDoubleMatrix[] eigenvectors(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix WR = new DoubleMatrix(A.rows);
        DoubleMatrix WI = WR.dup();
        DoubleMatrix VR = new DoubleMatrix(A.rows, A.rows);
        SimpleBlas.geev('N', 'V', A.dup(), WR, WI, dummyDouble, VR);
        ComplexDoubleMatrix E = new ComplexDoubleMatrix(WR, WI);
        ComplexDoubleMatrix V = new ComplexDoubleMatrix(A.rows, A.rows);
        int i = 0;
        while (i < A.rows) {
            if (E.get(i).isReal()) {
                V.putColumn(i, new ComplexDoubleMatrix(VR.getColumn(i)));
            } else {
                ComplexDoubleMatrix v = new ComplexDoubleMatrix(VR.getColumn(i), VR.getColumn(i + 1));
                V.putColumn(i, v);
                V.putColumn(i + 1, v.conji());
                ++i;
            }
            ++i;
        }
        return new ComplexDoubleMatrix[]{V, ComplexDoubleMatrix.diag(E)};
    }

    public static DoubleMatrix symmetricGeneralizedEigenvalues(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        B.assertSquare();
        DoubleMatrix W = new DoubleMatrix(A.rows);
        SimpleBlas.sygvd(1, 'N', 'U', A.dup(), B.dup(), W);
        return W;
    }

    public static DoubleMatrix[] symmetricGeneralizedEigenvectors(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        B.assertSquare();
        DoubleMatrix[] result = new DoubleMatrix[2];
        DoubleMatrix dA = A.dup();
        DoubleMatrix dB = B.dup();
        DoubleMatrix W = new DoubleMatrix(dA.rows);
        SimpleBlas.sygvd(1, 'V', 'U', dA, dB, W);
        result[0] = dA;
        result[1] = W;
        return result;
    }

    public static DoubleMatrix symmetricGeneralizedEigenvalues(DoubleMatrix A, DoubleMatrix B, double vl, double vu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (vu <= vl) {
            throw new IllegalArgumentException("Bound exception: make sure vu > vl");
        }
        double abstol = 1.0E-9;
        int[] m = new int[1];
        DoubleMatrix W = new DoubleMatrix(A.rows);
        DoubleMatrix Z = new DoubleMatrix(A.rows, A.rows);
        SimpleBlas.sygvx(1, 'N', 'V', 'U', A.dup(), B.dup(), vl, vu, 0, 0, abstol, m, W, Z);
        if (m[0] == 0) {
            throw new NoEigenResultException("No eigenvalues found for selected range");
        }
        return W.get((Range)new IntervalRange(0, m[0]), 0);
    }

    public static DoubleMatrix symmetricGeneralizedEigenvalues(DoubleMatrix A, DoubleMatrix B, int il, int iu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (iu < il) {
            throw new IllegalArgumentException("Index exception: make sure iu >= il");
        }
        if (il < 0) {
            throw new IllegalArgumentException("Index exception: make sure il >= 0");
        }
        if (iu > A.rows - 1) {
            throw new IllegalArgumentException("Index exception: make sure iu <= A.rows - 1");
        }
        double abstol = 1.0E-9;
        int[] m = new int[1];
        DoubleMatrix W = new DoubleMatrix(A.rows);
        DoubleMatrix Z = new DoubleMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'N', 'I', 'U', A.dup(), B.dup(), 0.0, 0.0, il + 1, iu + 1, abstol, m, W, Z);
        return W.get((Range)new IntervalRange(0, m[0]), 0);
    }

    public static DoubleMatrix[] symmetricGeneralizedEigenvectors(DoubleMatrix A, DoubleMatrix B, double vl, double vu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (vu <= vl) {
            throw new IllegalArgumentException("Bound exception: make sure vu > vl");
        }
        double abstol = 1.0E-9;
        int[] m = new int[1];
        DoubleMatrix W = new DoubleMatrix(A.rows);
        DoubleMatrix Z = new DoubleMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'V', 'V', 'U', A.dup(), B.dup(), vl, vu, 0, 0, abstol, m, W, Z);
        if (m[0] == 0) {
            throw new NoEigenResultException("No eigenvalues found for selected range");
        }
        DoubleMatrix[] result = new DoubleMatrix[2];
        IntervalRange r = new IntervalRange(0, m[0]);
        result[0] = Z.get((Range)new IntervalRange(0, A.rows), (Range)r);
        result[1] = W.get((Range)r, 0);
        return result;
    }

    public static DoubleMatrix[] symmetricGeneralizedEigenvectors(DoubleMatrix A, DoubleMatrix B, int il, int iu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (iu < il) {
            throw new IllegalArgumentException("Index exception: make sure iu >= il");
        }
        if (il < 0) {
            throw new IllegalArgumentException("Index exception: make sure il >= 0");
        }
        if (iu > A.rows - 1) {
            throw new IllegalArgumentException("Index exception: make sure iu <= A.rows - 1");
        }
        double abstol = 1.0E-9;
        int[] m = new int[1];
        DoubleMatrix W = new DoubleMatrix(A.rows);
        DoubleMatrix Z = new DoubleMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'V', 'I', 'U', A.dup(), B.dup(), 0.0, 0.0, il + 1, iu + 1, abstol, m, W, Z);
        DoubleMatrix[] result = new DoubleMatrix[2];
        IntervalRange r = new IntervalRange(0, m[0]);
        result[0] = Z.get((Range)new IntervalRange(0, A.rows), (Range)r);
        result[1] = W.get((Range)r, 0);
        return result;
    }

    public static FloatMatrix symmetricEigenvalues(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix eigenvalues = new FloatMatrix(A.rows);
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('N', 'A', 'U', A.dup(), 0.0f, 0.0f, 0, 0, 0.0f, eigenvalues, dummyFloat, isuppz);
        return eigenvalues;
    }

    public static FloatMatrix[] symmetricEigenvectors(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix eigenvalues = new FloatMatrix(A.rows);
        FloatMatrix eigenvectors = A.dup();
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('V', 'A', 'U', A.dup(), 0.0f, 0.0f, 0, 0, 0.0f, eigenvalues, eigenvectors, isuppz);
        return new FloatMatrix[]{eigenvectors, FloatMatrix.diag(eigenvalues)};
    }

    public static ComplexFloatMatrix eigenvalues(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix WR = new FloatMatrix(A.rows);
        FloatMatrix WI = WR.dup();
        SimpleBlas.geev('N', 'N', A.dup(), WR, WI, dummyFloat, dummyFloat);
        return new ComplexFloatMatrix(WR, WI);
    }

    public static ComplexFloatMatrix[] eigenvectors(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix WR = new FloatMatrix(A.rows);
        FloatMatrix WI = WR.dup();
        FloatMatrix VR = new FloatMatrix(A.rows, A.rows);
        SimpleBlas.geev('N', 'V', A.dup(), WR, WI, dummyFloat, VR);
        ComplexFloatMatrix E = new ComplexFloatMatrix(WR, WI);
        ComplexFloatMatrix V = new ComplexFloatMatrix(A.rows, A.rows);
        int i = 0;
        while (i < A.rows) {
            if (E.get(i).isReal()) {
                V.putColumn(i, new ComplexFloatMatrix(VR.getColumn(i)));
            } else {
                ComplexFloatMatrix v = new ComplexFloatMatrix(VR.getColumn(i), VR.getColumn(i + 1));
                V.putColumn(i, v);
                V.putColumn(i + 1, v.conji());
                ++i;
            }
            ++i;
        }
        return new ComplexFloatMatrix[]{V, ComplexFloatMatrix.diag(E)};
    }

    public static FloatMatrix symmetricGeneralizedEigenvalues(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        B.assertSquare();
        FloatMatrix W = new FloatMatrix(A.rows);
        SimpleBlas.sygvd(1, 'N', 'U', A.dup(), B.dup(), W);
        return W;
    }

    public static FloatMatrix[] symmetricGeneralizedEigenvectors(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        B.assertSquare();
        FloatMatrix[] result = new FloatMatrix[2];
        FloatMatrix dA = A.dup();
        FloatMatrix dB = B.dup();
        FloatMatrix W = new FloatMatrix(dA.rows);
        SimpleBlas.sygvd(1, 'V', 'U', dA, dB, W);
        result[0] = dA;
        result[1] = W;
        return result;
    }

    public static FloatMatrix symmetricGeneralizedEigenvalues(FloatMatrix A, FloatMatrix B, float vl, float vu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (vu <= vl) {
            throw new IllegalArgumentException("Bound exception: make sure vu > vl");
        }
        float abstol = 1.0E-9f;
        int[] m = new int[1];
        FloatMatrix W = new FloatMatrix(A.rows);
        FloatMatrix Z = new FloatMatrix(A.rows, A.rows);
        SimpleBlas.sygvx(1, 'N', 'V', 'U', A.dup(), B.dup(), vl, vu, 0, 0, abstol, m, W, Z);
        if (m[0] == 0) {
            throw new NoEigenResultException("No eigenvalues found for selected range");
        }
        return W.get((Range)new IntervalRange(0, m[0]), 0);
    }

    public static FloatMatrix symmetricGeneralizedEigenvalues(FloatMatrix A, FloatMatrix B, int il, int iu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (iu < il) {
            throw new IllegalArgumentException("Index exception: make sure iu >= il");
        }
        if (il < 0) {
            throw new IllegalArgumentException("Index exception: make sure il >= 0");
        }
        if (iu > A.rows - 1) {
            throw new IllegalArgumentException("Index exception: make sure iu <= A.rows - 1");
        }
        float abstol = 1.0E-9f;
        int[] m = new int[1];
        FloatMatrix W = new FloatMatrix(A.rows);
        FloatMatrix Z = new FloatMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'N', 'I', 'U', A.dup(), B.dup(), 0.0f, 0.0f, il + 1, iu + 1, abstol, m, W, Z);
        return W.get((Range)new IntervalRange(0, m[0]), 0);
    }

    public static FloatMatrix[] symmetricGeneralizedEigenvectors(FloatMatrix A, FloatMatrix B, float vl, float vu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (vu <= vl) {
            throw new IllegalArgumentException("Bound exception: make sure vu > vl");
        }
        float abstol = 1.0E-9f;
        int[] m = new int[1];
        FloatMatrix W = new FloatMatrix(A.rows);
        FloatMatrix Z = new FloatMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'V', 'V', 'U', A.dup(), B.dup(), vl, vu, 0, 0, abstol, m, W, Z);
        if (m[0] == 0) {
            throw new NoEigenResultException("No eigenvalues found for selected range");
        }
        FloatMatrix[] result = new FloatMatrix[2];
        IntervalRange r = new IntervalRange(0, m[0]);
        result[0] = Z.get((Range)new IntervalRange(0, A.rows), (Range)r);
        result[1] = W.get((Range)r, 0);
        return result;
    }

    public static FloatMatrix[] symmetricGeneralizedEigenvectors(FloatMatrix A, FloatMatrix B, int il, int iu) {
        A.assertSquare();
        B.assertSquare();
        A.assertSameSize(B);
        if (iu < il) {
            throw new IllegalArgumentException("Index exception: make sure iu >= il");
        }
        if (il < 0) {
            throw new IllegalArgumentException("Index exception: make sure il >= 0");
        }
        if (iu > A.rows - 1) {
            throw new IllegalArgumentException("Index exception: make sure iu <= A.rows - 1");
        }
        float abstol = 1.0E-9f;
        int[] m = new int[1];
        FloatMatrix W = new FloatMatrix(A.rows);
        FloatMatrix Z = new FloatMatrix(A.rows, A.columns);
        SimpleBlas.sygvx(1, 'V', 'I', 'U', A.dup(), B.dup(), 0.0f, 0.0f, il + 1, iu + 1, abstol, m, W, Z);
        FloatMatrix[] result = new FloatMatrix[2];
        IntervalRange r = new IntervalRange(0, m[0]);
        result[0] = Z.get((Range)new IntervalRange(0, A.rows), (Range)r);
        result[1] = W.get((Range)r, 0);
        return result;
    }
}

